/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Comment;
import lombok.ast.JavadocContainer;
import lombok.ast.Node;
import lombok.ast.Statement;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeMemberMixin;
import lombok.ast.VariableDeclarationTemplate;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;

public class VariableDeclaration
extends AbstractNode
implements Statement,
TypeMember,
JavadocContainer {
    private AbstractNode javadoc = null;
    private AbstractNode definition = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public TypeBody upToTypeBody() {
        if (!(this.getParent() instanceof TypeBody)) {
            return null;
        }
        TypeBody out = (TypeBody)this.getParent();
        if (!out.rawMembers().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public Comment astJavadoc() {
        if (!(this.javadoc instanceof Comment)) {
            return null;
        }
        return (Comment)this.javadoc;
    }

    @Override
    public VariableDeclaration astJavadoc(Comment javadoc) {
        return this.rawJavadoc(javadoc);
    }

    @Override
    public Node rawJavadoc() {
        return this.javadoc;
    }

    @Override
    public VariableDeclaration rawJavadoc(Node javadoc) {
        if (javadoc == this.javadoc) {
            return this;
        }
        if (javadoc != null) {
            this.adopt((AbstractNode)javadoc);
        }
        if (this.javadoc != null) {
            this.disown(this.javadoc);
        }
        this.javadoc = (AbstractNode)javadoc;
        return this;
    }

    public VariableDefinition astDefinition() {
        if (!(this.definition instanceof VariableDefinition)) {
            return null;
        }
        return (VariableDefinition)this.definition;
    }

    public VariableDeclaration astDefinition(VariableDefinition definition) {
        if (definition == null) {
            throw new NullPointerException("definition is mandatory");
        }
        return this.rawDefinition(definition);
    }

    public Node rawDefinition() {
        return this.definition;
    }

    public VariableDeclaration rawDefinition(Node definition) {
        if (definition == this.definition) {
            return this;
        }
        if (definition != null) {
            this.adopt((AbstractNode)definition);
        }
        if (this.definition != null) {
            this.disown(this.definition);
        }
        this.definition = (AbstractNode)definition;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.javadoc != null) {
            result.add(this.javadoc);
        }
        if (this.definition != null) {
            result.add(this.definition);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.javadoc == original) {
            this.rawJavadoc(replacement);
            return true;
        }
        if (this.definition == original) {
            this.rawDefinition(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.javadoc == child) {
            this.disown((AbstractNode)child);
            this.javadoc = null;
            return true;
        }
        if (this.definition == child) {
            this.disown((AbstractNode)child);
            this.definition = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitVariableDeclaration(this)) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.accept(visitor);
        }
        if (this.definition != null) {
            this.definition.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public VariableDeclaration copy() {
        VariableDeclaration result = new VariableDeclaration();
        if (this.javadoc != null) {
            result.rawJavadoc(this.javadoc.copy());
        }
        if (this.definition != null) {
            result.rawDefinition(this.definition.copy());
        }
        return result;
    }

    public StrictListAccessor<VariableDefinitionEntry, VariableDeclaration> getVariableDefinitionEntries() {
        return VariableDeclarationTemplate.getVariableDefinitionEntries(this);
    }

    public TypeDeclaration upUpToTypeDeclaration() {
        return TypeMemberMixin.upUpToTypeDeclaration(this);
    }
}

