/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.Immutable;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ElementsTrimmer;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.PositionImpl;
import com.android.manifmerger.PostValidator;
import com.android.manifmerger.PreValidator;
import com.android.manifmerger.ToolsInstructionsCleaner;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.android.utils.StdLogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public class ManifestMerger2 {
    @NonNull
    private final File mManifestFile;
    @NonNull
    private final Map<String, Object> mPlaceHolderValues;
    @NonNull
    private final PlaceholderHandler.KeyBasedValueResolver<SystemProperty> mSystemPropertyResolver;
    private final ILogger mLogger;
    private final ImmutableList<Pair<String, File>> mLibraryFiles;
    private final ImmutableList<File> mFlavorsAndBuildTypeFiles;
    private final ImmutableList<Invoker.Feature> mOptionalFeatures;
    private final MergeType mMergeType;
    private final Optional<File> mReportFile;

    private ManifestMerger2(@NonNull ILogger logger, @NonNull File mainManifestFile, @NonNull ImmutableList<Pair<String, File>> libraryFiles, @NonNull ImmutableList<File> flavorsAndBuildTypeFiles, @NonNull ImmutableList<Invoker.Feature> optionalFeatures, @NonNull Map<String, Object> placeHolderValues, @NonNull PlaceholderHandler.KeyBasedValueResolver<SystemProperty> systemPropertiesResolver, @NonNull MergeType mergeType, @NonNull Optional<File> reportFile) {
        this.mSystemPropertyResolver = systemPropertiesResolver;
        this.mPlaceHolderValues = placeHolderValues;
        this.mManifestFile = mainManifestFile;
        this.mLogger = logger;
        this.mLibraryFiles = libraryFiles;
        this.mFlavorsAndBuildTypeFiles = flavorsAndBuildTypeFiles;
        this.mOptionalFeatures = optionalFeatures;
        this.mMergeType = mergeType;
        this.mReportFile = reportFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MergingReport merge() throws MergeFailureException {
        String mainManifestPackageName;
        MergingReport.Builder mergingReportBuilder = new MergingReport.Builder(this.mLogger);
        SelectorResolver selectors = new SelectorResolver();
        List<LoadedManifestInfo> loadedLibraryDocuments = this.loadLibraries(selectors, mergingReportBuilder);
        LoadedManifestInfo loadedMainManifestInfo = this.load(new ManifestInfo(this.mManifestFile.getName(), this.mManifestFile, XmlDocument.Type.MAIN, Optional.absent()), selectors, mergingReportBuilder);
        Optional<XmlAttribute> mainPackageAttribute = loadedMainManifestInfo.getXmlDocument().getPackage();
        if (!mainPackageAttribute.isPresent()) {
            mergingReportBuilder.addMessage(loadedMainManifestInfo.getXmlDocument().getSourceLocation(), 0, 0, MergingReport.Record.Severity.ERROR, String.format("Main AndroidManifest.xml at %1$s manifest:package attribute is not declared", loadedMainManifestInfo.getXmlDocument().getSourceLocation().print(true)));
            return mergingReportBuilder.build();
        }
        ImmutableMap finalPlaceHolderValues = this.mPlaceHolderValues;
        if (!this.mPlaceHolderValues.containsKey("applicationId")) {
            finalPlaceHolderValues = ImmutableMap.builder().putAll(this.mPlaceHolderValues).put((Object)"packageName", (Object)((XmlAttribute)mainPackageAttribute.get()).getValue()).put((Object)"applicationId", (Object)((XmlAttribute)mainPackageAttribute.get()).getValue()).build();
        }
        this.performSystemPropertiesInjection(mergingReportBuilder, loadedMainManifestInfo.getXmlDocument());
        loadedMainManifestInfo = new LoadedManifestInfo(loadedMainManifestInfo, loadedMainManifestInfo.getOriginalPackageName(), loadedMainManifestInfo.getXmlDocument().reparse());
        Optional<XmlDocument> xmlDocumentOptional = Optional.absent();
        for (File inputFile : this.mFlavorsAndBuildTypeFiles) {
            this.mLogger.info("Merging flavors and build manifest %s \n", inputFile.getPath());
            LoadedManifestInfo overlayDocument = this.load(new ManifestInfo(null, inputFile, XmlDocument.Type.OVERLAY, Optional.of((Object)((XmlAttribute)mainPackageAttribute.get()).getValue())), selectors, mergingReportBuilder);
            Optional<XmlAttribute> packageAttribute = overlayDocument.getXmlDocument().getPackage();
            if (loadedMainManifestInfo.getOriginalPackageName().isPresent() && packageAttribute.isPresent() && !((String)loadedMainManifestInfo.getOriginalPackageName().get()).equals(((XmlAttribute)packageAttribute.get()).getValue())) {
                String message = this.mMergeType == MergeType.APPLICATION ? String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\thas a different value=(%3$s) declared in main manifest at %4$s\n\tSuggestion: remove the overlay declaration at %5$s \tand place it in the build.gradle:\n\t\tflavorName {\n\t\t\tapplicationId = \"%2$s\"\n\t\t}", ((XmlAttribute)packageAttribute.get()).printPosition(), ((XmlAttribute)packageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).printPosition(), ((XmlAttribute)packageAttribute.get()).getSourceLocation().print(true)) : String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\thas a different value=(%3$s) declared in main manifest at %4$s", ((XmlAttribute)packageAttribute.get()).printPosition(), ((XmlAttribute)packageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).printPosition());
                mergingReportBuilder.addMessage(overlayDocument.getXmlDocument().getSourceLocation(), 0, 0, MergingReport.Record.Severity.ERROR, message);
                return mergingReportBuilder.build();
            }
            overlayDocument.getXmlDocument().getRootNode().getXml().setAttribute("package", ((XmlAttribute)mainPackageAttribute.get()).getValue());
            if ((xmlDocumentOptional = this.merge(xmlDocumentOptional, overlayDocument, mergingReportBuilder)).isPresent()) continue;
            return mergingReportBuilder.build();
        }
        this.mLogger.info("Merging main manifest %s\n", this.mManifestFile.getPath());
        xmlDocumentOptional = this.merge(xmlDocumentOptional, loadedMainManifestInfo, mergingReportBuilder);
        if (!xmlDocumentOptional.isPresent()) {
            return mergingReportBuilder.build();
        }
        if (this.mMergeType == MergeType.LIBRARY && !Strings.isNullOrEmpty((String)(mainManifestPackageName = loadedMainManifestInfo.getXmlDocument().getRootNode().getXml().getAttribute("package")))) {
            ((XmlDocument)xmlDocumentOptional.get()).getRootNode().getXml().setAttribute("package", mainManifestPackageName);
        }
        for (LoadedManifestInfo libraryDocument : loadedLibraryDocuments) {
            this.mLogger.info("Merging library manifest " + libraryDocument.getLocation(), new Object[0]);
            if ((xmlDocumentOptional = this.merge(xmlDocumentOptional, libraryDocument, mergingReportBuilder)).isPresent()) continue;
            return mergingReportBuilder.build();
        }
        ElementsTrimmer.trim((XmlDocument)xmlDocumentOptional.get(), mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        MapBasedKeyBasedValueResolver<String> placeHolderValueResolver = new MapBasedKeyBasedValueResolver<String>((Map<String, Object>)finalPlaceHolderValues);
        PlaceholderHandler placeholderHandler = new PlaceholderHandler();
        placeholderHandler.visit(this.mMergeType, (XmlDocument)xmlDocumentOptional.get(), placeHolderValueResolver, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        this.performSystemPropertiesInjection(mergingReportBuilder, (XmlDocument)xmlDocumentOptional.get());
        XmlDocument finalMergedDocument = (XmlDocument)xmlDocumentOptional.get();
        PostValidator.validate(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            finalMergedDocument.getRootNode().addMessage(mergingReportBuilder, MergingReport.Record.Severity.WARNING, "Post merge validation failed");
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            finalMergedDocument = ToolsInstructionsCleaner.cleanToolsReferences(finalMergedDocument, this.mLogger);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.EXTRACT_FQCNS)) {
            this.extractFcqns(finalMergedDocument);
        }
        if (finalMergedDocument != null) {
            mergingReportBuilder.setMergedDocument(finalMergedDocument);
        }
        MergingReport build = mergingReportBuilder.build();
        StdLogger stdLogger = new StdLogger(StdLogger.Level.INFO);
        build.log(stdLogger);
        stdLogger.verbose(((XmlDocument)build.getMergedDocument().get()).prettyPrint(), new Object[0]);
        if (!this.mReportFile.isPresent()) return build;
        OutputStreamWriter fileWriter = null;
        if (!((File)this.mReportFile.get()).getParentFile().exists() && !((File)this.mReportFile.get()).getParentFile().mkdirs()) {
            this.mLogger.warning(String.format("Cannot create %1$s manifest merger report file,build will continue but merging activities will not be documented", ((File)this.mReportFile.get()).getAbsolutePath()), new Object[0]);
        } else {
            fileWriter = new FileWriter((File)this.mReportFile.get());
            build.getActions().log((FileWriter)fileWriter);
        }
        if (fileWriter == null) return build;
        try {
            fileWriter.close();
            return build;
        }
        catch (IOException e) {
            this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
        }
        return build;
        catch (IOException e) {
            try {
                this.mLogger.warning(String.format("Error '%1$s' while writing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
                if (fileWriter == null) return build;
            }
            catch (Throwable throwable) {
                if (fileWriter == null) throw throwable;
                try {
                    fileWriter.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e2.getMessage()), new Object[0]);
                }
                throw throwable;
            }
            try {
                fileWriter.close();
                return build;
            }
            catch (IOException e3) {
                this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e3.getMessage()), new Object[0]);
            }
            return build;
        }
    }

    private void extractFcqns(XmlDocument finalMergedDocument) {
        this.extractFcqns(finalMergedDocument.getPackageName(), finalMergedDocument.getRootNode());
    }

    private void extractFcqns(String packageName, XmlElement xmlElement) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            String value;
            if (xmlAttribute.getModel() == null || !xmlAttribute.getModel().isPackageDependent() || (value = xmlAttribute.getValue()) == null || !value.startsWith(packageName) || value.charAt(packageName.length()) != '.') continue;
            xmlAttribute.getXml().setValue(value.substring(packageName.length()));
        }
        for (XmlElement child : xmlElement.getMergeableElements()) {
            this.extractFcqns(packageName, child);
        }
    }

    private LoadedManifestInfo load(ManifestInfo manifestInfo, KeyResolver<String> selectors, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        XmlDocument xmlDocument;
        try {
            xmlDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, manifestInfo.mLocation, manifestInfo.getType(), manifestInfo.getMainManifestPackageName());
        }
        catch (Exception e) {
            throw new MergeFailureException(e);
        }
        String originalPackageName = xmlDocument.getPackageName();
        MergingReport.Builder builder = manifestInfo.getType() == XmlDocument.Type.MAIN ? mergingReportBuilder : new MergingReport.Builder(mergingReportBuilder.getLogger());
        builder.getActionRecorder().recordDefaultNodeAction(xmlDocument.getRootNode());
        this.performPlaceHolderSubstitution(manifestInfo, xmlDocument, builder);
        return new LoadedManifestInfo(manifestInfo, Optional.fromNullable((Object)originalPackageName), xmlDocument);
    }

    private void performPlaceHolderSubstitution(ManifestInfo manifestInfo, XmlDocument xmlDocument, MergingReport.Builder mergingReportBuilder) {
        ImmutableMap finalPlaceHolderValues = this.mPlaceHolderValues;
        if (!this.mPlaceHolderValues.containsKey("applicationId")) {
            String packageName = manifestInfo.getMainManifestPackageName().isPresent() ? (String)manifestInfo.getMainManifestPackageName().get() : xmlDocument.getPackageName();
            finalPlaceHolderValues = ImmutableMap.builder().putAll(this.mPlaceHolderValues).put((Object)"packageName", (Object)packageName).put((Object)"applicationId", (Object)packageName).build();
        }
        MapBasedKeyBasedValueResolver<String> placeHolderValueResolver = new MapBasedKeyBasedValueResolver<String>((Map<String, Object>)finalPlaceHolderValues);
        PlaceholderHandler placeholderHandler = new PlaceholderHandler();
        placeholderHandler.visit(this.mMergeType, xmlDocument, placeHolderValueResolver, mergingReportBuilder);
    }

    private Optional<XmlDocument> merge(Optional<XmlDocument> xmlDocument, LoadedManifestInfo lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        Optional result;
        MergingReport.Result validationResult = PreValidator.validate(mergingReportBuilder, lowerPriorityDocument.getXmlDocument());
        if (validationResult == MergingReport.Result.ERROR) {
            mergingReportBuilder.addMessage(lowerPriorityDocument.getXmlDocument().getSourceLocation(), 0, 0, MergingReport.Record.Severity.ERROR, "Validation failed, exiting");
            return Optional.absent();
        }
        if (xmlDocument.isPresent()) {
            result = ((XmlDocument)xmlDocument.get()).merge(lowerPriorityDocument.getXmlDocument(), mergingReportBuilder);
        } else {
            mergingReportBuilder.getActionRecorder().recordDefaultNodeAction(lowerPriorityDocument.getXmlDocument().getRootNode());
            result = Optional.of((Object)lowerPriorityDocument.getXmlDocument());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_INTERMEDIARY_STAGES) && result.isPresent()) {
            mergingReportBuilder.addMergingStage(((XmlDocument)result.get()).prettyPrint());
        }
        return result;
    }

    private List<LoadedManifestInfo> loadLibraries(SelectorResolver selectors, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        ImmutableList.Builder loadedLibraryDocuments = ImmutableList.builder();
        for (Pair libraryFile : this.mLibraryFiles) {
            XmlDocument libraryDocument;
            this.mLogger.info("Loading library manifest " + ((File)libraryFile.getSecond()).getPath(), new Object[0]);
            ManifestInfo manifestInfo = new ManifestInfo((String)libraryFile.getFirst(), (File)libraryFile.getSecond(), XmlDocument.Type.LIBRARY, Optional.absent());
            try {
                libraryDocument = XmlLoader.load((KeyResolver<String>)selectors, this.mSystemPropertyResolver, manifestInfo.mName, manifestInfo.mLocation, XmlDocument.Type.LIBRARY, (Optional<String>)Optional.absent());
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
            String libraryPackage = libraryDocument.getRootNode().getXml().getAttribute("package");
            if (!Strings.isNullOrEmpty((String)libraryPackage)) {
                selectors.addSelector(libraryPackage, (String)libraryFile.getFirst());
            }
            MergingReport.Builder builder = new MergingReport.Builder(mergingReportBuilder.getLogger());
            builder.getActionRecorder().recordDefaultNodeAction(libraryDocument.getRootNode());
            this.performPlaceHolderSubstitution(manifestInfo, libraryDocument, builder);
            if (builder.hasErrors()) {
                builder.build().log(this.mLogger);
            }
            loadedLibraryDocuments.add((Object)new LoadedManifestInfo(manifestInfo, Optional.fromNullable((Object)libraryDocument.getPackageName()), libraryDocument));
        }
        return loadedLibraryDocuments.build();
    }

    public static Invoker newMerger(@NonNull File mainManifestFile, @NonNull ILogger logger, @NonNull MergeType mergeType) {
        return new Invoker(mainManifestFile, logger, mergeType);
    }

    private static String getAndroidPrefix(Element xml) {
        String toolsPrefix = XmlUtils.lookupNamespacePrefix(xml, "http://schemas.android.com/apk/res/android", "android", false);
        if (!toolsPrefix.equals("android") && xml.getOwnerDocument().getDocumentElement().getAttribute("xmlns:" + toolsPrefix) == null) {
            xml.setAttribute("xmlns:" + toolsPrefix, "http://schemas.android.com/apk/res/android");
        }
        return toolsPrefix;
    }

    protected void performSystemPropertiesInjection(MergingReport.Builder mergingReport, XmlDocument xmlDocument) {
        for (SystemProperty systemProperty : SystemProperty.values()) {
            String propertyOverride = this.mSystemPropertyResolver.getValue(systemProperty);
            if (propertyOverride == null) continue;
            systemProperty.addTo(mergingReport.getActionRecorder(), xmlDocument, propertyOverride);
        }
    }

    public static class MergeFailureException
    extends Exception {
        protected MergeFailureException(Exception cause) {
            super(cause);
        }
    }

    static class SelectorResolver
    implements KeyResolver<String> {
        private final Map<String, String> mSelectors = new HashMap<String, String>();

        SelectorResolver() {
        }

        protected void addSelector(String key, String value) {
            this.mSelectors.put(key, value);
        }

        @Override
        @Nullable
        public String resolve(String key) {
            return this.mSelectors.get(key);
        }

        @Override
        public Iterable<String> getKeys() {
            return this.mSelectors.keySet();
        }
    }

    private static class LoadedManifestInfo
    extends ManifestInfo {
        @NonNull
        private final XmlDocument mXmlDocument;
        @NonNull
        private final Optional<String> mOriginalPackageName;

        private LoadedManifestInfo(@NonNull ManifestInfo manifestInfo, @NonNull Optional<String> originalPackageName, @NonNull XmlDocument xmlDocument) {
            super(manifestInfo.mName, manifestInfo.mLocation, manifestInfo.mType, manifestInfo.getMainManifestPackageName());
            this.mXmlDocument = xmlDocument;
            this.mOriginalPackageName = originalPackageName;
        }

        @NonNull
        public XmlDocument getXmlDocument() {
            return this.mXmlDocument;
        }

        @NonNull
        public Optional<String> getOriginalPackageName() {
            return this.mOriginalPackageName;
        }
    }

    private static class ManifestInfo {
        private final String mName;
        private final File mLocation;
        private final XmlDocument.Type mType;
        private final Optional<String> mMainManifestPackageName;

        private ManifestInfo(String name, File location, XmlDocument.Type type, Optional<String> mainManifestPackageName) {
            this.mName = name;
            this.mLocation = location;
            this.mType = type;
            this.mMainManifestPackageName = mainManifestPackageName;
        }

        File getLocation() {
            return this.mLocation;
        }

        XmlDocument.Type getType() {
            return this.mType;
        }

        Optional<String> getMainManifestPackageName() {
            return this.mMainManifestPackageName;
        }
    }

    public static class MapBasedKeyBasedValueResolver<T>
    implements PlaceholderHandler.KeyBasedValueResolver<T> {
        private final ImmutableMap<T, Object> keyValues;

        public MapBasedKeyBasedValueResolver(Map<T, Object> keyValues) {
            this.keyValues = ImmutableMap.copyOf(keyValues);
        }

        @Override
        @Nullable
        public String getValue(@NonNull T key) {
            Object value = this.keyValues.get(key);
            return value == null ? null : value.toString();
        }
    }

    public static final class Invoker<T extends Invoker<T>> {
        protected final File mMainManifestFile;
        protected final ImmutableMap.Builder<SystemProperty, Object> mSystemProperties = new ImmutableMap.Builder();
        protected final ILogger mLogger;
        protected final ImmutableMap.Builder<String, Object> mPlaceHolders = new ImmutableMap.Builder();
        private final ImmutableList.Builder<Pair<String, File>> mLibraryFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mFlavorsAndBuildTypeFiles = new ImmutableList.Builder();
        private final ImmutableList.Builder<Feature> mFeaturesBuilder = new ImmutableList.Builder();
        private final MergeType mMergeType;
        @Nullable
        private File mReportFile;

        public Invoker setOverride(SystemProperty override, String value) {
            this.mSystemProperties.put((Object)override, (Object)value);
            return this.thisAsT();
        }

        public Invoker setPlaceHolderValues(Map<String, String> keyValuePairs) {
            this.mPlaceHolders.putAll(keyValuePairs);
            return this.thisAsT();
        }

        public Invoker setPlaceHolderValue(String placeHolderName, String value) {
            this.mPlaceHolders.put((Object)placeHolderName, (Object)value);
            return this.thisAsT();
        }

        private Invoker(@NonNull File mainManifestFile, @NonNull ILogger logger, MergeType mergeType) {
            this.mMainManifestFile = (File)Preconditions.checkNotNull((Object)mainManifestFile);
            this.mLogger = logger;
            this.mMergeType = mergeType;
        }

        public Invoker setMergeReportFile(@NonNull File mergeReport) {
            this.mReportFile = mergeReport;
            return this;
        }

        public Invoker addLibraryManifest(File file) {
            if (this.mMergeType == MergeType.LIBRARY) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.add(Pair.of(file.getName(), file));
            return this.thisAsT();
        }

        public Invoker addLibraryManifests(List<Pair<String, File>> namesAndFiles) {
            if (this.mMergeType == MergeType.LIBRARY && !namesAndFiles.isEmpty()) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.addAll(namesAndFiles);
            return this.thisAsT();
        }

        public Invoker addLibraryManifests(File ... files) {
            for (File file : files) {
                this.addLibraryManifest(file);
            }
            return this.thisAsT();
        }

        public Invoker addFlavorAndBuildTypeManifest(File file) {
            this.mFlavorsAndBuildTypeFiles.add((Object)file);
            return this.thisAsT();
        }

        public Invoker addFlavorAndBuildTypeManifests(File ... files) {
            this.mFlavorsAndBuildTypeFiles.add((Object[])files);
            return this.thisAsT();
        }

        public Invoker withFeatures(Feature ... features) {
            this.mFeaturesBuilder.add((Object[])features);
            return this.thisAsT();
        }

        public MergingReport merge() throws MergeFailureException {
            ImmutableMap systemProperties = this.mSystemProperties.build();
            if (systemProperties.containsKey((Object)SystemProperty.PACKAGE)) {
                this.mPlaceHolders.put((Object)"packageName", systemProperties.get((Object)SystemProperty.PACKAGE));
                this.mPlaceHolders.put((Object)"applicationId", systemProperties.get((Object)SystemProperty.PACKAGE));
            }
            ManifestMerger2 manifestMerger = new ManifestMerger2(this.mLogger, this.mMainManifestFile, this.mLibraryFilesBuilder.build(), this.mFlavorsAndBuildTypeFiles.build(), this.mFeaturesBuilder.build(), (Map)this.mPlaceHolders.build(), new MapBasedKeyBasedValueResolver(systemProperties), this.mMergeType, Optional.fromNullable((Object)this.mReportFile));
            return manifestMerger.merge();
        }

        private T thisAsT() {
            return (T)this;
        }

        public static enum Feature {
            KEEP_INTERMEDIARY_STAGES,
            PRINT_SIMPLE_FILENAMES,
            EXTRACT_FQCNS,
            REMOVE_TOOLS_DECLARATIONS;

        }
    }

    public static interface AutoAddingProperty {
        public void addTo(@NonNull ActionRecorder var1, @NonNull XmlDocument var2, @NonNull String var3);
    }

    public static enum MergeType {
        APPLICATION,
        LIBRARY;

    }

    public static enum SystemProperty implements AutoAddingProperty
    {
        PACKAGE{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElement((SystemProperty)this, actionRecorder, value, document.getRootNode());
            }
        }
        ,
        VERSION_CODE{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, document.getRootNode());
            }
        }
        ,
        VERSION_NAME{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, document.getRootNode());
            }
        }
        ,
        MIN_SDK_VERSION{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, SystemProperty.createOrGetUseSdk(actionRecorder, document));
            }
        }
        ,
        TARGET_SDK_VERSION{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, SystemProperty.createOrGetUseSdk(actionRecorder, document));
            }
        }
        ,
        MAX_SDK_VERSION{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, SystemProperty.createOrGetUseSdk(actionRecorder, document));
            }
        };


        public String toCamelCase() {
            return SdkUtils.constantNameToCamelCase(this.name());
        }

        private static void addToElement(SystemProperty systemProperty, ActionRecorder actionRecorder, String value, XmlElement to) {
            to.getXml().setAttribute(systemProperty.toCamelCase(), value);
            XmlAttribute xmlAttribute = new XmlAttribute(to, to.getXml().getAttributeNode(systemProperty.toCamelCase()), null);
            actionRecorder.recordAttributeAction(xmlAttribute, new Actions.AttributeRecord(Actions.ActionType.INJECTED, new Actions.ActionLocation(to.getSourceLocation(), PositionImpl.UNKNOWN), xmlAttribute.getId(), null, null));
        }

        private static void addToElementInAndroidNS(SystemProperty systemProperty, ActionRecorder actionRecorder, String value, XmlElement to) {
            String toolsPrefix = ManifestMerger2.getAndroidPrefix(to.getXml());
            to.getXml().setAttributeNS("http://schemas.android.com/apk/res/android", toolsPrefix + ':' + systemProperty.toCamelCase(), value);
            Attr attr = to.getXml().getAttributeNodeNS("http://schemas.android.com/apk/res/android", systemProperty.toCamelCase());
            XmlAttribute xmlAttribute = new XmlAttribute(to, attr, null);
            actionRecorder.recordAttributeAction(xmlAttribute, new Actions.AttributeRecord(Actions.ActionType.INJECTED, new Actions.ActionLocation(to.getSourceLocation(), PositionImpl.UNKNOWN), xmlAttribute.getId(), null, null));
        }

        private static XmlElement createOrGetUseSdk(ActionRecorder actionRecorder, XmlDocument document) {
            Element manifest = document.getXml().getDocumentElement();
            NodeList usesSdks = manifest.getElementsByTagName(ManifestModel.NodeTypes.USES_SDK.toXmlName());
            if (usesSdks.getLength() == 0) {
                usesSdks = manifest.getElementsByTagNameNS("http://schemas.android.com/apk/res/android", ManifestModel.NodeTypes.USES_SDK.toXmlName());
            }
            if (usesSdks.getLength() == 0) {
                Element useSdk = manifest.getOwnerDocument().createElement(ManifestModel.NodeTypes.USES_SDK.toXmlName());
                manifest.appendChild(useSdk);
                XmlElement xmlElement = new XmlElement(useSdk, document);
                Actions.NodeRecord nodeRecord = new Actions.NodeRecord(Actions.ActionType.INJECTED, new Actions.ActionLocation(xmlElement.getSourceLocation(), PositionImpl.UNKNOWN), xmlElement.getId(), "use-sdk injection requested", NodeOperationType.STRICT);
                actionRecorder.recordNodeAction(xmlElement, nodeRecord);
                return xmlElement;
            }
            return new XmlElement((Element)usesSdks.item(0), document);
        }
    }
}

