/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.base.Preconditions;
import org.python.google.common.util.concurrent.AbstractCheckedFuture;
import org.python.google.common.util.concurrent.AbstractListenableFuture;
import org.python.google.common.util.concurrent.CheckedFuture;
import org.python.google.common.util.concurrent.ExecutionList;
import org.python.google.common.util.concurrent.ForwardingFuture;
import org.python.google.common.util.concurrent.ListenableFuture;
import org.python.google.common.util.concurrent.MoreExecutors;
import org.python.google.common.util.concurrent.UninterruptibleFuture;
import org.python.google.common.util.concurrent.ValueFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Futures {
    private Futures() {
    }

    public static <V> UninterruptibleFuture<V> makeUninterruptible(final Future<V> future2) {
        Preconditions.checkNotNull(future2);
        if (future2 instanceof UninterruptibleFuture) {
            return (UninterruptibleFuture)future2;
        }
        return new UninterruptibleFuture<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future2.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future2.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future2.isDone();
            }

            @Override
            public V get(long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, ExecutionException {
                boolean interrupted = false;
                try {
                    long timeoutNanos = timeoutUnit.toNanos(timeoutDuration);
                    long end = System.nanoTime() + timeoutNanos;
                    while (true) {
                        Object v;
                        try {
                            v = future2.get(timeoutNanos, TimeUnit.NANOSECONDS);
                        }
                        catch (InterruptedException e) {
                            timeoutNanos = end - System.nanoTime();
                            interrupted = true;
                            continue;
                        }
                        return v;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public V get() throws ExecutionException {
                boolean interrupted = false;
                while (true) {
                    try {
                        Object v = future2.get();
                        return v;
                    }
                    catch (InterruptedException ignored) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    public static <V> ListenableFuture<V> makeListenable(Future<V> future2) {
        if (future2 instanceof ListenableFuture) {
            return (ListenableFuture)future2;
        }
        return new ListenableFutureAdapter<V>(future2);
    }

    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(Future<V> future2, Function<Exception, X> mapper) {
        return new MappingCheckedFuture<V, X>(Futures.makeListenable(future2), mapper);
    }

    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        ValueFuture<V> future2 = ValueFuture.create();
        future2.set(value);
        return future2;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V value) {
        ValueFuture<V> future2 = ValueFuture.create();
        future2.set(value);
        return Futures.makeChecked(future2, new Function<Exception, X>(){

            @Override
            public X apply(Exception e) {
                throw new AssertionError((Object)"impossible");
            }
        });
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ValueFuture future2 = ValueFuture.create();
        future2.setException(throwable);
        return future2;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(final X exception) {
        Preconditions.checkNotNull(exception);
        return Futures.makeChecked(Futures.immediateFailedFuture(exception), new Function<Exception, X>(){

            @Override
            public X apply(Exception e) {
                return exception;
            }
        });
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function) {
        return Futures.chain(input, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor exec) {
        ChainingListenableFuture chain = new ChainingListenableFuture(function, input);
        input.addListener(chain, exec);
        return chain;
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future2, Function<? super I, ? extends O> function) {
        return Futures.compose(future2, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future2, final Function<? super I, ? extends O> function, Executor exec) {
        Preconditions.checkNotNull(function);
        Function wrapperFunction = new Function<I, ListenableFuture<O>>(){

            @Override
            public ListenableFuture<O> apply(I input) {
                Object output = function.apply(input);
                return Futures.immediateFuture(output);
            }
        };
        return Futures.chain(future2, wrapperFunction, exec);
    }

    public static <I, O> Future<O> compose(final Future<I> future2, final Function<? super I, ? extends O> function) {
        if (future2 instanceof ListenableFuture) {
            return Futures.compose((ListenableFuture)future2, function);
        }
        Preconditions.checkNotNull(future2);
        Preconditions.checkNotNull(function);
        return new Future<O>(){
            private final Object lock = new Object();
            private boolean set = false;
            private O value = null;
            private ExecutionException exception = null;

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.apply(future2.get());
            }

            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.apply(future2.get(timeout, unit));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private O apply(I raw) throws ExecutionException {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.set) {
                        try {
                            this.value = function.apply(raw);
                        }
                        catch (RuntimeException e) {
                            this.exception = new ExecutionException(e);
                        }
                        catch (Error e) {
                            this.exception = new ExecutionException(e);
                        }
                        this.set = true;
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.value;
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future2.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future2.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future2.isDone();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenableFutureAdapter<V>
    extends ForwardingFuture<V>
    implements ListenableFuture<V> {
        private static final Executor adapterExecutor = Executors.newCachedThreadPool();
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<V> delegate;

        ListenableFutureAdapter(Future<V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected Future<V> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(Runnable listener, Executor exec) {
            if (!this.hasListeners.get() && this.hasListeners.compareAndSet(false, true)) {
                adapterExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ListenableFutureAdapter.this.delegate.get();
                        }
                        catch (CancellationException e) {
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException("Adapter thread interrupted!", e);
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        ListenableFutureAdapter.this.executionList.run();
                    }
                });
            }
            this.executionList.add(listener, exec);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> delegate, Function<Exception, X> mapper) {
            super(delegate);
            this.mapper = Preconditions.checkNotNull(mapper);
        }

        @Override
        protected X mapException(Exception e) {
            return (X)((Exception)this.mapper.apply(e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainingListenableFuture<I, O>
    extends AbstractListenableFuture<O>
    implements Runnable {
        private Function<? super I, ? extends ListenableFuture<? extends O>> function;
        private ListenableFuture<? extends I> inputFuture;
        private volatile ListenableFuture<? extends O> outputFuture;
        private final BlockingQueue<Boolean> mayInterruptIfRunningChannel = new LinkedBlockingQueue<Boolean>(1);
        private final CountDownLatch outputCreated = new CountDownLatch(1);

        private ChainingListenableFuture(Function<? super I, ? extends ListenableFuture<? extends O>> function, ListenableFuture<? extends I> inputFuture) {
            this.function = Preconditions.checkNotNull(function);
            this.inputFuture = Preconditions.checkNotNull(inputFuture);
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            if (!this.isDone()) {
                ListenableFuture<I> inputFuture = this.inputFuture;
                if (inputFuture != null) {
                    inputFuture.get();
                }
                this.outputCreated.await();
                ListenableFuture<O> outputFuture = this.outputFuture;
                if (outputFuture != null) {
                    outputFuture.get();
                }
            }
            return (O)super.get();
        }

        @Override
        public O get(long timeout, TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
            if (!this.isDone()) {
                long start;
                ListenableFuture<I> inputFuture;
                if (unit != TimeUnit.NANOSECONDS) {
                    timeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
                    unit = TimeUnit.NANOSECONDS;
                }
                if ((inputFuture = this.inputFuture) != null) {
                    start = System.nanoTime();
                    inputFuture.get(timeout, unit);
                    timeout -= Math.max(0L, System.nanoTime() - start);
                }
                start = System.nanoTime();
                if (!this.outputCreated.await(timeout, unit)) {
                    throw new TimeoutException();
                }
                timeout -= Math.max(0L, System.nanoTime() - start);
                ListenableFuture<O> outputFuture = this.outputFuture;
                if (outputFuture != null) {
                    outputFuture.get(timeout, unit);
                }
            }
            return (O)super.get(timeout, unit);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.cancel()) {
                try {
                    this.mayInterruptIfRunningChannel.put(mayInterruptIfRunning);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                this.cancel(this.inputFuture, mayInterruptIfRunning);
                this.cancel(this.outputFuture, mayInterruptIfRunning);
                return true;
            }
            return false;
        }

        private void cancel(@Nullable Future<?> future2, boolean mayInterruptIfRunning) {
            if (future2 != null) {
                future2.cancel(mayInterruptIfRunning);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block18: {
                try {
                    I sourceResult;
                    try {
                        sourceResult = Futures.makeUninterruptible(this.inputFuture).get();
                    }
                    catch (CancellationException e) {
                        this.cancel();
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    catch (ExecutionException e) {
                        this.setException(e.getCause());
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    this.outputFuture = this.function.apply(sourceResult);
                    final ListenableFuture<O> outputFuture = this.outputFuture;
                    if (this.isCancelled()) {
                        try {
                            outputFuture.cancel(this.mayInterruptIfRunningChannel.take());
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                        this.outputFuture = null;
                        return;
                    }
                    outputFuture.addListener(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ChainingListenableFuture.this.set(Futures.makeUninterruptible(outputFuture).get());
                            }
                            catch (CancellationException e) {
                                ChainingListenableFuture.this.cancel();
                                return;
                            }
                            catch (ExecutionException e) {
                                ChainingListenableFuture.this.setException(e.getCause());
                            }
                            finally {
                                ChainingListenableFuture.this.outputFuture = null;
                            }
                        }
                    }, MoreExecutors.sameThreadExecutor());
                    break block18;
                    {
                        catch (UndeclaredThrowableException e) {
                            this.setException(e.getCause());
                            break block18;
                        }
                        catch (RuntimeException e) {
                            this.setException(e);
                            break block18;
                        }
                        catch (Error e) {
                            this.setException(e);
                            break block18;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                }
            }
        }
    }
}

