/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.report.IItem;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Comparator;

public interface IItemAttribute {
    public static final int ATTRIBUTE_NAME_ID = 0;
    public static final int ATTRIBUTE_CLASS_COVERAGE_ID = 1;
    public static final int ATTRIBUTE_METHOD_COVERAGE_ID = 2;
    public static final int ATTRIBUTE_BLOCK_COVERAGE_ID = 3;
    public static final int ATTRIBUTE_LINE_COVERAGE_ID = 4;
    public static final int UNITS_COUNT = 0;
    public static final int UNITS_INSTR = 1;

    public Comparator comparator();

    public String getName();

    public void format(IItem var1, StringBuffer var2);

    public boolean passes(IItem var1, int var2);

    public static abstract class Factory {
        private static final IItemAttribute[][] ATTRIBUTES;

        public static IItemAttribute getAttribute(int attributeID, int unitsID) {
            return ATTRIBUTES[unitsID][attributeID];
        }

        public static IItemAttribute[] getAttributes(int unitsID) {
            return (IItemAttribute[])ATTRIBUTES[unitsID].clone();
        }

        private Factory() {
        }

        static {
            NameAttribute nameAttribute = new NameAttribute("name");
            FractionAttribute classCoverageAttribute = new FractionAttribute("class, %", 5, 11, 1, 0);
            FractionAttribute methodCoverageAttribute = new FractionAttribute("method, %", 4, 10, 1, 0);
            ATTRIBUTES = new IItemAttribute[][]{{nameAttribute, classCoverageAttribute, methodCoverageAttribute, new FractionAttribute("block, %", 0, 6, 1, 0), new FractionAttribute("line, %", 1, 7, 100, 1)}, {nameAttribute, classCoverageAttribute, methodCoverageAttribute, new FractionAttribute("block, %", 2, 8, 1, 0), new FractionAttribute("line, %", 3, 7, 100, 1)}};
        }

        private static final class FractionAttribute
        extends Attribute
        implements IItemAttribute {
            final int m_numeratorAggregateID;
            final int m_denominatorAggregateID;
            private final int m_scale;
            private final DecimalFormat m_format;
            private final DecimalFormat m_nFormat;
            private final FieldPosition m_fieldPosition;
            private final Comparator m_comparator;

            @Override
            public Comparator comparator() {
                return this.m_comparator;
            }

            @Override
            public void format(IItem item, StringBuffer appendTo) {
                int n = item.getAggregate(this.m_numeratorAggregateID);
                double n_scaled = (double)n / (double)this.m_scale;
                int d = item.getAggregate(this.m_denominatorAggregateID);
                int appendToStart = appendTo.length();
                if (d == 0) {
                    this.m_format.format(1.0, appendTo, this.m_fieldPosition);
                } else {
                    this.m_format.format(n_scaled / (double)d, appendTo, this.m_fieldPosition);
                }
                int iLimit = Math.max(1, 5 - appendTo.length() + appendToStart);
                for (int i = 0; i < iLimit; ++i) {
                    appendTo.append(' ');
                }
                appendTo.append('(');
                this.m_nFormat.format(n_scaled, appendTo, this.m_fieldPosition);
                appendTo.append('/');
                appendTo.append(d);
                appendTo.append(')');
            }

            @Override
            public boolean passes(IItem item, int criterion) {
                int d;
                int n = item.getAggregate(this.m_numeratorAggregateID);
                return (double)n * 100.0 >= (double)(d = item.getAggregate(this.m_denominatorAggregateID)) * (double)this.m_scale * (double)criterion;
            }

            FractionAttribute(String name, int numeratorAggregateID, int denominatorAggregateID, int scale, int nFractionDigits) {
                super(name);
                this.m_numeratorAggregateID = numeratorAggregateID;
                this.m_denominatorAggregateID = denominatorAggregateID;
                this.m_scale = scale;
                this.m_format = (DecimalFormat)NumberFormat.getPercentInstance();
                this.m_fieldPosition = new FieldPosition(0);
                this.m_format.setMaximumFractionDigits(0);
                this.m_nFormat = (DecimalFormat)NumberFormat.getInstance();
                this.m_nFormat.setGroupingUsed(false);
                this.m_nFormat.setMaximumFractionDigits(nFractionDigits);
                this.m_comparator = new FractionComparator();
            }

            private final class FractionComparator
            implements Comparator {
                private FractionComparator() {
                }

                public int compare(Object l, Object g) {
                    IItem il = (IItem)l;
                    IItem ig = (IItem)g;
                    double nil = il.getAggregate(FractionAttribute.this.m_numeratorAggregateID);
                    double dil = il.getAggregate(FractionAttribute.this.m_denominatorAggregateID);
                    double nig = ig.getAggregate(FractionAttribute.this.m_numeratorAggregateID);
                    double dig = ig.getAggregate(FractionAttribute.this.m_denominatorAggregateID);
                    double diff = nil * dig - nig * dil;
                    return diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
                }
            }
        }

        private static final class NameAttribute
        extends Attribute
        implements IItemAttribute {
            private final Comparator m_comparator = new NameComparator();

            @Override
            public Comparator comparator() {
                return this.m_comparator;
            }

            @Override
            public void format(IItem item, StringBuffer appendTo) {
                appendTo.append(item.getName());
            }

            @Override
            public boolean passes(IItem item, int criterion) {
                return true;
            }

            NameAttribute(String name) {
                super(name);
            }

            private static final class NameComparator
            implements Comparator {
                private NameComparator() {
                }

                public int compare(Object l, Object g) {
                    IItem il = (IItem)l;
                    IItem ig = (IItem)g;
                    return il.getName().compareTo(ig.getName());
                }
            }
        }

        private static abstract class Attribute
        implements IItemAttribute {
            private final String m_name;

            @Override
            public String getName() {
                return this.m_name;
            }

            protected Attribute(String name) {
                if (name == null) {
                    throw new IllegalArgumentException("null input: name");
                }
                this.m_name = name;
            }
        }
    }
}

