/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IReportDataModel;
import com.vladium.emma.report.IReportDataView;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Descriptors;
import java.util.HashMap;
import java.util.Iterator;

final class ReportDataModel
implements IReportDataModel {
    private final IMetaData m_mdata;
    private final ICoverageData m_cdata;
    private final IReportDataView[] m_views;

    @Override
    public synchronized IReportDataView getView(int viewType) {
        boolean srcView;
        if (viewType >= this.m_views.length) {
            throw new IllegalArgumentException("invalid viewType: " + viewType);
        }
        IReportDataView view = this.m_views[viewType];
        if (view != null) {
            return view;
        }
        boolean bl = srcView = viewType == 1;
        if (srcView && !this.m_mdata.hasSrcFileData()) {
            throw new IllegalStateException("source file data view requested for metadata with incomplete SourceFile debug info");
        }
        AllItem root = new AllItem();
        HashMap<String, PackageItem> packageMap = new HashMap<String, PackageItem>();
        HashMap<String, SrcFileItem> srcfileMap = new HashMap<String, SrcFileItem>();
        Iterator descriptors = this.m_mdata.iterator();
        while (descriptors.hasNext()) {
            ICoverageData.DataHolder data;
            String srcFileName;
            String fullSrcFileName;
            ClassDescriptor cls = (ClassDescriptor)descriptors.next();
            String packageVMName = cls.getPackageVMName();
            PackageItem packageItem = (PackageItem)packageMap.get(packageVMName);
            if (packageItem == null) {
                String packageName = packageVMName.length() == 0 ? "default package" : Descriptors.vmNameToJavaName(packageVMName);
                packageItem = new PackageItem(root, packageName, packageVMName);
                packageMap.put(packageVMName, packageItem);
                root.addChild(packageItem);
            }
            SrcFileItem srcfileItem = null;
            if (srcView && (srcfileItem = (SrcFileItem)srcfileMap.get(fullSrcFileName = Descriptors.combineVMName(packageVMName, srcFileName = cls.getSrcFileName()))) == null) {
                srcfileItem = new SrcFileItem(packageItem, srcFileName, fullSrcFileName);
                srcfileMap.put(fullSrcFileName, srcfileItem);
                packageItem.addChild(srcfileItem);
            }
            if ((data = this.m_cdata.getCoverage(cls)) != null && data.m_stamp != cls.getStamp()) {
                throw new EMMARuntimeException("CLASS_STAMP_MISMATCH", new Object[]{Descriptors.vmNameToJavaName(cls.getClassVMName())});
            }
            boolean[][] coverage = data != null ? data.m_coverage : (boolean[][])null;
            ClassItem classItem = srcView ? new ClassItem(srcfileItem, cls, coverage) : new ClassItem(packageItem, cls, coverage);
            MethodDescriptor[] methods = cls.getMethods();
            for (int m = 0; m < methods.length; ++m) {
                MethodDescriptor method = methods[m];
                if ((method.getStatus() & 0xE) != 0) continue;
                MethodItem methodItem = new MethodItem(classItem, m, method.getName(), method.getDescriptor(), method.getFirstLine());
                classItem.addChild(methodItem);
            }
            if (srcView) {
                srcfileItem.addChild(classItem);
                continue;
            }
            packageItem.addChild(classItem);
        }
        this.m_views[viewType] = view = new ReportDataView(root);
        return view;
    }

    ReportDataModel(IMetaData mdata, ICoverageData cdata) {
        if (mdata == null) {
            throw new IllegalArgumentException("null input: mdata");
        }
        if (cdata == null) {
            throw new IllegalArgumentException("null input: cdata");
        }
        this.m_views = new IReportDataView[2];
        this.m_mdata = mdata;
        this.m_cdata = cdata;
    }

    private static final class ReportDataView
    implements IReportDataView {
        private final IItem m_root;

        @Override
        public IItem getRoot() {
            return this.m_root;
        }

        ReportDataView(IItem root) {
            this.m_root = root;
        }
    }
}

