/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.lcov;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Descriptors;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import com.vladium.util.IntObjectMap;
import com.vladium.util.asserts.$assert;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private LinkedList m_queue;
    private BufferedWriter m_out;
    private static final String TYPE = "lcov";
    private static final int IO_BUF_SIZE = 32768;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void process(IMetaData mdata, ICoverageData cdata, SourcePathCache cache, IProperties properties) throws EMMARuntimeException {
        this.initialize(mdata, cdata, cache, properties);
        long start = 0L;
        boolean trace1 = this.m_log.atTRACE1();
        if (trace1) {
            start = System.currentTimeMillis();
        }
        this.m_queue = new LinkedList();
        this.m_queue.add(this.m_view.getRoot());
        while (!this.m_queue.isEmpty()) {
            IItem head = (IItem)this.m_queue.removeFirst();
            head.accept(this, null);
        }
        this.close();
        if (trace1) {
            long end = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (end - start) + " ms");
        }
    }

    @Override
    public void cleanup() {
        this.m_queue = null;
        this.close();
        super.cleanup();
    }

    @Override
    public Object visit(AllItem item, Object ctx) {
        File outFile = this.m_settings.getOutFile();
        if (outFile == null) {
            outFile = new File("coverage.lcov");
            this.m_settings.setOutFile(outFile);
        }
        File fullOutFile = Files.newFile(this.m_settings.getOutDir(), outFile);
        this.m_log.info("writing [" + this.getType() + "] report to [" + fullOutFile.getAbsolutePath() + "] ...");
        this.openOutFile(fullOutFile, this.m_settings.getOutEncoding(), true);
        ItemComparator order = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
        Iterator packages = item.getChildren(order);
        while (packages.hasNext()) {
            IItem pkg = (IItem)packages.next();
            this.m_queue.addLast(pkg);
        }
        return ctx;
    }

    @Override
    public Object visit(PackageItem item, Object ctx) {
        if (this.m_verbose) {
            this.m_log.verbose("  report: processing package [" + item.getName() + "] ...");
        }
        int id = this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID();
        ItemComparator order = this.m_typeSortComparators[id];
        Iterator srcORclsFiles = item.getChildren(order);
        while (srcORclsFiles.hasNext()) {
            IItem srcORcls = (IItem)srcORclsFiles.next();
            this.m_queue.addLast(srcORcls);
        }
        return ctx;
    }

    @Override
    public Object visit(SrcFileItem item, Object ctx) {
        this.row("SF:".concat(item.getFullVMName()));
        this.emitFileCoverage(item);
        this.row("end_of_record");
        return ctx;
    }

    private void emitFileCoverage(SrcFileItem item) {
        String fileName = item.getFullVMName();
        String packageVMName = ((PackageItem)item.getParent()).getVMName();
        if (!this.m_hasLineNumberInfo) {
            this.m_log.info("source file '" + Descriptors.combineVMName(packageVMName, fileName) + "' has no line number information");
        }
        boolean success = false;
        try {
            ItemComparator order = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
            int clsIndex = 0;
            Iterator classes = item.getChildren(order);
            while (classes.hasNext()) {
                ClassItem cls = (ClassItem)classes.next();
                String className = cls.getName();
                ClassDescriptor cdesc = cls.getClassDescriptor();
                boolean[][] ccoverage = cls.getCoverage();
                ItemComparator order2 = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
                Iterator methods = cls.getChildren(order2);
                while (methods.hasNext()) {
                    MethodItem method = (MethodItem)methods.next();
                    String mname = method.getName();
                    int methodID = method.getID();
                    boolean covered = false;
                    if (ccoverage != null) {
                        covered = ccoverage[methodID][0];
                    }
                    this.row("FN:" + method.getFirstLine() + "," + className + "::" + mname);
                    this.row("FNDA:" + (covered ? 1 : 0) + "," + className + "::" + mname);
                }
                ++clsIndex;
            }
            int unitsType = this.m_settings.getUnitsType();
            IntObjectMap lineCoverageMap = null;
            int[] lineCoverageKeys = null;
            lineCoverageMap = item.getLineCoverage();
            $assert.ASSERT(lineCoverageMap != null, "null: lineCoverageMap");
            lineCoverageKeys = lineCoverageMap.keys();
            Arrays.sort(lineCoverageKeys);
            block9: for (int i = 0; i < lineCoverageKeys.length; ++i) {
                int l = lineCoverageKeys[i];
                SrcFileItem.LineCoverageData lCoverageData = (SrcFileItem.LineCoverageData)lineCoverageMap.get(l);
                switch (lCoverageData.m_coverageStatus) {
                    case 0: {
                        this.row("DA:" + l + ",0");
                        continue block9;
                    }
                    case 1: {
                        this.row("DA:" + l + ",1");
                        continue block9;
                    }
                    case 2: {
                        this.row("DA:" + l + ",1");
                        continue block9;
                    }
                    default: {
                        $assert.ASSERT(false, "invalid line coverage status: " + lCoverageData.m_coverageStatus);
                    }
                }
            }
            success = true;
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            success = false;
        }
        if (!success) {
            this.m_log.info("[source file '" + Descriptors.combineVMName(packageVMName, fileName) + "' not found in sourcepath]");
        }
    }

    @Override
    public Object visit(ClassItem item, Object ctx) {
        return ctx;
    }

    private void row(StringBuffer str) {
        try {
            this.m_out.write(str.toString());
            this.m_out.newLine();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
    }

    private void row(String str) {
        try {
            this.m_out.write(str);
            this.m_out.newLine();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
        }
    }

    private void close() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
                this.m_out.close();
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
            finally {
                this.m_out = null;
            }
        }
    }

    private void openOutFile(File file, String encoding, boolean mkdirs) {
        try {
            File parent;
            if (mkdirs && (parent = file.getParentFile()) != null) {
                parent.mkdirs();
            }
            file.delete();
            if (file.exists()) {
                throw new EMMARuntimeException("Failed to delete " + file);
            }
            this.m_out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding), 32768);
        }
        catch (UnsupportedEncodingException uee) {
            throw new EMMARuntimeException(uee);
        }
        catch (IOException fnfe) {
            throw new EMMARuntimeException(fnfe);
        }
    }
}

