/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.Command;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.report.ReportProcessor;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.Strings;
import com.vladium.util.args.IOptsParser;
import java.io.IOException;

public final class reportCommand
extends Command {
    private String[] m_datapath;
    private String[] m_srcpath;
    private String[] m_reportTypes;

    public reportCommand(String usageToolName, String[] args) {
        super(usageToolName, args);
    }

    @Override
    public synchronized void run() {
        ClassLoader loader;
        try {
            loader = ClassLoaderResolver.getClassLoader();
        }
        catch (Throwable t) {
            loader = this.getClass().getClassLoader();
        }
        try {
            IOptsParser parser = this.getOptParser(loader);
            IOptsParser.IOpts parsedopts = parser.parse(this.m_args);
            int usageRequestLevel = parsedopts.usageRequestLevel();
            if (usageRequestLevel > 0) {
                this.usageexit(parser, usageRequestLevel, null);
                return;
            }
            IOptsParser.IOpt[] opts = parsedopts.getOpts();
            if (opts == null) {
                parsedopts.error(this.m_out, 80);
                this.usageexit(parser, 1, null);
                return;
            }
            try {
                for (int o = 0; o < opts.length; ++o) {
                    IOptsParser.IOpt opt = opts[o];
                    String on = opt.getCanonicalName();
                    if (this.processOpt(opt)) continue;
                    if ("in".equals(on)) {
                        this.m_datapath = reportCommand.getListOptValue(opt, PATH_DELIMITERS, true);
                        continue;
                    }
                    if ("sp".equals(on)) {
                        this.m_srcpath = reportCommand.getListOptValue(opt, PATH_DELIMITERS, true);
                        continue;
                    }
                    if (!"r".equals(on)) continue;
                    this.m_reportTypes = Strings.merge(opt.getValues(), ", \t\r\n", true);
                }
                if (!this.processFilePropertyOverrides()) {
                    return;
                }
                this.processCmdPropertyOverrides(parsedopts);
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("ARGS_IO_FAILURE", ioe);
            }
            ReportProcessor processor = ReportProcessor.create();
            processor.setAppName("EMMA");
            processor.setDataPath(this.m_datapath);
            processor.setSourcePath(this.m_srcpath);
            processor.setReportTypes(this.m_reportTypes);
            processor.setPropertyOverrides(this.m_propertyOverrides);
            processor.run();
        }
        catch (EMMARuntimeException yre) {
            this.exit(true, yre.getMessage(), yre, 2);
            return;
        }
        catch (Throwable t) {
            this.exit(true, "unexpected failure: ", t, 2);
            return;
        }
        this.exit(false, null, null, 0);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    protected String usageArgsMsg() {
        return "[options]";
    }
}

