/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IInterfaceCollection;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;

final class InterfaceCollection
implements IInterfaceCollection {
    private IntVector m_interfaces;

    @Override
    public int get(int offset) {
        return this.m_interfaces.get(offset);
    }

    @Override
    public int size() {
        return this.m_interfaces.size();
    }

    @Override
    public Object clone() {
        try {
            InterfaceCollection _clone = (InterfaceCollection)super.clone();
            _clone.m_interfaces = (IntVector)this.m_interfaces.clone();
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        int _interfaces_count = this.m_interfaces.size();
        out.writeU2(_interfaces_count);
        for (int i = 0; i < _interfaces_count; ++i) {
            out.writeU2(this.get(i));
        }
    }

    @Override
    public void accept(IClassDefVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    @Override
    public int add(int interface_index) {
        int newoffset = this.m_interfaces.size();
        this.m_interfaces.add(interface_index);
        return newoffset;
    }

    @Override
    public int set(int offset, int interface_index) {
        return this.m_interfaces.set(offset, interface_index);
    }

    InterfaceCollection(int capacity) {
        this.m_interfaces = capacity < 0 ? new IntVector() : new IntVector(capacity);
    }
}

