/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.attribute.AttributeElementFactory;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.Exception_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.IExceptionHandlerTable;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;

public final class CodeAttribute_info
extends Attribute_info {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public int m_max_stack;
    public int m_max_locals;
    private byte[] m_code;
    private int m_codeSize;
    private IExceptionHandlerTable m_exceptionHandlerTable;
    private IAttributeCollection m_attributes;
    private static final boolean DEBUG = false;

    public CodeAttribute_info(int attribute_name_index, int max_stack, int max_locals, byte[] code, IExceptionHandlerTable exceptionHandlerTable, IAttributeCollection attributes) {
        super(attribute_name_index, (long)(8 + (code != null ? code.length : 0)) + exceptionHandlerTable.length() + attributes.length());
        this.m_max_stack = max_stack;
        this.m_max_locals = max_locals;
        this.m_code = code != null ? code : EMPTY_BYTE_ARRAY;
        this.m_codeSize = this.m_code.length;
        this.m_exceptionHandlerTable = exceptionHandlerTable;
        this.m_attributes = attributes;
    }

    public final byte[] getCode() {
        return this.m_code;
    }

    public final int getCodeSize() {
        return this.m_codeSize;
    }

    public IAttributeCollection getAttributes() {
        return this.m_attributes;
    }

    public IExceptionHandlerTable getExceptionTable() {
        return this.m_exceptionHandlerTable;
    }

    @Override
    public long length() {
        return (long)(14 + this.m_codeSize) + this.m_exceptionHandlerTable.length() + this.m_attributes.length();
    }

    @Override
    public void accept(IAttributeVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    @Override
    public String toString() {
        String eol = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        s.append("CodeAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.m_attribute_length + "]" + eol);
        s.append("    max_stack/max_locals = " + this.m_max_stack + '/' + this.m_max_locals + eol);
        s.append("    code [length " + this.m_codeSize + "]" + eol);
        for (int a = 0; a < this.m_attributes.size(); ++a) {
            s.append("         " + this.m_attributes.get(a) + eol);
        }
        return s.toString();
    }

    @Override
    public Object clone() {
        CodeAttribute_info _clone = (CodeAttribute_info)super.clone();
        _clone.m_code = this.m_codeSize == 0 ? EMPTY_BYTE_ARRAY : (byte[])this.m_code.clone();
        _clone.m_exceptionHandlerTable = (IExceptionHandlerTable)this.m_exceptionHandlerTable.clone();
        _clone.m_attributes = (IAttributeCollection)this.m_attributes.clone();
        return _clone;
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        out.writeU2(this.m_max_stack);
        out.writeU2(this.m_max_locals);
        out.writeU4(this.m_codeSize);
        out.write(this.m_code, 0, this.m_codeSize);
        this.m_exceptionHandlerTable.writeInClassFormat(out);
        this.m_attributes.writeInClassFormat(out);
    }

    public void setCode(byte[] code, int codeSize) {
        this.m_code = code;
        this.m_codeSize = codeSize;
    }

    CodeAttribute_info(IConstantCollection constants, int attribute_name_index, long attribute_length, UDataInputStream bytes) throws IOException {
        super(attribute_name_index, attribute_length);
        this.m_max_stack = bytes.readU2();
        this.m_max_locals = bytes.readU2();
        long code_length = bytes.readU4();
        this.m_code = new byte[(int)code_length];
        bytes.readFully(this.m_code);
        this.m_codeSize = (int)code_length;
        int exception_table_length = bytes.readU2();
        this.m_exceptionHandlerTable = AttributeElementFactory.newExceptionHandlerTable(exception_table_length);
        for (int i = 0; i < exception_table_length; ++i) {
            Exception_info exception_info = new Exception_info(bytes);
            this.m_exceptionHandlerTable.add(exception_info);
        }
        int attributes_count = bytes.readU2();
        this.m_attributes = ElementFactory.newAttributeCollection(attributes_count);
        for (int i = 0; i < attributes_count; ++i) {
            Attribute_info attribute_info = Attribute_info.new_Attribute_info(constants, bytes);
            this.m_attributes.add(attribute_info);
        }
    }
}

