/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

public abstract class WCMatcher {
    private static final WCMatcher ALL_MATCHER = new AllMatcher();
    private static final WCMatcher EMPTY_MATCHER = new EmptyMatcher();

    public static WCMatcher compile(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("null input: pattern");
        }
        char[] chars = pattern.toCharArray();
        int charsLength = chars.length;
        if (charsLength == 0) {
            return EMPTY_MATCHER;
        }
        int patternLength = 0;
        int starCount = 0;
        int questionCount = 0;
        boolean star = false;
        for (int c = 0; c < charsLength; ++c) {
            char ch = chars[c];
            if (ch == '*') {
                if (star) continue;
                star = true;
                ++starCount;
                chars[patternLength++] = 42;
                continue;
            }
            star = false;
            if (ch == '?') {
                ++questionCount;
            }
            chars[patternLength++] = ch;
        }
        if (starCount == 1 && questionCount == 0) {
            if (patternLength == 1) {
                return ALL_MATCHER;
            }
            if (chars[0] == '*') {
                return new EndsWithMatcher(chars, patternLength);
            }
            if (chars[patternLength - 1] == '*') {
                return new StartsWithMatcher(chars, patternLength);
            }
        }
        return new PatternMatcher(chars, patternLength);
    }

    public abstract boolean matches(String var1);

    public abstract boolean matches(char[] var1);

    WCMatcher() {
    }

    private static final class PatternMatcher
    extends WCMatcher {
        private final char[] m_pattern;
        private final int m_patternLength;

        @Override
        public final boolean matches(String s) {
            if (s == null) {
                throw new IllegalArgumentException("null input: s");
            }
            char[] string = s.toCharArray();
            int stringLength = string.length;
            char[] pattern = this.m_pattern;
            int patternLength = this.m_patternLength;
            int si = 0;
            int pi = 0;
            boolean star = false;
            block0: while (true) {
                int i = 0;
                while (pi + i < patternLength) {
                    char patternChar = pattern[pi + i];
                    if (patternChar == '*') {
                        si += i;
                        pi += i + 1;
                        star = true;
                        continue block0;
                    }
                    int si_i = si + i;
                    if (si_i == stringLength) {
                        return false;
                    }
                    if (patternChar != string[si_i] && patternChar != '?') {
                        if (!star) {
                            return false;
                        }
                        ++si;
                        continue block0;
                    }
                    ++i;
                }
                if (si + i == stringLength) {
                    return true;
                }
                if (!star) {
                    return false;
                }
                ++si;
            }
        }

        @Override
        public final boolean matches(char[] string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: string");
            }
            int stringLength = string.length;
            char[] pattern = this.m_pattern;
            int patternLength = this.m_patternLength;
            int si = 0;
            int pi = 0;
            boolean star = false;
            block0: while (true) {
                int i = 0;
                while (pi + i < patternLength) {
                    char patternChar = pattern[pi + i];
                    if (patternChar == '*') {
                        si += i;
                        pi += i + 1;
                        star = true;
                        continue block0;
                    }
                    int si_i = si + i;
                    if (si_i == stringLength) {
                        return false;
                    }
                    if (patternChar != string[si_i] && patternChar != '?') {
                        if (!star) {
                            return false;
                        }
                        ++si;
                        continue block0;
                    }
                    ++i;
                }
                if (si + i == stringLength) {
                    return true;
                }
                if (!star) {
                    return false;
                }
                ++si;
            }
        }

        PatternMatcher(char[] pattern, int patternLength) {
            this.m_pattern = pattern;
            this.m_patternLength = patternLength;
        }
    }

    private static final class EndsWithMatcher
    extends WCMatcher {
        private final char[] m_suffixChars;
        private final String m_suffix;

        @Override
        public final boolean matches(String s) {
            if (s == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return s.endsWith(this.m_suffix);
        }

        @Override
        public final boolean matches(char[] chars) {
            if (chars == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            int charsLength = chars.length;
            char[] suffixChars = this.m_suffixChars;
            int suffixLength = suffixChars.length - 1;
            if (charsLength < suffixLength) {
                return false;
            }
            for (int c = 0; c < suffixLength; ++c) {
                if (chars[charsLength - 1 - c] == suffixChars[suffixLength - c]) continue;
                return false;
            }
            return true;
        }

        EndsWithMatcher(char[] pattern, int patternLength) {
            this.m_suffixChars = pattern;
            this.m_suffix = new String(pattern, 1, patternLength - 1);
        }
    }

    private static final class StartsWithMatcher
    extends WCMatcher {
        private final char[] m_prefixChars;
        private final String m_prefix;

        @Override
        public final boolean matches(String s) {
            if (s == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return s.startsWith(this.m_prefix);
        }

        @Override
        public final boolean matches(char[] chars) {
            if (chars == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            char[] prefixChars = this.m_prefixChars;
            int prefixLength = prefixChars.length - 1;
            if (chars.length < prefixLength) {
                return false;
            }
            for (int c = 0; c < prefixLength; ++c) {
                if (chars[c] == prefixChars[c]) continue;
                return false;
            }
            return true;
        }

        StartsWithMatcher(char[] pattern, int patternLength) {
            this.m_prefixChars = pattern;
            this.m_prefix = new String(pattern, 0, patternLength - 1);
        }
    }

    private static final class EmptyMatcher
    extends WCMatcher {
        private EmptyMatcher() {
        }

        @Override
        public final boolean matches(String s) {
            if (s == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return false;
        }

        @Override
        public final boolean matches(char[] chars) {
            if (chars == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            return chars.length == 0;
        }
    }

    private static final class AllMatcher
    extends WCMatcher {
        private AllMatcher() {
        }

        @Override
        public final boolean matches(String s) {
            if (s == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return true;
        }

        @Override
        public final boolean matches(char[] chars) {
            if (chars == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            return true;
        }
    }
}

