/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.models;

import com.android.annotations.Nullable;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class EvaluateContrastModel {
    public static final String CONTRAST_RATIO_FORMAT = "%.2f:1";
    public static final double CONTRAST_RATIO_NORMAL_TEXT = 4.5;
    public static final double CONTRAST_RATIO_LARGE_TEXT = 3.0;
    public static final int NORMAL_TEXT_SZ_PTS = 18;
    public static final int NORMAL_TEXT_BOLD_SZ_PTS = 14;
    public static final String NOT_APPLICABLE = "N/A";
    private static final double MAX_RGB_VALUE = 255.0;
    private ImageData mImageData;
    private Rectangle mViewBounds;
    private HashMap<Integer, Double> mLuminanceMap;
    private HashMap<Double, Integer> mLuminanceHistogram;
    private final List<Integer> mBackgroundColors;
    private final List<Integer> mForegroundColors;
    private double mBackgroundLuminance;
    private double mForegroundLuminance;
    private double mContrastRatio;
    private Integer mTextColor;
    private Double mTextSize;
    private boolean mIsBold;

    public EvaluateContrastModel(Image image, @Nullable Integer textColor, @Nullable Double textSize, int x, int y, int width, int height, boolean isBold) {
        this.mImageData = image.getImageData();
        this.mTextColor = textColor;
        this.mTextSize = textSize;
        this.mViewBounds = new Rectangle(x, y, width, height);
        this.mIsBold = isBold;
        this.mBackgroundColors = new LinkedList<Integer>();
        this.mForegroundColors = new LinkedList<Integer>();
        this.mLuminanceMap = new HashMap();
        this.mLuminanceHistogram = new HashMap();
        this.processSwatch();
    }

    public static double calculateLuminance(int color) {
        Color colorObj = new Color(color);
        float[] sRGB = new float[4];
        colorObj.getRGBComponents(sRGB);
        double[] lumRGB = new double[4];
        for (int i = 0; i < sRGB.length; ++i) {
            lumRGB[i] = (double)sRGB[i] <= 0.03928 ? (double)sRGB[i] / 12.92 : Math.pow(((double)sRGB[i] + 0.055) / 1.055, 2.4);
        }
        return 0.2126 * lumRGB[0] + 0.7152 * lumRGB[1] + 0.0722 * lumRGB[2];
    }

    public static double calculateContrastRatio(double lum1, double lum2) {
        if (lum1 < 0.0 || lum2 < 0.0) {
            throw new IllegalArgumentException("Luminance values may not be negative.");
        }
        return (Math.max(lum1, lum2) + 0.05) / (Math.min(lum1, lum2) + 0.05);
    }

    public static String intToHexString(int color) {
        return String.format("#%06X", 0xFFFFFF & color);
    }

    private void processSwatch() {
        this.processLuminanceData();
        this.extractFgBgData();
        double textLuminance = this.mTextColor == null ? this.mForegroundLuminance : EvaluateContrastModel.calculateLuminance(this.calculateTextColor(this.mTextColor, this.mBackgroundColors.get(0)));
        this.mContrastRatio = (double)Math.round(EvaluateContrastModel.calculateContrastRatio(textLuminance, this.mBackgroundLuminance) * 100.0) / 100.0;
    }

    private void processLuminanceData() {
        for (int x = this.mViewBounds.x; x < this.mViewBounds.width; ++x) {
            for (int y = this.mViewBounds.y; y < this.mViewBounds.height; ++y) {
                int color = this.mImageData.getPixel(x, y);
                double luminance = EvaluateContrastModel.calculateLuminance(color);
                if (!this.mLuminanceMap.containsKey(color)) {
                    this.mLuminanceMap.put(color, luminance);
                }
                if (!this.mLuminanceHistogram.containsKey(luminance)) {
                    this.mLuminanceHistogram.put(luminance, 0);
                }
                this.mLuminanceHistogram.put(luminance, this.mLuminanceHistogram.get(luminance) + 1);
            }
        }
    }

    private void extractFgBgData() {
        if (this.mLuminanceMap.isEmpty()) {
            this.mForegroundLuminance = 0.0;
            this.mBackgroundLuminance = 0.0;
            this.mBackgroundColors.add(0);
            this.mForegroundColors.add(0);
        } else if (this.mLuminanceMap.size() == 1) {
            this.mBackgroundLuminance = this.mForegroundLuminance = this.mLuminanceHistogram.keySet().iterator().next().doubleValue();
            int singleColor = this.mLuminanceMap.keySet().iterator().next();
            this.mForegroundColors.add(singleColor);
            this.mBackgroundColors.add(singleColor);
        } else {
            ArrayList colorsByLuminance = Lists.newArrayList(this.mLuminanceMap.entrySet());
            Collections.sort(colorsByLuminance, new Comparator<Map.Entry<Integer, Double>>(){

                @Override
                public int compare(Map.Entry<Integer, Double> lhs, Map.Entry<Integer, Double> rhs) {
                    return Double.compare(lhs.getValue(), rhs.getValue());
                }
            });
            ArrayList luminanceByFrequency = Lists.newArrayList(this.mLuminanceHistogram.entrySet());
            Collections.sort(luminanceByFrequency, new Comparator<Map.Entry<Double, Integer>>(){

                @Override
                public int compare(Map.Entry<Double, Integer> lhs, Map.Entry<Double, Integer> rhs) {
                    return lhs.getValue() - rhs.getValue();
                }
            });
            double luminanceSum = 0.0;
            for (Map.Entry luminanceCount : luminanceByFrequency) {
                luminanceSum += ((Double)luminanceCount.getKey()).doubleValue();
            }
            double averageLuminance = luminanceSum / (double)luminanceByFrequency.size();
            double lowLuminanceContributor = 0.0;
            for (int i = luminanceByFrequency.size() - 1; i >= 0; --i) {
                double luminanceValue = (Double)((Map.Entry)luminanceByFrequency.get(i)).getKey();
                if (!(luminanceValue < averageLuminance)) continue;
                lowLuminanceContributor = luminanceValue;
                break;
            }
            double highLuminanceContributor = 1.0;
            for (int i = luminanceByFrequency.size() - 1; i >= 0; --i) {
                double luminanceValue = (Double)((Map.Entry)luminanceByFrequency.get(i)).getKey();
                if (!(luminanceValue >= averageLuminance)) continue;
                highLuminanceContributor = luminanceValue;
                break;
            }
            if (this.mLuminanceHistogram.get(highLuminanceContributor) > this.mLuminanceHistogram.get(lowLuminanceContributor)) {
                this.mBackgroundLuminance = highLuminanceContributor;
                this.mForegroundLuminance = lowLuminanceContributor;
            } else {
                this.mBackgroundLuminance = lowLuminanceContributor;
                this.mForegroundLuminance = highLuminanceContributor;
            }
            for (Map.Entry<Integer, Double> colorLuminance : this.mLuminanceMap.entrySet()) {
                if (colorLuminance.getValue() == this.mBackgroundLuminance) {
                    this.mBackgroundColors.add(colorLuminance.getKey());
                }
                if (colorLuminance.getValue() != this.mForegroundLuminance) continue;
                this.mForegroundColors.add(colorLuminance.getKey());
            }
        }
    }

    private int calculateTextColor(int textColor, int backgroundColor) {
        Color text = new Color(textColor, true);
        Color background = new Color(backgroundColor, true);
        int alpha = text.getAlpha();
        double alphaPercentage = (double)alpha / 255.0;
        double alphaCompliment = 1.0 - alphaPercentage;
        int red = (int)(alphaPercentage * (double)text.getRed() + alphaCompliment * (double)background.getRed());
        int green = (int)(alphaPercentage * (double)text.getGreen() + alphaCompliment * (double)background.getGreen());
        int blue = (int)(alphaPercentage * (double)text.getBlue() + alphaCompliment * (double)background.getBlue());
        Color rgb = new Color(red, green, blue, 255);
        this.mTextColor = rgb.getRGB();
        return this.mTextColor;
    }

    public ContrastResult getContrastResult() {
        ContrastResult largeTest;
        ContrastResult normalTest = this.getContrastResultForNormalText();
        if (normalTest == (largeTest = this.getContrastResultForLargeText())) {
            return normalTest;
        }
        if (this.mTextSize == null) {
            return ContrastResult.INDETERMINATE;
        }
        if (this.mTextSize >= 14.0 && this.mIsBold || this.mTextSize > 18.0) {
            return largeTest;
        }
        return normalTest;
    }

    public ContrastResult getContrastResultForLargeText() {
        return this.mContrastRatio >= 3.0 ? ContrastResult.PASS : ContrastResult.FAIL;
    }

    public ContrastResult getContrastResultForNormalText() {
        if (this.mIsBold && this.mTextSize != null && this.mTextSize >= 14.0) {
            return this.getContrastResultForLargeText();
        }
        return this.mContrastRatio >= 4.5 ? ContrastResult.PASS : ContrastResult.FAIL;
    }

    public double getContrastRatio() {
        return this.mContrastRatio;
    }

    public double getBackgroundLuminance() {
        return this.mBackgroundLuminance;
    }

    public String getTextSize() {
        if (this.mTextSize == null) {
            return NOT_APPLICABLE;
        }
        return Double.toString(this.mTextSize);
    }

    public int getTextColor() {
        Integer textColor = this.mTextColor != null ? this.mTextColor : this.mForegroundColors.get(0);
        return textColor;
    }

    public String getTextColorHex() {
        return EvaluateContrastModel.intToHexString(this.getTextColor());
    }

    public int getBackgroundColor() {
        return this.mBackgroundColors.get(0);
    }

    public String getBackgroundColorHex() {
        return EvaluateContrastModel.intToHexString(this.mBackgroundColors.get(0));
    }

    public boolean isIndeterminate() {
        return this.mTextSize == null && this.getContrastResult() == ContrastResult.INDETERMINATE;
    }

    public boolean isBold() {
        return this.mIsBold;
    }

    public static enum ContrastResult {
        PASS,
        FAIL,
        INDETERMINATE;

    }
}

