/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.PositionXmlParser;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LintCliXmlParser
extends XmlParser {
    private final PositionXmlParser mParser = new PositionXmlParser(){

        @NonNull
        protected OffsetPosition createPosition(int line, int column, int offset) {
            return new OffsetPosition(line, column, offset);
        }
    };

    @Override
    public Document parseXml(@NonNull XmlContext context) {
        String xml = null;
        try {
            xml = context.getContents();
            if (xml != null) {
                return this.mParser.parse(xml);
            }
        }
        catch (UnsupportedEncodingException e) {
            context.report(IssueRegistry.PARSER_ERROR, Location.create(context.file), e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage());
        }
        catch (SAXException e) {
            String message;
            Location location = Location.create(context.file);
            String string = message = e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage();
            if (message.startsWith("The processing instruction target matching \"[xX][mM][lL]\" is not allowed.")) {
                int prologue = xml.indexOf("<?xml ");
                int comment = xml.indexOf("<!--");
                if (prologue != -1 && comment != -1 && comment < prologue) {
                    message = "The XML prologue should appear before, not after, the first XML header/copyright comment. " + message;
                }
            }
            context.report(IssueRegistry.PARSER_ERROR, location, message);
        }
        catch (Throwable t) {
            context.log(t, null, new Object[0]);
        }
        return null;
    }

    @Override
    @NonNull
    public Location getLocation(@NonNull XmlContext context, @NonNull Node node) {
        OffsetPosition pos = (OffsetPosition)this.mParser.getPosition(node, -1, -1);
        if (pos != null) {
            return Location.create(context.file, pos, (OffsetPosition)pos.getEnd());
        }
        return Location.create(context.file);
    }

    @Override
    @NonNull
    public Location getLocation(@NonNull XmlContext context, @NonNull Node node, int start, int end) {
        OffsetPosition pos = (OffsetPosition)this.mParser.getPosition(node, start, end);
        if (pos != null) {
            return Location.create(context.file, pos, (OffsetPosition)pos.getEnd());
        }
        return Location.create(context.file);
    }

    @Override
    @NonNull
    public Location.Handle createLocationHandle(@NonNull XmlContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    @Override
    public int getNodeStartOffset(@NonNull XmlContext context, @NonNull Node node) {
        OffsetPosition pos = (OffsetPosition)this.mParser.getPosition(node, -1, -1);
        if (pos != null) {
            return pos.getOffset();
        }
        return -1;
    }

    @Override
    public int getNodeEndOffset(@NonNull XmlContext context, @NonNull Node node) {
        PositionXmlParser.Position end;
        OffsetPosition pos = (OffsetPosition)this.mParser.getPosition(node, -1, -1);
        if (pos != null && (end = pos.getEnd()) != null) {
            return end.getOffset();
        }
        return -1;
    }

    private class LocationHandle
    implements Location.Handle {
        private final File mFile;
        private final Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        @Override
        @NonNull
        public Location resolve() {
            OffsetPosition pos = (OffsetPosition)LintCliXmlParser.this.mParser.getPosition(this.mNode);
            if (pos != null) {
                return Location.create(this.mFile, pos, (OffsetPosition)pos.getEnd());
            }
            return Location.create(this.mFile);
        }

        @Override
        public void setClientData(@Nullable Object clientData) {
            this.mClientData = clientData;
        }

        @Override
        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }

    private static class OffsetPosition
    extends Position
    implements PositionXmlParser.Position {
        private final int mLine;
        private final int mColumn;
        private final int mOffset;
        private PositionXmlParser.Position mEnd;

        public OffsetPosition(int line, int column, int offset) {
            this.mLine = line;
            this.mColumn = column;
            this.mOffset = offset;
        }

        @Override
        public int getLine() {
            return this.mLine;
        }

        @Override
        public int getOffset() {
            return this.mOffset;
        }

        @Override
        public int getColumn() {
            return this.mColumn;
        }

        public PositionXmlParser.Position getEnd() {
            return this.mEnd;
        }

        public void setEnd(@NonNull PositionXmlParser.Position end) {
            this.mEnd = end;
        }

        public String toString() {
            return "OffsetPosition [line=" + this.mLine + ", column=" + this.mColumn + ", offset=" + this.mOffset + ", end=" + this.mEnd + ']';
        }
    }
}

