/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.If;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.UnaryExpression;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableReference;

public class JavaPerformanceDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(JavaPerformanceDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue PAINT_ALLOC = Issue.create("DrawAllocation", "Memory allocations within drawing code", "You should avoid allocating objects during a drawing or layout operation. These are called frequently, so a smooth UI can be interrupted by garbage collection pauses caused by the object allocations.\n\nThe way this is generally handled is to allocate the needed objects up front and to reuse them for each drawing operation.\n\nSome methods allocate memory on your behalf (such as `Bitmap.create`), and these should be handled in the same way.", Category.PERFORMANCE, 9, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_SPARSE_ARRAY = Issue.create("UseSparseArrays", "HashMap can be replaced with SparseArray", "For maps where the keys are of type integer, it's typically more efficient to use the Android `SparseArray` API. This check identifies scenarios where you might want to consider using `SparseArray` instead of `HashMap` for better performance.\n\nThis is *particularly* useful when the value types are primitives like ints, where you can use `SparseIntArray` and avoid auto-boxing the values from `int` to `Integer`.\n\nIf you need to construct a `HashMap` because you need to call an API outside of your control which requires a `Map`, you can suppress this warning using for example the `@SuppressLint` annotation.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_VALUE_OF = Issue.create("UseValueOf", "Should use `valueOf` instead of `new`", "You should not call the constructor for wrapper classes directly, such as`new Integer(42)`. Instead, call the `valueOf` factory method, such as `Integer.valueOf(42)`. This will typically use less memory because common integers such as 0 and 1 will share a single instance.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    static final String ON_MEASURE = "onMeasure";
    static final String ON_DRAW = "onDraw";
    static final String ON_LAYOUT = "onLayout";
    private static final String INTEGER = "Integer";
    private static final String BOOLEAN = "Boolean";
    private static final String BYTE = "Byte";
    private static final String LONG = "Long";
    private static final String CHARACTER = "Character";
    private static final String DOUBLE = "Double";
    private static final String FLOAT = "Float";
    private static final String HASH_MAP = "HashMap";
    private static final String SPARSE_ARRAY = "SparseArray";
    private static final String CANVAS = "Canvas";
    private static final String LAYOUT = "layout";

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        ArrayList<Class<? extends Node>> types = new ArrayList<Class<? extends Node>>(3);
        types.add(ConstructorInvocation.class);
        types.add(MethodDeclaration.class);
        types.add(MethodInvocation.class);
        return types;
    }

    @Override
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new PerformanceVisitor(context);
    }

    private static String getUseValueOfErrorMessage(String typeName, String argument) {
        return String.format("Use `%1$s.valueOf(%2$s)` instead", typeName, argument);
    }

    @Nullable
    public static String getReplacedType(@NonNull String message, @NonNull TextFormat format) {
        int index = (message = format.toText(message)).indexOf(46);
        if (index != -1 && message.startsWith("Use ")) {
            return message.substring(4, index);
        }
        return null;
    }

    private static class AssignmentTracker
    extends ForwardingAstVisitor {
        private final Collection<String> mVariables;

        public AssignmentTracker(Collection<String> variables) {
            this.mVariables = variables;
        }

        public boolean visitBinaryExpression(BinaryExpression node) {
            BinaryOperator operator = node.astOperator();
            if (operator == BinaryOperator.ASSIGN || operator == BinaryOperator.OR_ASSIGN) {
                Expression left = node.astLeft();
                String variable = left instanceof Select && ((Select)left).astOperand() instanceof This ? ((Select)left).astIdentifier().astValue() : left.toString();
                this.mVariables.add(variable);
            }
            return super.visitBinaryExpression(node);
        }
    }

    private static class PerformanceVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;
        private final boolean mCheckMaps;
        private final boolean mCheckAllocations;
        private final boolean mCheckValueOf;
        private boolean mFlagAllocations;

        public PerformanceVisitor(JavaContext context) {
            this.mContext = context;
            this.mCheckAllocations = context.isEnabled(PAINT_ALLOC);
            this.mCheckMaps = context.isEnabled(USE_SPARSE_ARRAY);
            this.mCheckValueOf = context.isEnabled(USE_VALUE_OF);
        }

        public boolean visitMethodDeclaration(MethodDeclaration node) {
            this.mFlagAllocations = PerformanceVisitor.isBlockedAllocationMethod(node);
            return super.visitMethodDeclaration(node);
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            TypeReference reference;
            String typeName = null;
            if (this.mCheckMaps) {
                reference = node.astTypeReference();
                typeName = ((TypeReferencePart)reference.astParts().last()).astIdentifier().astValue();
                if (typeName.equals(JavaPerformanceDetector.HASH_MAP)) {
                    this.checkHashMap(node, reference);
                } else if (typeName.equals(JavaPerformanceDetector.SPARSE_ARRAY)) {
                    this.checkSparseArray(node, reference);
                }
            }
            if (this.mCheckValueOf) {
                if (typeName == null) {
                    reference = node.astTypeReference();
                    typeName = ((TypeReferencePart)reference.astParts().last()).astIdentifier().astValue();
                }
                if ((typeName.equals(JavaPerformanceDetector.INTEGER) || typeName.equals(JavaPerformanceDetector.BOOLEAN) || typeName.equals(JavaPerformanceDetector.FLOAT) || typeName.equals(JavaPerformanceDetector.CHARACTER) || typeName.equals(JavaPerformanceDetector.LONG) || typeName.equals(JavaPerformanceDetector.DOUBLE) || typeName.equals(JavaPerformanceDetector.BYTE)) && node.astTypeReference().astParts().size() == 1 && node.astArguments().size() == 1) {
                    String argument = ((Expression)node.astArguments().first()).toString();
                    this.mContext.report(USE_VALUE_OF, (Node)node, this.mContext.getLocation((Node)node), JavaPerformanceDetector.getUseValueOfErrorMessage(typeName, argument));
                }
            }
            if (this.mFlagAllocations && !(node.getParent() instanceof Throw) && this.mCheckAllocations) {
                ConstructorInvocation method;
                for (method = node; method != null && !(method instanceof MethodDeclaration); method = method.getParent()) {
                }
                if (method != null && PerformanceVisitor.isBlockedAllocationMethod((MethodDeclaration)method) && !PerformanceVisitor.isLazilyInitialized((Node)node)) {
                    this.reportAllocation((Node)node);
                }
            }
            return super.visitConstructorInvocation(node);
        }

        private void reportAllocation(Node node) {
            this.mContext.report(PAINT_ALLOC, node, this.mContext.getLocation(node), "Avoid object allocations during draw/layout operations (preallocate and reuse instead)");
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            if (this.mFlagAllocations && node.astOperand() != null) {
                String methodName = node.astName().astValue();
                if (methodName.equals("createBitmap") || methodName.equals("createScaledBitmap")) {
                    String operand = node.astOperand().toString();
                    if ((operand.equals("Bitmap") || operand.equals("android.graphics.Bitmap")) && !PerformanceVisitor.isLazilyInitialized((Node)node)) {
                        this.reportAllocation((Node)node);
                    }
                } else if (methodName.startsWith("decode")) {
                    String operand = node.astOperand().toString();
                    if ((operand.equals("BitmapFactory") || operand.equals("android.graphics.BitmapFactory")) && !PerformanceVisitor.isLazilyInitialized((Node)node)) {
                        this.reportAllocation((Node)node);
                    }
                } else if (methodName.equals("getClipBounds") && node.astArguments().isEmpty()) {
                    this.mContext.report(PAINT_ALLOC, (Node)node, this.mContext.getLocation((Node)node), "Avoid object allocations during draw operations: Use `Canvas.getClipBounds(Rect)` instead of `Canvas.getClipBounds()` which allocates a temporary `Rect`");
                }
            }
            return super.visitMethodInvocation(node);
        }

        private static boolean isLazilyInitialized(Node node) {
            for (Node curr = node.getParent(); curr != null; curr = curr.getParent()) {
                if (curr instanceof MethodDeclaration) {
                    return false;
                }
                if (!(curr instanceof If)) continue;
                If ifNode = (If)curr;
                ArrayList<String> assignments = new ArrayList<String>();
                AssignmentTracker visitor = new AssignmentTracker(assignments);
                ifNode.astStatement().accept((AstVisitor)visitor);
                if (!assignments.isEmpty()) {
                    ArrayList<String> references = new ArrayList<String>();
                    PerformanceVisitor.addReferencedVariables(references, ifNode.astCondition());
                    if (!references.isEmpty()) {
                        Sets.SetView intersection = Sets.intersection(new HashSet<String>(assignments), new HashSet<String>(references));
                        return !intersection.isEmpty();
                    }
                }
                return false;
            }
            return false;
        }

        private static void addReferencedVariables(Collection<String> variables, Expression expression) {
            Select select;
            if (expression instanceof BinaryExpression) {
                BinaryExpression binary = (BinaryExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, binary.astLeft());
                PerformanceVisitor.addReferencedVariables(variables, binary.astRight());
            } else if (expression instanceof UnaryExpression) {
                UnaryExpression unary = (UnaryExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, unary.astOperand());
            } else if (expression instanceof VariableReference) {
                VariableReference reference = (VariableReference)expression;
                variables.add(reference.astIdentifier().astValue());
            } else if (expression instanceof Select && (select = (Select)expression).astOperand() instanceof This) {
                variables.add(select.astIdentifier().astValue());
            }
        }

        private static boolean isBlockedAllocationMethod(MethodDeclaration node) {
            return PerformanceVisitor.isOnDrawMethod(node) || PerformanceVisitor.isOnMeasureMethod(node) || PerformanceVisitor.isOnLayoutMethod(node) || PerformanceVisitor.isLayoutMethod(node);
        }

        private static boolean isOnDrawMethod(MethodDeclaration node) {
            VariableDefinition arg0;
            TypeReferencePart type;
            String typeName;
            StrictListAccessor parameters;
            return JavaPerformanceDetector.ON_DRAW.equals(node.astMethodName().astValue()) && (parameters = node.astParameters()) != null && parameters.size() == 1 && (typeName = (type = (TypeReferencePart)(arg0 = (VariableDefinition)parameters.first()).astTypeReference().astParts().last()).getTypeName()).equals(JavaPerformanceDetector.CANVAS);
        }

        private static boolean isOnLayoutMethod(MethodDeclaration node) {
            StrictListAccessor parameters;
            if (JavaPerformanceDetector.ON_LAYOUT.equals(node.astMethodName().astValue()) && (parameters = node.astParameters()) != null && parameters.size() == 5) {
                Iterator iterator = parameters.iterator();
                if (!iterator.hasNext()) {
                    return false;
                }
                TypeReferencePart type = (TypeReferencePart)((VariableDefinition)iterator.next()).astTypeReference().astParts().last();
                if (!type.getTypeName().equals("boolean") || !iterator.hasNext()) {
                    return false;
                }
                for (int i = 0; i < 4; ++i) {
                    type = (TypeReferencePart)((VariableDefinition)iterator.next()).astTypeReference().astParts().last();
                    if (!type.getTypeName().equals("int")) {
                        return false;
                    }
                    if (iterator.hasNext()) continue;
                    return i == 3;
                }
            }
            return false;
        }

        private static boolean isOnMeasureMethod(MethodDeclaration node) {
            StrictListAccessor parameters;
            if (JavaPerformanceDetector.ON_MEASURE.equals(node.astMethodName().astValue()) && (parameters = node.astParameters()) != null && parameters.size() == 2) {
                VariableDefinition arg0 = (VariableDefinition)parameters.first();
                VariableDefinition arg1 = (VariableDefinition)parameters.last();
                TypeReferencePart type1 = (TypeReferencePart)arg0.astTypeReference().astParts().last();
                TypeReferencePart type2 = (TypeReferencePart)arg1.astTypeReference().astParts().last();
                return "int".equals(type1.getTypeName()) && "int".equals(type2.getTypeName());
            }
            return false;
        }

        private static boolean isLayoutMethod(MethodDeclaration node) {
            StrictListAccessor parameters;
            if (JavaPerformanceDetector.LAYOUT.equals(node.astMethodName().astValue()) && (parameters = node.astParameters()) != null && parameters.size() == 4) {
                Iterator iterator = parameters.iterator();
                for (int i = 0; i < 4; ++i) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    VariableDefinition next = (VariableDefinition)iterator.next();
                    TypeReferencePart type = (TypeReferencePart)next.astTypeReference().astParts().last();
                    if ("int".equals(type.getTypeName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void checkHashMap(ConstructorInvocation node, TypeReference reference) {
            StrictListAccessor types = reference.getTypeArguments();
            if (types != null && types.size() == 2) {
                TypeReference first = (TypeReference)types.first();
                String typeName = first.getTypeName();
                int minSdk = this.mContext.getMainProject().getMinSdk();
                if (typeName.equals(JavaPerformanceDetector.INTEGER) || typeName.equals(JavaPerformanceDetector.BYTE)) {
                    String valueType = ((TypeReference)types.last()).getTypeName();
                    if (valueType.equals(JavaPerformanceDetector.INTEGER)) {
                        this.mContext.report(USE_SPARSE_ARRAY, (Node)node, this.mContext.getLocation((Node)node), "Use new `SparseIntArray(...)` instead for better performance");
                    } else if (valueType.equals(JavaPerformanceDetector.LONG) && minSdk >= 18) {
                        this.mContext.report(USE_SPARSE_ARRAY, (Node)node, this.mContext.getLocation((Node)node), "Use `new SparseLongArray(...)` instead for better performance");
                    } else if (valueType.equals(JavaPerformanceDetector.BOOLEAN)) {
                        this.mContext.report(USE_SPARSE_ARRAY, (Node)node, this.mContext.getLocation((Node)node), "Use `new SparseBooleanArray(...)` instead for better performance");
                    } else {
                        this.mContext.report(USE_SPARSE_ARRAY, (Node)node, this.mContext.getLocation((Node)node), String.format("Use `new SparseArray<%1$s>(...)` instead for better performance", valueType));
                    }
                } else if (typeName.equals(JavaPerformanceDetector.LONG) && (minSdk >= 16 || Boolean.TRUE == this.mContext.getMainProject().dependsOn("com.android.support:support-v4"))) {
                    boolean useBuiltin = minSdk >= 16;
                    String message = useBuiltin ? "Use `new LongSparseArray(...)` instead for better performance" : "Use `new android.support.v4.util.LongSparseArray(...)` instead for better performance";
                    this.mContext.report(USE_SPARSE_ARRAY, (Node)node, this.mContext.getLocation((Node)node), message);
                }
            }
        }

        private void checkSparseArray(ConstructorInvocation node, TypeReference reference) {
            StrictListAccessor types = reference.getTypeArguments();
            if (types != null && types.size() == 1) {
                TypeReference first = (TypeReference)types.first();
                String valueType = first.getTypeName();
                if (valueType.equals(JavaPerformanceDetector.INTEGER)) {
                    this.mContext.report(USE_SPARSE_ARRAY, (Node)node, this.mContext.getLocation((Node)node), "Use `new SparseIntArray(...)` instead for better performance");
                } else if (valueType.equals(JavaPerformanceDetector.BOOLEAN)) {
                    this.mContext.report(USE_SPARSE_ARRAY, (Node)node, this.mContext.getLocation((Node)node), "Use `new SparseBooleanArray(...)` instead for better performance");
                }
            }
        }
    }
}

