/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.widgets.AvdCreationDialog;
import com.android.sdkuilib.internal.widgets.DeviceCreationDialog;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DeviceManagerPage
extends Composite
implements ISdkChangeListener,
DeviceManager.DevicesChangedListener,
DisposeListener {
    private final SwtUpdaterData mSwtUpdaterData;
    private final DeviceManager mDeviceManager;
    private Table mTable;
    private Button mNewButton;
    private Button mEditButton;
    private Button mDeleteButton;
    private Button mNewAvdButton;
    private Button mRefreshButton;
    private ImageFactory mImageFactory;
    private Image mUserImage;
    private Image mDeviceImage;
    private int mImageWidth;
    private boolean mDisableRefresh;
    private IAvdCreatedListener mAvdCreatedListener;
    private final ImageFactory.Filter mUserColorFilter = new ImageFactory.Filter(){

        @Override
        public Image filter(Image source) {
            ImageData srcData = source.getImageData();
            PaletteData p = srcData.palette;
            int b = p.blueMask;
            p.blueMask = p.greenMask;
            p.greenMask = b;
            b = p.blueShift;
            p.blueShift = p.greenShift;
            p.greenShift = b;
            return new Image(source.getDevice(), srcData);
        }
    };
    private static final String NEXUS = "Nexus";
    private static Pattern PATTERN = Pattern.compile("(\\d+\\.?\\d*)(?:in|\") (.+?)( \\(.*Nexus.*\\))?");

    public DeviceManagerPage(Composite parent, int swtStyle, SwtUpdaterData swtUpdaterData, DeviceManager deviceManager) {
        super(parent, swtStyle);
        this.mSwtUpdaterData = swtUpdaterData;
        this.mSwtUpdaterData.addListeners(this);
        this.mDeviceManager = deviceManager;
        this.mDeviceManager.registerListener(this);
        this.createContents(this);
        this.postCreate();
    }

    public void setAvdCreatedListener(IAvdCreatedListener avdCreatedListener) {
        this.mAvdCreatedListener = avdCreatedListener;
    }

    private void createContents(Composite parent) {
        this.mImageFactory = new ImageFactory(parent.getDisplay());
        this.mUserImage = this.getTagImage(null, true);
        this.mDeviceImage = this.getTagImage(null, false);
        this.mImageWidth = Math.max(this.mDeviceImage.getImageData().width, Math.max(this.mUserImage.getImageData().width, this.mDeviceImage.getImageData().width));
        GridLayoutBuilder.create(parent).columns(2);
        Label label = new Label(parent, 0);
        label.setText("List of known device definitions. This can later be used to create Android Virtual Devices.");
        GridDataBuilder.create((Control)label).hSpan(2);
        this.mTable = new Table(parent, 67588);
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(true);
        this.mTable.setFont(parent.getFont());
        this.setTableHeightHint(30);
        Composite buttons = new Composite(parent, 0);
        GridLayoutBuilder.create(buttons).columns(1).noMargins();
        GridDataBuilder.create((Control)buttons).vFill();
        buttons.setFont(parent.getFont());
        this.mNewAvdButton = new Button(buttons, 0x800008);
        this.mNewAvdButton.setLayoutData((Object)new GridData(768));
        this.mNewAvdButton.setText("Create AVD...");
        this.mNewAvdButton.setToolTipText("Creates a new AVD based on this device definition.");
        this.mNewAvdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceManagerPage.this.onCreateAvd();
            }
        });
        Label spacing = new Label(buttons, 0);
        this.mNewButton = new Button(buttons, 0x800008);
        this.mNewButton.setLayoutData((Object)new GridData(768));
        this.mNewButton.setText("Create Device...");
        this.mNewButton.setToolTipText("Creates a new user device definition.");
        this.mNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceManagerPage.this.onNewDevice();
            }
        });
        this.mEditButton = new Button(buttons, 0x800008);
        this.mEditButton.setLayoutData((Object)new GridData(768));
        this.mEditButton.setText("Edit...");
        this.mEditButton.setToolTipText("Edit an existing device definition.");
        this.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceManagerPage.this.onEditDevice();
            }
        });
        this.mDeleteButton = new Button(buttons, 0x800008);
        this.mDeleteButton.setLayoutData((Object)new GridData(768));
        this.mDeleteButton.setText("Delete...");
        this.mDeleteButton.setToolTipText("Deletes the selected AVD.");
        this.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceManagerPage.this.onDeleteDevice();
            }
        });
        Composite padding = new Composite(buttons, 0);
        padding.setLayoutData((Object)new GridData(1040));
        this.mRefreshButton = new Button(buttons, 0x800008);
        this.mRefreshButton.setLayoutData((Object)new GridData(768));
        this.mRefreshButton.setText("Refresh");
        this.mRefreshButton.setToolTipText("Reloads the list of devices.");
        this.mRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceManagerPage.this.onRefresh();
            }
        });
        Composite legend = new Composite(parent, 0);
        GridLayoutBuilder.create(legend).columns(4).noMargins();
        GridDataBuilder.create((Control)legend).hFill().vTop().hGrab().hSpan(2);
        legend.setFont(parent.getFont());
        new Label(legend, 0).setImage(this.mUserImage);
        new Label(legend, 0).setText("A user-created device definition.");
        new Label(legend, 0).setImage(this.mDeviceImage);
        new Label(legend, 0).setText("A generic device definition.");
        TableColumn column0 = new TableColumn(this.mTable, 0);
        column0.setText("Device");
        this.adjustColumnsWidth(this.mTable, column0);
        this.setupSelectionListener(this.mTable);
        this.fillTable(this.mTable);
        this.updateButtonStates();
        this.setEnabled(true);
    }

    private void adjustColumnsWidth(final Table table, final TableColumn column0) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = table.getClientArea();
                column0.setWidth(r.width * 100 / 100 - 1);
            }
        });
    }

    private void setupSelectionListener(Table table) {
    }

    public void setTableHeightHint(int heightHint) {
        GridData data = new GridData();
        if (heightHint > 0) {
            data.heightHint = heightHint;
        }
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.mTable.setLayoutData((Object)data);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public void dispose() {
        this.mSwtUpdaterData.removeListener(this);
        this.mDeviceManager.unregisterListener(this);
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void postCreate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTable(final Table table) {
        table.removeAll();
        this.disposeTableResources(table.getData("disposeResources"));
        ArrayList<Object> disposables = new ArrayList<Object>();
        Font boldFont = this.getBoldFont(table);
        if (boldFont != null) {
            disposables.add(boldFont);
        } else {
            boldFont = table.getFont();
        }
        try {
            this.mDisableRefresh = true;
            disposables.addAll(this.fillDevices(table, boldFont, true, this.mDeviceManager.getDevices(DeviceManager.DeviceFilter.USER)));
            disposables.addAll(this.fillDevices(table, boldFont, false, this.mDeviceManager.getDevices(EnumSet.of(DeviceManager.DeviceFilter.DEFAULT, DeviceManager.DeviceFilter.VENDOR, DeviceManager.DeviceFilter.SYSTEM_IMAGES))));
        }
        finally {
            this.mDisableRefresh = false;
        }
        table.setData("disposeResources", disposables);
        if (!Boolean.TRUE.equals(table.getData("createdTableListeners"))) {
            table.addListener(42, new Listener(){

                public void handleEvent(Event event) {
                    Object info;
                    if (event.item != null && (info = event.item.getData()) instanceof CellInfo) {
                        ((CellInfo)info).mWidget.draw(event.gc, event.x, event.y + 1);
                    }
                }
            });
            table.addListener(41, new Listener(){

                public void handleEvent(Event event) {
                    Object info;
                    if (event.item != null && (info = event.item.getData()) instanceof CellInfo) {
                        CellInfo ci = (CellInfo)info;
                        Rectangle bounds = ci.mBounds;
                        if (bounds == null) {
                            ci.mBounds = bounds = ci.mWidget.getBounds();
                        }
                        event.width = bounds.width + 2;
                        event.height = bounds.height + 4;
                    }
                }
            });
            table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    DeviceManagerPage.this.disposeTableResources(table.getData("disposeResources"));
                }
            });
            table.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    DeviceManagerPage.this.updateButtonStates();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    DeviceManagerPage.this.onEditDevice();
                }
            });
        }
        if (table.getItemCount() == 0) {
            table.setEnabled(true);
            TableItem item = new TableItem(table, 0);
            item.setData(null);
            item.setText(0, "No devices available");
            return;
        }
        table.setData("createdTableListeners", (Object)Boolean.TRUE);
    }

    private void disposeTableResources(Object disposablesList) {
        if (disposablesList instanceof List) {
            for (Object obj : (List)disposablesList) {
                if (!(obj instanceof Resource)) continue;
                ((Resource)obj).dispose();
            }
        }
    }

    private Font getBoldFont(Table table) {
        Display display = table.getDisplay();
        FontData[] fds = table.getFont().getFontData();
        if (fds != null && fds.length > 0) {
            fds[0].setStyle(1);
            return new Font((Device)display, fds[0]);
        }
        return null;
    }

    private List<Resource> fillDevices(Table table, Font boldFont, boolean isUser, Collection<com.android.sdklib.devices.Device> devicesCollection) {
        ArrayList<Resource> disposables = new ArrayList<Resource>();
        Display display = table.getDisplay();
        TextStyle boldStyle = new TextStyle();
        boldStyle.font = boldFont;
        ArrayList<com.android.sdklib.devices.Device> devices = new ArrayList<com.android.sdklib.devices.Device>(devicesCollection);
        Collections.sort(devices, com.android.sdklib.devices.Device.getDisplayComparator());
        HashMap<com.android.sdklib.devices.Device, LinkedList<String>> device2avdMap = new HashMap<com.android.sdklib.devices.Device, LinkedList<String>>();
        for (AvdInfo avd : this.mSwtUpdaterData.getAvdManager().getAllAvds()) {
            String n = avd.getDeviceName();
            String m = avd.getDeviceManufacturer();
            if (n == null || m == null || n.isEmpty() || m.isEmpty()) continue;
            for (com.android.sdklib.devices.Device device : devices) {
                if (!m.equals(device.getManufacturer()) || !n.equals(device.getName())) continue;
                LinkedList<String> list = (LinkedList<String>)device2avdMap.get(device);
                if (list == null) {
                    list = new LinkedList<String>();
                    device2avdMap.put(device, list);
                }
                list.add(avd.getName());
            }
        }
        String prefix = "\n    ";
        for (com.android.sdklib.devices.Device device : devices) {
            Image img;
            TableItem item = new TableItem(table, 0);
            TextLayout widget = new TextLayout((Device)display);
            CellInfo ci = new CellInfo(isUser, device, widget);
            item.setData((Object)ci);
            widget.setIndent(this.mImageWidth * 2);
            widget.setFont(table.getFont());
            StringBuilder sb = new StringBuilder();
            String name = DeviceManagerPage.getPrettyName(device, false);
            sb.append(name);
            int pos1 = sb.length();
            String manufacturer = device.getManufacturer();
            if (!manufacturer.contains(NEXUS)) {
                sb.append("  by ").append(manufacturer);
            }
            item.setImage((img = this.getTagImage(device.getTagId(), isUser)) != null ? img : this.mDeviceImage);
            Hardware hw = device.getDefaultHardware();
            Screen screen = hw.getScreen();
            sb.append("\n    ");
            sb.append(String.format(Locale.US, "Screen:   %1$.1f\", %2$d \u00d7 %3$d, %4$s %5$s", screen.getDiagonalLength(), screen.getXDimension(), screen.getYDimension(), screen.getSize().getShortDisplayValue(), screen.getPixelDensity().getResourceValue()));
            Storage sto = hw.getRam();
            Storage.Unit unit = sto.getSizeAsUnit(Storage.Unit.GiB) > 1L ? Storage.Unit.GiB : Storage.Unit.MiB;
            sb.append("\n    ");
            sb.append(String.format(Locale.US, "RAM:       %1$d %2$s", new Object[]{sto.getSizeAsUnit(unit), unit}));
            List avdList = (List)device2avdMap.get(device);
            if (avdList != null && !avdList.isEmpty()) {
                sb.append("\n    ");
                sb.append("Used by: ");
                boolean first = true;
                for (String avd : avdList) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(avd);
                    first = false;
                }
            }
            widget.setText(sb.toString());
            widget.setStyle(boldStyle, 0, pos1);
        }
        return disposables;
    }

    @Nullable
    private Image getTagImage(@NonNull String tagId, boolean isUser) {
        if (tagId == null) {
            tagId = SystemImage.DEFAULT_TAG.getId();
        }
        String fname = String.format("tag_%s_32.png", tagId);
        String kname = (isUser ? "user_" : "dev_") + fname;
        return this.mImageFactory.getImageByName(fname, kname, isUser ? this.mUserColorFilter : null);
    }

    private static String getPrettyName(com.android.sdklib.devices.Device d, boolean leadZeroes) {
        Matcher matcher;
        if (d == null) {
            return "";
        }
        String name = d.getName();
        if (name.equals("3.7 FWVGA slider")) {
            name = "3.7in FWVGA slider";
        }
        if ((matcher = PATTERN.matcher(name)).matches()) {
            String size = matcher.group(1);
            String n = matcher.group(2);
            int dot = size.indexOf(46);
            if (dot == -1) {
                size = size + ".0";
                dot = size.length() - 2;
            }
            if (leadZeroes && dot < 3) {
                size = "000".substring(dot) + size;
            }
            name = size + "\" " + n;
        }
        return name;
    }

    private CellInfo getTableSelection() {
        if (this.mTable.isDisposed()) {
            return null;
        }
        int selIndex = this.mTable.getSelectionIndex();
        if (selIndex >= 0) {
            return (CellInfo)this.mTable.getItem(selIndex).getData();
        }
        return null;
    }

    private void updateButtonStates() {
        CellInfo ci = this.getTableSelection();
        this.mNewButton.setEnabled(true);
        this.mEditButton.setEnabled(ci != null);
        this.mEditButton.setText(ci != null && !ci.mIsUser ? "Clone..." : "Edit...");
        this.mDeleteButton.setEnabled(ci != null && ci.mIsUser);
        this.mNewAvdButton.setEnabled(ci != null);
        this.mRefreshButton.setEnabled(true);
    }

    private void onNewDevice() {
        DeviceCreationDialog dlg = new DeviceCreationDialog(this.getShell(), this.mDeviceManager, this.mSwtUpdaterData.getImageFactory(), null);
        if (dlg.open() == 0) {
            this.onRefresh();
            this.selectCellByDevice(dlg.getCreatedDevice());
            this.updateButtonStates();
        }
    }

    private void onEditDevice() {
        CellInfo ci = this.getTableSelection();
        if (ci == null || ci.mDevice == null) {
            return;
        }
        DeviceCreationDialog dlg = new DeviceCreationDialog(this.getShell(), this.mDeviceManager, this.mSwtUpdaterData.getImageFactory(), ci.mDevice);
        if (dlg.open() == 0) {
            this.onRefresh();
            this.selectCellByDevice(dlg.getCreatedDevice());
            this.updateButtonStates();
        }
    }

    private void onDeleteDevice() {
        CellInfo ci = this.getTableSelection();
        if (ci == null || ci.mDevice == null || !ci.mIsUser) {
            return;
        }
        final String name = DeviceManagerPage.getPrettyName(ci.mDevice, false);
        final AtomicBoolean result = new AtomicBoolean(false);
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = DeviceManagerPage.this.getDisplay().getActiveShell();
                boolean ok = MessageDialog.openQuestion(shell, "Delete Device Definition", String.format("Please confirm that you want to delete the device definition named '%s'. This operation cannot be reverted.", name));
                result.set(ok);
            }
        });
        if (result.get()) {
            this.mDeviceManager.removeUserDevice(ci.mDevice);
            this.mDeviceManager.saveUserDevices();
            this.onRefresh();
        }
    }

    private void onCreateAvd() {
        CellInfo ci = this.getTableSelection();
        if (ci == null || ci.mDevice == null) {
            return;
        }
        AvdCreationDialog dlg = new AvdCreationDialog(this.mTable.getShell(), this.mSwtUpdaterData.getAvdManager(), this.mImageFactory, this.mSwtUpdaterData.getSdkLog(), null);
        dlg.selectInitialDevice(ci.mDevice);
        if (dlg.open() == 0) {
            this.onRefresh();
            if (this.mAvdCreatedListener != null) {
                this.mAvdCreatedListener.onAvdCreated(dlg.getCreatedAvd());
            }
        }
    }

    private void onRefresh() {
        if (this.mDisableRefresh || this.mTable.isDisposed()) {
            return;
        }
        int selIndex = this.mTable.getSelectionIndex();
        CellInfo selected = this.getTableSelection();
        this.fillTable(this.mTable);
        if (selected != null && this.selectCellByName(selected)) {
            this.updateButtonStates();
            return;
        }
        if (selIndex >= 0 && selIndex < this.mTable.getItemCount()) {
            this.mTable.select(selIndex);
        }
    }

    private boolean selectCellByName(CellInfo selected) {
        if (this.mTable.isDisposed() || selected == null || selected.mDevice == null) {
            return false;
        }
        String name = selected.mDevice.getName();
        for (int n = this.mTable.getItemCount() - 1; n >= 0; --n) {
            CellInfo ci;
            TableItem item = this.mTable.getItem(n);
            Object data = item.getData();
            if (!(data instanceof CellInfo) || (ci = (CellInfo)data) == null || ci.mDevice == null || !name.equals(ci.mDevice.getName())) continue;
            this.mTable.select(n);
            return true;
        }
        return false;
    }

    private boolean selectCellByDevice(com.android.sdklib.devices.Device selected) {
        if (this.mTable.isDisposed() || selected == null) {
            return false;
        }
        for (int n = this.mTable.getItemCount() - 1; n >= 0; --n) {
            CellInfo ci;
            TableItem item = this.mTable.getItem(n);
            Object data = item.getData();
            if (!(data instanceof CellInfo) || (ci = (CellInfo)data) == null || ci.mDevice != selected) continue;
            this.mTable.select(n);
            return true;
        }
        return false;
    }

    @Override
    public void onSdkLoaded() {
        this.onSdkReload();
    }

    @Override
    public void onSdkReload() {
        this.onRefresh();
    }

    @Override
    public void preInstallHook() {
    }

    @Override
    public void postInstallHook() {
    }

    @Override
    public void onDevicesChanged() {
        this.onRefresh();
    }

    private static class CellInfo {
        final boolean mIsUser;
        final com.android.sdklib.devices.Device mDevice;
        final TextLayout mWidget;
        Rectangle mBounds;

        CellInfo(boolean isUser, com.android.sdklib.devices.Device device, TextLayout widget) {
            this.mIsUser = isUser;
            this.mDevice = device;
            this.mWidget = widget;
        }
    }

    public static interface IAvdCreatedListener {
        public void onAvdCreated(AvdInfo var1);
    }
}

