/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.widgets.AvdCreationPresenter;
import com.android.sdkuilib.internal.widgets.IMessageBoxLogger;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.sdkuilib.ui.GridDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AvdCreationSwtView
extends GridDialog {
    private final ImageFactory mImageFactory;
    private final AvdCreationPresenter mPresenter;
    private Button mBtnOK;
    private Text mTextAvdName;
    private Combo mComboDevice;
    private Combo mComboTarget;
    private Combo mComboTagAbi;
    private Button mCheckKeyboard;
    private Combo mComboSkinCombo;
    private Combo mComboFrontCamera;
    private Combo mComboBackCamera;
    private Button mCheckSnapshot;
    private Button mCheckGpuEmulation;
    private Text mTextRam;
    private Text mTextVmHeap;
    private Text mTextDataPartition;
    private Combo mComboDataPartitionSize;
    private Button mRadioSdCardSize;
    private Text mTextSdCardSize;
    private Combo mComboSdCardSize;
    private Button mRadioSdCardFile;
    private Text mTextSdCardFile;
    private Button mBtnBrowseSdCard;
    private Button mCheckForceCreation;
    private Composite mCompositeStatus;
    private Label mIconStatus;
    private Label mTextStatus;
    private final Map<AvdCreationPresenter.Ctrl, Control> mControlMap = new HashMap<AvdCreationPresenter.Ctrl, Control>();
    private final VerifyListener mDigitVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            int count = event.text.length();
            for (int i = 0; i < count; ++i) {
                char c = event.text.charAt(i);
                if (c >= '0' && c <= '9') continue;
                event.doit = false;
                return;
            }
        }
    };

    public AvdCreationSwtView(Shell shell, @NonNull ImageFactory imageFactory, @NonNull AvdCreationPresenter presenter) {
        super(shell, 2, false);
        this.mImageFactory = imageFactory;
        this.mPresenter = presenter;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mPresenter.setWidgetAdapter(new AvdCreationPresenter.IWidgetAdapter(){

            @Override
            public void setTitle(@NonNull String title) {
                AvdCreationSwtView.this.getShell().setText(title);
            }

            @Override
            public int getComboIndex(@NonNull AvdCreationPresenter.Ctrl ctrl) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Combo) {
                    return ((Combo)c).getSelectionIndex();
                }
                return -1;
            }

            @Override
            public int getComboSize(@NonNull AvdCreationPresenter.Ctrl ctrl) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Combo) {
                    return ((Combo)c).getItemCount();
                }
                return 0;
            }

            @Override
            @Nullable
            public String getComboItem(@NonNull AvdCreationPresenter.Ctrl ctrl, int index) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Combo) {
                    return ((Combo)c).getItem(index);
                }
                return null;
            }

            @Override
            public void selectComboIndex(@NonNull AvdCreationPresenter.Ctrl ctrl, int index) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Combo) {
                    ((Combo)c).select(index);
                }
            }

            @Override
            public void addComboItem(@NonNull AvdCreationPresenter.Ctrl ctrl, String label) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Combo) {
                    ((Combo)c).add(label);
                }
            }

            @Override
            public void setComboItems(@NonNull AvdCreationPresenter.Ctrl ctrl, String[] labels) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Combo) {
                    Combo combo = (Combo)c;
                    combo.removeAll();
                    if (labels != null) {
                        combo.setItems(labels);
                    }
                }
            }

            @Override
            public boolean isEnabled(@NonNull AvdCreationPresenter.Ctrl ctrl) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(@NonNull AvdCreationPresenter.Ctrl ctrl, boolean enabled) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c != null) {
                    c.setEnabled(enabled);
                }
            }

            @Override
            public boolean isChecked(@NonNull AvdCreationPresenter.Ctrl ctrl) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Button) {
                    return ((Button)c).getSelection();
                }
                return false;
            }

            @Override
            public void setChecked(@NonNull AvdCreationPresenter.Ctrl ctrl, boolean checked) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Button) {
                    ((Button)c).setSelection(checked);
                }
            }

            @Override
            public String getText(@NonNull AvdCreationPresenter.Ctrl ctrl) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Text) {
                    return ((Text)c).getText();
                }
                if (c instanceof Combo) {
                    return ((Combo)c).getText();
                }
                if (c instanceof Label) {
                    return ((Label)c).getText();
                }
                if (c instanceof Button) {
                    return ((Button)c).getText();
                }
                return null;
            }

            @Override
            public void setText(@NonNull AvdCreationPresenter.Ctrl ctrl, @NonNull String text) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Text) {
                    ((Text)c).setText(text);
                } else if (c instanceof Combo) {
                    ((Combo)c).setText(text);
                } else if (c instanceof Label) {
                    ((Label)c).setText(text);
                } else if (c instanceof Button) {
                    ((Button)c).setText(text);
                }
            }

            @Override
            public void setImage(@NonNull AvdCreationPresenter.Ctrl ctrl, @Nullable String imageName) {
                Control c = (Control)AvdCreationSwtView.this.mControlMap.get((Object)ctrl);
                if (c instanceof Label) {
                    ((Label)c).setImage(imageName == null ? null : AvdCreationSwtView.this.mImageFactory.getImageByName(imageName));
                }
            }

            @Override
            @Nullable
            public String openFileDialog(@NonNull String title) {
                FileDialog dlg = new FileDialog(AvdCreationSwtView.this.getContents().getShell(), 4096);
                dlg.setText(title);
                return dlg.open();
            }

            @Override
            public void repack() {
                AvdCreationSwtView.this.mCompositeStatus.pack(true);
                AvdCreationSwtView.this.getShell().layout(true, true);
            }

            @Override
            public IMessageBoxLogger newDelayedMessageBoxLog(String title, boolean logErrorsOnly) {
                return new MessageBoxLog(title, AvdCreationSwtView.this.getContents().getDisplay(), logErrorsOnly);
            }
        });
    }

    @NonNull
    public AvdCreationPresenter getPresenter() {
        return this.mPresenter;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setMinimumSize(new Point(350, 600));
        this.mBtnOK = this.getButton(0);
        this.registerControlMap();
        this.mPresenter.onViewInit();
        return control;
    }

    @Override
    public void createDialogContent(Composite parent) {
        ValidateListener validateListener = new ValidateListener();
        Label label = new Label(parent, 0);
        label.setText("AVD Name:");
        String tooltip = "The name of the Android Virtual Device";
        label.setToolTipText(tooltip);
        this.mTextAvdName = new Text(parent, 2048);
        this.mTextAvdName.setLayoutData((Object)new GridData(768));
        this.mTextAvdName.addModifyListener((ModifyListener)new CreateNameModifyListener());
        label = new Label(parent, 0);
        label.setText("Device:");
        tooltip = "The device this AVD will be based on";
        this.mComboDevice = new Combo(parent, 12);
        this.mComboDevice.setLayoutData((Object)new GridData(768));
        this.mComboDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdCreationSwtView.this.mPresenter.onDeviceComboChanged();
            }
        });
        label = new Label(parent, 0);
        label.setText("Target:");
        tooltip = "The target API of the AVD";
        label.setToolTipText(tooltip);
        this.mComboTarget = new Combo(parent, 12);
        this.mComboTarget.setLayoutData((Object)new GridData(768));
        this.mComboTarget.setToolTipText(tooltip);
        this.mComboTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvdCreationSwtView.this.mPresenter.onTargetComboChanged();
            }
        });
        label = new Label(parent, 0);
        label.setText("CPU/ABI:");
        tooltip = "The CPU/ABI of the virtual device";
        label.setToolTipText(tooltip);
        this.mComboTagAbi = new Combo(parent, 12);
        this.mComboTagAbi.setLayoutData((Object)new GridData(768));
        this.mComboTagAbi.setToolTipText(tooltip);
        this.mComboTagAbi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvdCreationSwtView.this.mPresenter.onTagComboChanged();
            }
        });
        label = new Label(parent, 0);
        label.setText("Keyboard:");
        this.mCheckKeyboard = new Button(parent, 32);
        this.mCheckKeyboard.setSelection(true);
        this.mCheckKeyboard.setLayoutData((Object)new GridData(768));
        this.mCheckKeyboard.setText("Hardware keyboard present");
        label = new Label(parent, 0);
        label.setText("Skin:");
        this.mComboSkinCombo = new Combo(parent, 12);
        this.mComboSkinCombo.setLayoutData((Object)new GridData(768));
        this.mComboSkinCombo.addSelectionListener((SelectionListener)validateListener);
        label = new Label(parent, 0);
        label.setText("Front Camera:");
        tooltip = "";
        label.setToolTipText(tooltip);
        this.mComboFrontCamera = new Combo(parent, 12);
        this.mComboFrontCamera.setLayoutData((Object)new GridData(768));
        this.mComboFrontCamera.add("None");
        this.mComboFrontCamera.add("Emulated");
        this.mComboFrontCamera.add("Webcam0");
        this.mComboFrontCamera.select(0);
        label = new Label(parent, 0);
        label.setText("Back Camera:");
        tooltip = "";
        label.setToolTipText(tooltip);
        this.mComboBackCamera = new Combo(parent, 12);
        this.mComboBackCamera.setLayoutData((Object)new GridData(768));
        this.mComboBackCamera.add("None");
        this.mComboBackCamera.add("Emulated");
        this.mComboBackCamera.add("Webcam0");
        this.mComboBackCamera.select(0);
        label = new Label(parent, 0);
        label.setText("Memory Options:");
        Group memoryGroup = new Group(parent, 0);
        memoryGroup.setLayoutData((Object)new GridData(768));
        memoryGroup.setLayout((Layout)new GridLayout(4, false));
        label = new Label((Composite)memoryGroup, 0);
        label.setText("RAM:");
        tooltip = "The amount of RAM the emulated device should have in MiB";
        label.setToolTipText(tooltip);
        this.mTextRam = new Text((Composite)memoryGroup, 2048);
        this.mTextRam.addVerifyListener(this.mDigitVerifier);
        this.mTextRam.addModifyListener((ModifyListener)validateListener);
        this.mTextRam.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)memoryGroup, 0);
        label.setText("VM Heap:");
        tooltip = "The amount of memory, in MiB, available to typical Android applications";
        label.setToolTipText(tooltip);
        this.mTextVmHeap = new Text((Composite)memoryGroup, 2048);
        this.mTextVmHeap.addVerifyListener(this.mDigitVerifier);
        this.mTextVmHeap.addModifyListener((ModifyListener)validateListener);
        this.mTextVmHeap.setLayoutData((Object)new GridData(768));
        this.mTextVmHeap.setToolTipText(tooltip);
        label = new Label(parent, 0);
        label.setText("Internal Storage:");
        tooltip = "The size of the data partition on the device.";
        Group storageGroup = new Group(parent, 0);
        storageGroup.setLayoutData((Object)new GridData(768));
        storageGroup.setLayout((Layout)new GridLayout(2, false));
        this.mTextDataPartition = new Text((Composite)storageGroup, 2048);
        this.mTextDataPartition.setText("200");
        this.mTextDataPartition.addVerifyListener(this.mDigitVerifier);
        this.mTextDataPartition.addModifyListener((ModifyListener)validateListener);
        this.mTextDataPartition.setLayoutData((Object)new GridData(768));
        this.mComboDataPartitionSize = new Combo((Composite)storageGroup, 12);
        this.mComboDataPartitionSize.add("MiB");
        this.mComboDataPartitionSize.add("GiB");
        this.mComboDataPartitionSize.select(0);
        this.mComboDataPartitionSize.addModifyListener((ModifyListener)validateListener);
        label = new Label(parent, 0);
        label.setText("SD Card:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group sdCardGroup = new Group(parent, 0);
        sdCardGroup.setLayoutData((Object)new GridData(768));
        sdCardGroup.setLayout((Layout)new GridLayout(3, false));
        this.mRadioSdCardSize = new Button((Composite)sdCardGroup, 16);
        this.mRadioSdCardSize.setText("Size:");
        this.mRadioSdCardSize.setToolTipText("Create a new SD Card file");
        this.mRadioSdCardSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdCreationSwtView.this.mPresenter.onRadioSdCardSizeChanged();
            }
        });
        this.mTextSdCardSize = new Text((Composite)sdCardGroup, 2048);
        this.mTextSdCardSize.setLayoutData((Object)new GridData(768));
        this.mTextSdCardSize.addVerifyListener(this.mDigitVerifier);
        this.mTextSdCardSize.addModifyListener((ModifyListener)validateListener);
        this.mTextSdCardSize.setToolTipText("Size of the new SD Card file (must be at least 9 MiB)");
        this.mComboSdCardSize = new Combo((Composite)sdCardGroup, 12);
        this.mComboSdCardSize.add("KiB");
        this.mComboSdCardSize.add("MiB");
        this.mComboSdCardSize.add("GiB");
        this.mComboSdCardSize.select(1);
        this.mComboSdCardSize.addSelectionListener((SelectionListener)validateListener);
        this.mRadioSdCardFile = new Button((Composite)sdCardGroup, 16);
        this.mRadioSdCardFile.setText("File:");
        this.mRadioSdCardFile.setToolTipText("Use an existing file for the SD Card");
        this.mTextSdCardFile = new Text((Composite)sdCardGroup, 2048);
        this.mTextSdCardFile.setLayoutData((Object)new GridData(768));
        this.mTextSdCardFile.addModifyListener((ModifyListener)validateListener);
        this.mTextSdCardFile.setToolTipText("File to use for the SD Card");
        this.mBtnBrowseSdCard = new Button((Composite)sdCardGroup, 8);
        this.mBtnBrowseSdCard.setText("Browse...");
        this.mBtnBrowseSdCard.setToolTipText("Select the file to use for the SD Card");
        this.mBtnBrowseSdCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdCreationSwtView.this.mPresenter.onBrowseSdCard();
            }
        });
        this.mRadioSdCardSize.setSelection(true);
        label = new Label(parent, 0);
        label.setText("Emulation Options:");
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setLayout((Layout)new GridLayout(2, true));
        this.mCheckSnapshot = new Button((Composite)optionsGroup, 32);
        this.mCheckSnapshot.setText("Snapshot");
        this.mCheckSnapshot.setToolTipText("Emulator's state will be persisted between emulator executions");
        this.mCheckSnapshot.addSelectionListener((SelectionListener)validateListener);
        this.mCheckGpuEmulation = new Button((Composite)optionsGroup, 32);
        this.mCheckGpuEmulation.setText("Use Host GPU");
        this.mCheckGpuEmulation.setToolTipText("Enable hardware OpenGLES emulation");
        this.mCheckGpuEmulation.addSelectionListener((SelectionListener)validateListener);
        this.mCheckForceCreation = new Button(parent, 32);
        this.mCheckForceCreation.setText("Override the existing AVD with the same name");
        this.mCheckForceCreation.setToolTipText("There's already an AVD with the same name. Check this to delete it and replace it by the new AVD.");
        this.mCheckForceCreation.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mCheckForceCreation.setEnabled(false);
        this.mCheckForceCreation.addSelectionListener((SelectionListener)validateListener);
        label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.mCompositeStatus = new Composite(parent, 0);
        this.mCompositeStatus.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        GridLayout gl = new GridLayout(2, false);
        this.mCompositeStatus.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mIconStatus = new Label(this.mCompositeStatus, 0);
        this.mIconStatus.setLayoutData((Object)new GridData(1, 1, false, false));
        this.mTextStatus = new Label(this.mCompositeStatus, 64);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.heightHint = 50;
        this.mTextStatus.setLayoutData((Object)gridData);
        this.mTextStatus.setText("");
    }

    private void registerControlMap() {
        this.mControlMap.put(AvdCreationPresenter.Ctrl.BUTTON_OK, (Control)this.mBtnOK);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.BUTTON_BROWSE_SDCARD, (Control)this.mBtnBrowseSdCard);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_DEVICE, (Control)this.mComboDevice);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_TARGET, (Control)this.mComboTarget);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_TAG_ABI, (Control)this.mComboTagAbi);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_SKIN, (Control)this.mComboSkinCombo);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_FRONT_CAM, (Control)this.mComboFrontCamera);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_BACK_CAM, (Control)this.mComboBackCamera);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_DATA_PART_SIZE, (Control)this.mComboDataPartitionSize);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.COMBO_SDCARD_SIZE, (Control)this.mComboSdCardSize);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.CHECK_FORCE_CREATION, (Control)this.mCheckForceCreation);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.CHECK_KEYBOARD, (Control)this.mCheckKeyboard);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.CHECK_SNAPSHOT, (Control)this.mCheckSnapshot);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.CHECK_GPU_EMUL, (Control)this.mCheckGpuEmulation);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.RADIO_SDCARD_SIZE, (Control)this.mRadioSdCardSize);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.RADIO_SDCARD_FILE, (Control)this.mRadioSdCardFile);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.TEXT_AVD_NAME, (Control)this.mTextAvdName);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.TEXT_RAM, (Control)this.mTextRam);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.TEXT_VM_HEAP, (Control)this.mTextVmHeap);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.TEXT_DATA_PART, (Control)this.mTextDataPartition);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.TEXT_SDCARD_SIZE, (Control)this.mTextSdCardSize);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.TEXT_SDCARD_FILE, (Control)this.mTextSdCardFile);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.ICON_STATUS, (Control)this.mIconStatus);
        this.mControlMap.put(AvdCreationPresenter.Ctrl.TEXT_STATUS, (Control)this.mTextStatus);
    }

    @Override
    public void okPressed() {
        if (this.mPresenter.createAvd()) {
            super.okPressed();
        }
    }

    private class CreateNameModifyListener
    implements ModifyListener {
        private CreateNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            AvdCreationSwtView.this.mPresenter.onAvdNameModified();
        }
    }

    private class ValidateListener
    extends SelectionAdapter
    implements ModifyListener {
        private ValidateListener() {
        }

        public void modifyText(ModifyEvent e) {
            AvdCreationSwtView.this.mPresenter.validatePage();
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            AvdCreationSwtView.this.mPresenter.validatePage();
        }
    }
}

