/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.annotations.Nullable;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.ResourceEnum;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Network;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridDialog;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import java.util.Collection;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DeviceCreationDialog
extends GridDialog {
    private static final String MANUFACTURER = "User";
    private final ImageFactory mImageFactory;
    private final DeviceManager mManager;
    private Collection<Device> mUserDevices;
    private Device mDevice;
    private Text mDeviceName;
    private Text mDiagonalLength;
    private Text mXDimension;
    private Text mYDimension;
    private Button mKeyboard;
    private Button mDpad;
    private Button mTrackball;
    private Button mNoNav;
    private Text mRam;
    private Combo mRamCombo;
    private Combo mButtons;
    private Combo mSize;
    private Combo mDensity;
    private Combo mRatio;
    private Button mAccelerometer;
    private Button mGyro;
    private Button mGps;
    private Button mProximitySensor;
    private Button mCameraFront;
    private Button mCameraRear;
    private Group mStateGroup;
    private Button mPortrait;
    private Label mPortraitLabel;
    private Button mPortraitNav;
    private Button mLandscape;
    private Label mLandscapeLabel;
    private Button mLandscapeNav;
    private Button mPortraitKeys;
    private Label mPortraitKeysLabel;
    private Button mPortraitKeysNav;
    private Button mLandscapeKeys;
    private Label mLandscapeKeysLabel;
    private Button mLandscapeKeysNav;
    private Button mForceCreation;
    private Label mStatusIcon;
    private Label mStatusLabel;
    private Button mOkButton;
    private Hardware mHardware;
    private Device mCreatedDevice;
    private static final Software mSoftware = new Software();

    public DeviceCreationDialog(Shell parentShell, DeviceManager manager, ImageFactory imageFactory, @Nullable Device device) {
        super(parentShell, 3, false);
        this.mImageFactory = imageFactory;
        this.mDevice = device;
        this.mManager = manager;
        this.mUserDevices = this.mManager.getDevices(DeviceManager.DeviceFilter.USER);
    }

    public Device getCreatedDevice() {
        return this.mCreatedDevice;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.mOkButton = this.getButton(0);
        if (this.mDevice == null) {
            this.getShell().setText("Create New Device");
        } else if (this.mUserDevices.contains(this.mDevice)) {
            this.getShell().setText("Edit Device");
        } else {
            this.getShell().setText("Clone Device");
        }
        Object ld = this.mOkButton.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = 100;
        }
        this.validatePage();
        return control;
    }

    @Override
    public void createDialogContent(Composite parent) {
        ValidationListener validator = new ValidationListener();
        SizeListener sizeListener = new SizeListener();
        NavStateListener navListener = new NavStateListener();
        Composite column1 = new Composite(parent, 0);
        GridDataBuilder.create((Control)column1).hFill().vTop();
        GridLayoutBuilder.create(column1).columns(2);
        Label label = new Label(parent, 514);
        GridDataBuilder.create((Control)label).vFill().vGrab();
        Composite column2 = new Composite(parent, 0);
        GridDataBuilder.create((Control)column2).hFill().vTop();
        GridLayoutBuilder.create(column2).columns(2);
        String tooltip = "Name of the new device";
        this.generateLabel("Name:", tooltip, column1);
        this.mDeviceName = this.generateText(column1, tooltip, new CreateNameModifyListener());
        tooltip = "Diagonal length of the screen in inches";
        this.generateLabel("Screen Size (in):", tooltip, column1);
        this.mDiagonalLength = this.generateText(column1, tooltip, sizeListener);
        tooltip = "The resolution of the device in pixels";
        this.generateLabel("Resolution (px):", tooltip, column1);
        Composite dimensionGroup = new Composite(column1, 0);
        GridDataBuilder.create((Control)dimensionGroup).hFill();
        GridLayoutBuilder.create(dimensionGroup).columns(3).noMargins();
        this.mXDimension = this.generateText(dimensionGroup, tooltip, sizeListener);
        new Label(dimensionGroup, 0).setText("x");
        this.mYDimension = this.generateText(dimensionGroup, tooltip, sizeListener);
        label = new Label(column1, 0);
        GridDataBuilder.create((Control)label).hFill().hGrab().hSpan(2);
        tooltip = "The screen size bucket that the device falls into";
        this.generateLabel("Size:", tooltip, column2);
        this.mSize = this.generateCombo(column2, tooltip, (ResourceEnum[])ScreenSize.values(), 1, validator);
        tooltip = "The aspect ratio bucket the screen falls into. A \"long\" screen is wider.";
        this.generateLabel("Screen Ratio:", tooltip, column2);
        this.mRatio = this.generateCombo(column2, tooltip, (ResourceEnum[])ScreenRatio.values(), 1, validator);
        tooltip = "The pixel density bucket the device falls in";
        this.generateLabel("Density:", tooltip, column2);
        this.mDensity = this.generateCombo(column2, tooltip, (ResourceEnum[])Density.values(), 3, validator);
        label = new Label(column2, 0);
        GridDataBuilder.create((Control)label).hFill().hGrab().hSpan(2);
        this.generateLabel("Sensors:", "The sensors available on the device", column1);
        Group sensorGroup = new Group(column1, 0);
        sensorGroup.setLayoutData((Object)new GridData(768));
        sensorGroup.setLayout((Layout)new GridLayout(2, false));
        this.mAccelerometer = this.generateButton((Composite)sensorGroup, "Accelerometer", "Presence of an accelerometer", 32, true, (SelectionListener)validator);
        this.mGyro = this.generateButton((Composite)sensorGroup, "Gyroscope", "Presence of a gyroscope", 32, true, (SelectionListener)validator);
        this.mGps = this.generateButton((Composite)sensorGroup, "GPS", "Presence of a GPS", 32, true, (SelectionListener)validator);
        this.mProximitySensor = this.generateButton((Composite)sensorGroup, "Proximity Sensor", "Presence of a proximity sensor", 32, true, (SelectionListener)validator);
        this.generateLabel("Cameras", "The cameras available on the device", column1);
        Group cameraGroup = new Group(column1, 0);
        cameraGroup.setLayoutData((Object)new GridData(768));
        cameraGroup.setLayout((Layout)new GridLayout(2, false));
        this.mCameraFront = this.generateButton((Composite)cameraGroup, "Front", "Presence of a front camera", 32, false, (SelectionListener)validator);
        this.mCameraRear = this.generateButton((Composite)cameraGroup, "Rear", "Presence of a rear camera", 32, true, (SelectionListener)validator);
        this.generateLabel("Input:", "The input hardware on the given device", column1);
        Group inputGroup = new Group(column1, 0);
        inputGroup.setLayoutData((Object)new GridData(768));
        inputGroup.setLayout((Layout)new GridLayout(3, false));
        this.mKeyboard = this.generateButton((Composite)inputGroup, "Keyboard", "Presence of a hardware keyboard", 32, false, (SelectionListener)new KeyboardListener());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.mKeyboard.setLayoutData((Object)gridData);
        this.mNoNav = this.generateButton((Composite)inputGroup, "No Nav", "No hardware navigation", 16, true, (SelectionListener)navListener);
        this.mDpad = this.generateButton((Composite)inputGroup, "DPad", "The device has a DPad navigation element", 16, false, (SelectionListener)navListener);
        this.mTrackball = this.generateButton((Composite)inputGroup, "Trackball", "The device has a trackball navigation element", 16, false, (SelectionListener)navListener);
        tooltip = "The amount of RAM on the device";
        this.generateLabel("RAM:", tooltip, column1);
        Group ramGroup = new Group(column1, 0);
        ramGroup.setLayoutData((Object)new GridData(768));
        ramGroup.setLayout((Layout)new GridLayout(2, false));
        this.mRam = this.generateText((Composite)ramGroup, tooltip, validator);
        this.mRamCombo = new Combo((Composite)ramGroup, 12);
        this.mRamCombo.setToolTipText(tooltip);
        this.mRamCombo.add("MiB");
        this.mRamCombo.add("GiB");
        this.mRamCombo.select(0);
        this.mRamCombo.addModifyListener((ModifyListener)validator);
        tooltip = "Type of buttons (Home, Menu, etc.) on the device. This can be software buttons like on the Galaxy Nexus, or hardware buttons like the capacitive buttons on the Nexus S.";
        this.generateLabel("Buttons:", tooltip, column2);
        this.mButtons = new Combo(column2, 12);
        this.mButtons.setToolTipText(tooltip);
        this.mButtons.add(ButtonType.SOFT.getDescription());
        this.mButtons.add(ButtonType.HARD.getDescription());
        this.mButtons.setLayoutData((Object)new GridData(768));
        this.mButtons.select(0);
        this.mButtons.addModifyListener((ModifyListener)validator);
        this.generateLabel("Device States:", "The available states for the given device", column2);
        this.mStateGroup = new Group(column2, 0);
        this.mStateGroup.setLayoutData((Object)new GridData(768));
        this.mStateGroup.setLayout((Layout)new GridLayout(2, true));
        tooltip = "The device has a portait position with no keyboard available";
        this.mPortraitLabel = this.generateLabel("Portrait:", tooltip, (Composite)this.mStateGroup);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mPortraitLabel.setLayoutData((Object)gridData);
        this.mPortrait = this.generateButton((Composite)this.mStateGroup, "Enabled", tooltip, 32, true, (SelectionListener)navListener);
        this.mPortraitNav = this.generateButton((Composite)this.mStateGroup, "Navigation", "Hardware navigation is available in this state", 32, true, (SelectionListener)validator);
        this.mPortraitNav.setEnabled(false);
        tooltip = "The device has a landscape position with no keyboard available";
        this.mLandscapeLabel = this.generateLabel("Landscape:", tooltip, (Composite)this.mStateGroup);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mLandscapeLabel.setLayoutData((Object)gridData);
        this.mLandscape = this.generateButton((Composite)this.mStateGroup, "Enabled", tooltip, 32, true, (SelectionListener)navListener);
        this.mLandscapeNav = this.generateButton((Composite)this.mStateGroup, "Navigation", "Hardware navigation is available in this state", 32, true, (SelectionListener)validator);
        this.mLandscapeNav.setEnabled(false);
        tooltip = "The device has a portait position with a keyboard available";
        this.mPortraitKeysLabel = this.generateLabel("Portrait with keyboard:", tooltip, (Composite)this.mStateGroup);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mPortraitKeysLabel.setLayoutData((Object)gridData);
        this.mPortraitKeysLabel.setEnabled(false);
        this.mPortraitKeys = this.generateButton((Composite)this.mStateGroup, "Enabled", tooltip, 32, true, (SelectionListener)navListener);
        this.mPortraitKeys.setEnabled(false);
        this.mPortraitKeysNav = this.generateButton((Composite)this.mStateGroup, "Navigation", "Hardware navigation is available in this state", 32, true, (SelectionListener)validator);
        this.mPortraitKeysNav.setEnabled(false);
        tooltip = "The device has a landscape position with the keyboard open";
        this.mLandscapeKeysLabel = this.generateLabel("Landscape with keyboard:", tooltip, (Composite)this.mStateGroup);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mLandscapeKeysLabel.setLayoutData((Object)gridData);
        this.mLandscapeKeysLabel.setEnabled(false);
        this.mLandscapeKeys = this.generateButton((Composite)this.mStateGroup, "Enabled", tooltip, 32, true, (SelectionListener)navListener);
        this.mLandscapeKeys.setEnabled(false);
        this.mLandscapeKeysNav = this.generateButton((Composite)this.mStateGroup, "Navigation", "Hardware navigation is available in this state", 32, true, (SelectionListener)validator);
        this.mLandscapeKeysNav.setEnabled(false);
        this.mForceCreation = new Button(column2, 32);
        this.mForceCreation.setText("Override the existing device with the same name");
        this.mForceCreation.setToolTipText("There's already an AVD with the same name. Check this to delete it and replace it by the new AVD.");
        this.mForceCreation.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mForceCreation.setEnabled(false);
        this.mForceCreation.addSelectionListener((SelectionListener)validator);
        label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        Composite statusComposite = new Composite(parent, 0);
        statusComposite.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        GridLayout gl = new GridLayout(2, false);
        statusComposite.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mStatusIcon = new Label(statusComposite, 0);
        this.mStatusIcon.setLayoutData((Object)new GridData(1, 1, false, false));
        this.mStatusLabel = new Label(statusComposite, 0);
        this.mStatusLabel.setLayoutData((Object)new GridData(768));
        this.mStatusLabel.setText("");
        this.prefillWithDevice(this.mDevice);
        this.validatePage();
    }

    private Button generateButton(Composite parent, String text, String tooltip, int type, boolean selected, SelectionListener listener) {
        Button b = new Button(parent, type);
        b.setText(text);
        b.setToolTipText(tooltip);
        b.setSelection(selected);
        b.addSelectionListener(listener);
        b.setLayoutData((Object)new GridData(768));
        return b;
    }

    private Combo generateCombo(Composite parent, String tooltip, ResourceEnum[] values, int selection, ModifyListener validator) {
        Combo c = new Combo(parent, 12);
        c.setLayoutData((Object)new GridData(768));
        c.setToolTipText(tooltip);
        for (ResourceEnum r : values) {
            c.add(r.getResourceValue());
        }
        c.select(selection);
        c.addModifyListener(validator);
        return c;
    }

    private Text generateText(Composite parent, String tooltip, ModifyListener listener) {
        Text t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(768));
        t.setToolTipText(tooltip);
        t.addModifyListener(listener);
        return t;
    }

    private Label generateLabel(String text, String tooltip, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setToolTipText(tooltip);
        label.setLayoutData((Object)new GridData(4));
        return label;
    }

    private void toggleNav() {
        this.mPortraitNav.setEnabled(this.mPortrait.getSelection() && !this.mNoNav.getSelection());
        this.mLandscapeNav.setEnabled(this.mLandscape.getSelection() && !this.mNoNav.getSelection());
        this.mPortraitKeysNav.setEnabled(this.mPortraitKeys.getSelection() && this.mPortraitKeys.getEnabled() && !this.mNoNav.getSelection());
        this.mLandscapeKeysNav.setEnabled(this.mLandscapeKeys.getSelection() && this.mLandscapeKeys.getEnabled() && !this.mNoNav.getSelection());
        this.validatePage();
    }

    private boolean validatePage() {
        boolean valid = true;
        String error = null;
        String warning = null;
        this.setError(null);
        String name = this.mDeviceName.getText();
        if (this.mOkButton != null) {
            if (this.mDevice == null) {
                this.getShell().setText("Create New Device");
                this.mOkButton.setText("Create Device");
            } else if (this.mDevice.getName().equals(name)) {
                if (this.mUserDevices.contains(this.mDevice)) {
                    this.getShell().setText("Edit Device");
                    this.mOkButton.setText("Edit Device");
                } else {
                    warning = "Only user created devices are editable.\nA clone of it will be created under the \"User\" category.";
                    this.getShell().setText("Clone Device");
                    this.mOkButton.setText("Clone Device");
                }
            } else {
                warning = "The device \"" + this.mDevice.getName() + "\" will be duplicated into\n" + "\"" + name + "\" under the \"User\" category";
                this.getShell().setText("Clone Device");
                this.mOkButton.setText("Clone Device");
            }
        }
        if (valid && name.isEmpty()) {
            warning = "Please enter a name for the device.";
            valid = false;
        }
        if (valid && !this.validateFloat("Diagonal Length", this.mDiagonalLength.getText())) {
            warning = "Please enter a screen size.";
            valid = false;
        }
        if (valid && !this.validateInt("Resolution", this.mXDimension.getText())) {
            warning = "Please enter the screen resolution.";
            valid = false;
        }
        if (valid && !this.validateInt("Resolution", this.mYDimension.getText())) {
            warning = "Please enter the screen resolution.";
            valid = false;
        }
        if (valid && this.mSize.getSelectionIndex() < 0) {
            error = "A size bucket must be selected.";
            valid = false;
        }
        if (valid && this.mDensity.getSelectionIndex() < 0) {
            error = "A screen density bucket must be selected";
            valid = false;
        }
        if (valid && this.mRatio.getSelectionIndex() < 0) {
            error = "A screen ratio must be selected.";
            valid = false;
        }
        if (valid && !this.mNoNav.getSelection() && !this.mTrackball.getSelection() && !this.mDpad.getSelection()) {
            error = "A mode of hardware navigation, or no navigation, has to be selected.";
            valid = false;
        }
        if (valid && !this.validateInt("RAM", this.mRam.getText())) {
            warning = "Please enter a RAM amount.";
            valid = false;
        }
        if (valid && this.mRamCombo.getSelectionIndex() < 0) {
            error = "RAM must have a selected unit.";
            valid = false;
        }
        if (valid && this.mButtons.getSelectionIndex() < 0) {
            error = "A button type must be selected.";
            valid = false;
        }
        if (valid) {
            if (this.mKeyboard.getSelection()) {
                if (!(this.mPortraitKeys.getSelection() || this.mPortrait.getSelection() || this.mLandscapeKeys.getSelection() || this.mLandscape.getSelection())) {
                    error = "At least one device state must be enabled.";
                    valid = false;
                }
            } else if (!this.mPortrait.getSelection() && !this.mLandscape.getSelection()) {
                error = "At least one device state must be enabled";
                valid = false;
            }
        }
        if (this.mForceCreation.isEnabled() && !this.mForceCreation.getSelection()) {
            error = "Name conflicts with an existing device.";
            valid = false;
        }
        if (this.mOkButton != null) {
            this.mOkButton.setEnabled(valid);
        }
        if (error != null) {
            this.setError(error);
        } else if (warning != null) {
            this.setWarning(warning);
        }
        return valid;
    }

    private boolean validateFloat(String box, String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        boolean ret = true;
        try {
            double val = Double.parseDouble(value);
            if (val <= 0.0) {
                ret = false;
            }
        }
        catch (NumberFormatException e) {
            ret = false;
        }
        if (!ret) {
            this.setError(box + " must be a valid, positive number.");
        }
        return ret;
    }

    private boolean validateInt(String box, String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        boolean ret = true;
        try {
            int val = Integer.parseInt(value);
            if (val <= 0) {
                ret = false;
            }
        }
        catch (NumberFormatException e) {
            ret = false;
        }
        if (!ret) {
            this.setError(box + " must be a valid, positive integer.");
        }
        return ret;
    }

    private void setError(@Nullable String error) {
        if (error == null) {
            this.mStatusIcon.setImage(null);
            this.mStatusLabel.setText("");
        } else {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("reject_icon16.png"));
            this.mStatusLabel.setText(error);
        }
    }

    private void setWarning(@Nullable String warning) {
        if (warning == null) {
            this.mStatusIcon.setImage(null);
            this.mStatusLabel.setText("");
        } else {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("warning_icon16.png"));
            this.mStatusLabel.setText(warning);
        }
    }

    private void prefillWithDevice(@Nullable Device device) {
        if (device == null) {
            this.mHardware = new Hardware();
            Screen s = new Screen();
            s.setXdpi(316.0);
            s.setYdpi(316.0);
            s.setMultitouch(Multitouch.JAZZ_HANDS);
            s.setMechanism(TouchScreen.FINGER);
            s.setScreenType(ScreenType.CAPACITIVE);
            this.mHardware.setScreen(s);
            this.mHardware.addNetwork(Network.BLUETOOTH);
            this.mHardware.addNetwork(Network.WIFI);
            this.mHardware.addNetwork(Network.NFC);
            this.mHardware.addSensor(Sensor.BAROMETER);
            this.mHardware.addSensor(Sensor.COMPASS);
            this.mHardware.addSensor(Sensor.LIGHT_SENSOR);
            this.mHardware.setHasMic(true);
            this.mHardware.addInternalStorage(new Storage(4L, Storage.Unit.GiB));
            this.mHardware.setCpu("Generic CPU");
            this.mHardware.setGpu("Generic GPU");
            this.mHardware.addSupportedAbi(Abi.ARMEABI);
            this.mHardware.addSupportedAbi(Abi.ARMEABI_V7A);
            this.mHardware.addSupportedAbi(Abi.MIPS);
            this.mHardware.addSupportedAbi(Abi.X86);
            this.mHardware.setChargeType(PowerType.BATTERY);
            return;
        }
        this.mHardware = device.getDefaultHardware().deepCopy();
        this.mDeviceName.setText(device.getName());
        this.mForceCreation.setSelection(true);
        Screen s = this.mHardware.getScreen();
        this.mDiagonalLength.setText(Double.toString(s.getDiagonalLength()));
        this.mXDimension.setText(Integer.toString(s.getXDimension()));
        this.mYDimension.setText(Integer.toString(s.getYDimension()));
        String size = s.getSize().getResourceValue();
        for (int i = 0; i < this.mSize.getItemCount(); ++i) {
            if (!size.equals(this.mSize.getItem(i))) continue;
            this.mSize.select(i);
            break;
        }
        String ratio = s.getRatio().getResourceValue();
        for (int i = 0; i < this.mRatio.getItemCount(); ++i) {
            if (!ratio.equals(this.mRatio.getItem(i))) continue;
            this.mRatio.select(i);
            break;
        }
        String density = s.getPixelDensity().getResourceValue();
        for (int i = 0; i < this.mDensity.getItemCount(); ++i) {
            if (!density.equals(this.mDensity.getItem(i))) continue;
            this.mDensity.select(i);
            break;
        }
        this.mKeyboard.setSelection(!Keyboard.NOKEY.equals((Object)this.mHardware.getKeyboard()));
        this.mDpad.setSelection(Navigation.DPAD.equals((Object)this.mHardware.getNav()));
        this.mTrackball.setSelection(Navigation.TRACKBALL.equals((Object)this.mHardware.getNav()));
        this.mNoNav.setSelection(Navigation.NONAV.equals((Object)this.mHardware.getNav()));
        this.mAccelerometer.setSelection(this.mHardware.getSensors().contains((Object)Sensor.ACCELEROMETER));
        this.mGyro.setSelection(this.mHardware.getSensors().contains((Object)Sensor.GYROSCOPE));
        this.mGps.setSelection(this.mHardware.getSensors().contains((Object)Sensor.GPS));
        this.mProximitySensor.setSelection(this.mHardware.getSensors().contains((Object)Sensor.PROXIMITY_SENSOR));
        this.mCameraFront.setSelection(false);
        this.mCameraRear.setSelection(false);
        for (Camera c : this.mHardware.getCameras()) {
            if (CameraLocation.FRONT.equals((Object)c.getLocation())) {
                this.mCameraFront.setSelection(true);
                continue;
            }
            if (!CameraLocation.BACK.equals((Object)c.getLocation())) continue;
            this.mCameraRear.setSelection(true);
        }
        this.mRam.setText(Long.toString(this.mHardware.getRam().getSizeAsUnit(Storage.Unit.MiB)));
        this.mRamCombo.select(0);
        for (int i = 0; i < this.mButtons.getItemCount(); ++i) {
            if (!this.mButtons.getItem(i).equals(this.mHardware.getButtonType().getDescription())) continue;
            this.mButtons.select(i);
            break;
        }
        for (State state : device.getAllStates()) {
            Button nav = null;
            if (state.getOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                if (state.getKeyState().equals((Object)KeyboardState.EXPOSED)) {
                    this.mPortraitKeys.setSelection(true);
                    nav = this.mPortraitKeysNav;
                } else {
                    this.mPortrait.setSelection(true);
                    nav = this.mPortraitNav;
                }
            } else if (state.getKeyState().equals((Object)KeyboardState.EXPOSED)) {
                this.mLandscapeKeys.setSelection(true);
                nav = this.mLandscapeKeysNav;
            } else {
                this.mLandscape.setSelection(true);
                nav = this.mLandscapeNav;
            }
            nav.setSelection(state.getNavState().equals((Object)NavigationState.EXPOSED) && !this.mHardware.getNav().equals((Object)Navigation.NONAV));
        }
    }

    @Override
    protected void okPressed() {
        if (this.validatePage()) {
            State state;
            Camera c;
            Device.Builder builder = new Device.Builder();
            builder.setManufacturer(MANUFACTURER);
            builder.setName(this.mDeviceName.getText());
            if (this.mDevice != null) {
                builder.setTagId(this.mDevice.getTagId());
                for (Map.Entry<String, String> entry : this.mDevice.getBootProps().entrySet()) {
                    builder.addBootProp(entry.getKey(), entry.getValue());
                }
            }
            builder.addSoftware(mSoftware);
            Screen s = this.mHardware.getScreen();
            double diagonal = Double.parseDouble(this.mDiagonalLength.getText());
            int x = Integer.parseInt(this.mXDimension.getText());
            int y = Integer.parseInt(this.mYDimension.getText());
            s.setDiagonalLength(diagonal);
            s.setXDimension(x);
            s.setYDimension(y);
            double dpi = Math.sqrt(x * x + y * y) / diagonal;
            dpi = (double)Math.round(dpi * 100.0) / 100.0;
            s.setXdpi(dpi);
            s.setYdpi(dpi);
            s.setPixelDensity(Density.getEnum((String)this.mDensity.getText()));
            s.setSize(ScreenSize.getEnum((String)this.mSize.getText()));
            s.setRatio(ScreenRatio.getEnum((String)this.mRatio.getText()));
            if (this.mAccelerometer.getSelection()) {
                this.mHardware.addSensor(Sensor.ACCELEROMETER);
            }
            if (this.mGyro.getSelection()) {
                this.mHardware.addSensor(Sensor.GYROSCOPE);
            }
            if (this.mGps.getSelection()) {
                this.mHardware.addSensor(Sensor.GPS);
            }
            if (this.mProximitySensor.getSelection()) {
                this.mHardware.addSensor(Sensor.PROXIMITY_SENSOR);
            }
            if (this.mCameraFront.getSelection()) {
                c = new Camera();
                c.setAutofocus(true);
                c.setFlash(true);
                c.setLocation(CameraLocation.FRONT);
                this.mHardware.addCamera(c);
            }
            if (this.mCameraRear.getSelection()) {
                c = new Camera();
                c.setAutofocus(true);
                c.setFlash(true);
                c.setLocation(CameraLocation.BACK);
                this.mHardware.addCamera(c);
            }
            if (this.mKeyboard.getSelection()) {
                this.mHardware.setKeyboard(Keyboard.QWERTY);
            } else {
                this.mHardware.setKeyboard(Keyboard.NOKEY);
            }
            if (this.mDpad.getSelection()) {
                this.mHardware.setNav(Navigation.DPAD);
            } else if (this.mTrackball.getSelection()) {
                this.mHardware.setNav(Navigation.TRACKBALL);
            } else {
                this.mHardware.setNav(Navigation.NONAV);
            }
            long ram = Long.parseLong(this.mRam.getText());
            Storage.Unit unit = Storage.Unit.getEnum(this.mRamCombo.getText());
            this.mHardware.setRam(new Storage(ram, unit));
            if (this.mButtons.getText().equals(ButtonType.HARD.getDescription())) {
                this.mHardware.setButtonType(ButtonType.HARD);
            } else {
                this.mHardware.setButtonType(ButtonType.SOFT);
            }
            boolean defaultSelected = false;
            if (this.mPortrait.getSelection()) {
                state = new State();
                state.setName("Portrait");
                state.setDescription("The device in portrait orientation");
                state.setOrientation(ScreenOrientation.PORTRAIT);
                if (this.mHardware.getNav().equals((Object)Navigation.NONAV) || !this.mPortraitNav.getSelection()) {
                    state.setNavState(NavigationState.HIDDEN);
                } else {
                    state.setNavState(NavigationState.EXPOSED);
                }
                if (this.mHardware.getKeyboard().equals((Object)Keyboard.NOKEY)) {
                    state.setKeyState(KeyboardState.SOFT);
                } else {
                    state.setKeyState(KeyboardState.HIDDEN);
                }
                state.setHardware(this.mHardware);
                if (!defaultSelected) {
                    state.setDefaultState(true);
                    defaultSelected = true;
                }
                builder.addState(state);
            }
            if (this.mLandscape.getSelection()) {
                state = new State();
                state.setName("Landscape");
                state.setDescription("The device in landscape orientation");
                state.setOrientation(ScreenOrientation.LANDSCAPE);
                if (this.mHardware.getNav().equals((Object)Navigation.NONAV) || !this.mLandscapeNav.getSelection()) {
                    state.setNavState(NavigationState.HIDDEN);
                } else {
                    state.setNavState(NavigationState.EXPOSED);
                }
                if (this.mHardware.getKeyboard().equals((Object)Keyboard.NOKEY)) {
                    state.setKeyState(KeyboardState.SOFT);
                } else {
                    state.setKeyState(KeyboardState.HIDDEN);
                }
                state.setHardware(this.mHardware);
                if (!defaultSelected) {
                    state.setDefaultState(true);
                    defaultSelected = true;
                }
                builder.addState(state);
            }
            if (this.mKeyboard.getSelection()) {
                if (this.mPortraitKeys.getSelection()) {
                    state = new State();
                    state.setName("Portrait with keyboard");
                    state.setDescription("The device in portrait orientation with a keyboard open");
                    state.setOrientation(ScreenOrientation.LANDSCAPE);
                    if (this.mHardware.getNav().equals((Object)Navigation.NONAV) || !this.mPortraitKeysNav.getSelection()) {
                        state.setNavState(NavigationState.HIDDEN);
                    } else {
                        state.setNavState(NavigationState.EXPOSED);
                    }
                    state.setKeyState(KeyboardState.EXPOSED);
                    state.setHardware(this.mHardware);
                    if (!defaultSelected) {
                        state.setDefaultState(true);
                        defaultSelected = true;
                    }
                    builder.addState(state);
                }
                if (this.mLandscapeKeys.getSelection()) {
                    state = new State();
                    state.setName("Landscape with keyboard");
                    state.setDescription("The device in landscape orientation with a keyboard open");
                    state.setOrientation(ScreenOrientation.LANDSCAPE);
                    if (this.mHardware.getNav().equals((Object)Navigation.NONAV) || !this.mLandscapeKeysNav.getSelection()) {
                        state.setNavState(NavigationState.HIDDEN);
                    } else {
                        state.setNavState(NavigationState.EXPOSED);
                    }
                    state.setKeyState(KeyboardState.EXPOSED);
                    state.setHardware(this.mHardware);
                    if (!defaultSelected) {
                        state.setDefaultState(true);
                        defaultSelected = true;
                    }
                    builder.addState(state);
                }
            }
            Device d = builder.build();
            if (this.mForceCreation.isEnabled() && this.mForceCreation.getSelection()) {
                this.mManager.replaceUserDevice(d);
            } else {
                this.mManager.addUserDevice(d);
            }
            this.mManager.saveUserDevices();
            this.mCreatedDevice = d;
            super.okPressed();
        }
    }

    static {
        mSoftware.setLiveWallpaperSupport(true);
        mSoftware.setGlVersion("2.0");
    }

    private class ValidationListener
    extends SelectionAdapter
    implements ModifyListener {
        private ValidationListener() {
        }

        public void modifyText(ModifyEvent e) {
            DeviceCreationDialog.this.validatePage();
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            DeviceCreationDialog.this.validatePage();
        }
    }

    private class NavStateListener
    extends SelectionAdapter {
        private NavStateListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            super.widgetSelected(event);
            DeviceCreationDialog.this.toggleNav();
            DeviceCreationDialog.this.validatePage();
        }
    }

    private class KeyboardListener
    extends SelectionAdapter {
        private KeyboardListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            super.widgetSelected(event);
            if (DeviceCreationDialog.this.mKeyboard.getSelection()) {
                DeviceCreationDialog.this.mPortraitKeys.setEnabled(true);
                DeviceCreationDialog.this.mPortraitKeysLabel.setEnabled(true);
                DeviceCreationDialog.this.mLandscapeKeys.setEnabled(true);
                DeviceCreationDialog.this.mLandscapeKeysLabel.setEnabled(true);
            } else {
                DeviceCreationDialog.this.mPortraitKeys.setEnabled(false);
                DeviceCreationDialog.this.mPortraitKeysLabel.setEnabled(false);
                DeviceCreationDialog.this.mLandscapeKeys.setEnabled(false);
                DeviceCreationDialog.this.mLandscapeKeysLabel.setEnabled(false);
            }
            DeviceCreationDialog.this.toggleNav();
            DeviceCreationDialog.this.validatePage();
        }
    }

    private class SizeListener
    implements ModifyListener {
        private SizeListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!DeviceCreationDialog.this.mDiagonalLength.getText().isEmpty()) {
                try {
                    double diagonal = Double.parseDouble(DeviceCreationDialog.this.mDiagonalLength.getText());
                    double diagonalDp = 160.0 * diagonal;
                    if (diagonalDp >= 1200.0) {
                        DeviceCreationDialog.this.mSize.select(ScreenSize.getIndex((ScreenSize)ScreenSize.getEnum((String)"xlarge")));
                    } else if (diagonalDp >= 800.0) {
                        DeviceCreationDialog.this.mSize.select(ScreenSize.getIndex((ScreenSize)ScreenSize.getEnum((String)"large")));
                    } else if (diagonalDp >= 568.0) {
                        DeviceCreationDialog.this.mSize.select(ScreenSize.getIndex((ScreenSize)ScreenSize.getEnum((String)"normal")));
                    } else {
                        DeviceCreationDialog.this.mSize.select(ScreenSize.getIndex((ScreenSize)ScreenSize.getEnum((String)"small")));
                    }
                    if (!DeviceCreationDialog.this.mXDimension.getText().isEmpty() && !DeviceCreationDialog.this.mYDimension.getText().isEmpty()) {
                        double x = Double.parseDouble(DeviceCreationDialog.this.mXDimension.getText());
                        double y = Double.parseDouble(DeviceCreationDialog.this.mYDimension.getText());
                        double dpi = Math.sqrt(x * x + y * y) / diagonal;
                        double difference = Double.MAX_VALUE;
                        Density bucket = Density.MEDIUM;
                        for (Density d : Density.values()) {
                            if (!(Math.abs((double)d.getDpiValue() - dpi) < difference)) continue;
                            difference = Math.abs((double)d.getDpiValue() - dpi);
                            bucket = d;
                        }
                        DeviceCreationDialog.this.mDensity.select(Density.getIndex((Density)bucket));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private class CreateNameModifyListener
    implements ModifyListener {
        private CreateNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String name = DeviceCreationDialog.this.mDeviceName.getText();
            boolean nameCollision = false;
            for (Device d : DeviceCreationDialog.this.mUserDevices) {
                if (!DeviceCreationDialog.MANUFACTURER.equals(d.getManufacturer()) || !name.equals(d.getName())) continue;
                nameCollision = true;
                break;
            }
            DeviceCreationDialog.this.mForceCreation.setEnabled(nameCollision);
            DeviceCreationDialog.this.mForceCreation.setSelection(!nameCollision);
            DeviceCreationDialog.this.validatePage();
        }
    }
}

