/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.SyncCommon;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.xy.XYDataset;

public class DisplaySyncPerf
extends SyncCommon {
    CustomXYToolTipGenerator mTooltipGenerator;
    List<String>[] mTooltips;
    private static final int DB_QUERY = 4;
    private static final int DB_WRITE = 5;
    private static final int HTTP_NETWORK = 6;
    private static final int HTTP_PROCESSING = 7;
    private static final int NUM_SERIES = 8;
    private static final String[] SERIES_NAMES = new String[]{"Calendar", "Gmail", "Feeds", "Contacts", "DB Query", "DB Write", "HTTP Response", "HTTP Processing"};
    private static final Color[] SERIES_COLORS = new Color[]{Color.MAGENTA, Color.GREEN, Color.BLUE, Color.ORANGE, Color.RED, Color.CYAN, Color.PINK, Color.DARK_GRAY};
    private static final double[] SERIES_YCOORD = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 2.0};
    private static final int EVENT_DB_OPERATION = 52000;
    private static final int EVENT_HTTP_STATS = 52001;
    final int EVENT_DB_QUERY = 0;
    final int EVENT_DB_WRITE = 1;
    private TimePeriodValues[] mDatasets;

    public DisplaySyncPerf(String name) {
        super(name);
    }

    @Override
    public Control createComposite(Composite parent, EventLogParser logParser, EventDisplay.ILogColumnListener listener) {
        Control composite = this.createCompositeChart(parent, logParser, "Sync Performance");
        this.resetUI();
        return composite;
    }

    @Override
    void resetUI() {
        super.resetUI();
        XYPlot xyPlot = this.mChart.getXYPlot();
        xyPlot.getRangeAxis().setVisible(false);
        this.mTooltipGenerator = new CustomXYToolTipGenerator();
        List[] mTooltipsTmp = new List[8];
        this.mTooltips = mTooltipsTmp;
        XYBarRenderer br = new XYBarRenderer();
        br.setUseYInterval(true);
        this.mDatasets = new TimePeriodValues[8];
        YIntervalTimePeriodValuesCollection tpvc = new YIntervalTimePeriodValuesCollection(1.0);
        xyPlot.setDataset((XYDataset)tpvc);
        xyPlot.setRenderer((XYItemRenderer)br);
        for (int i = 0; i < 8; ++i) {
            br.setSeriesPaint(i, (Paint)SERIES_COLORS[i]);
            this.mDatasets[i] = new TimePeriodValues(SERIES_NAMES[i]);
            tpvc.addSeries(this.mDatasets[i]);
            this.mTooltips[i] = new ArrayList<String>();
            this.mTooltipGenerator.addToolTipSeries(this.mTooltips[i]);
            br.setSeriesToolTipGenerator(i, (XYToolTipGenerator)this.mTooltipGenerator);
        }
    }

    @Override
    void newEvent(EventContainer event, EventLogParser logParser) {
        super.newEvent(event, logParser);
        try {
            if (event.mTag == 52000) {
                String tip = event.getValueAsString(0);
                long endTime = (long)event.sec * 1000L + (long)event.nsec / 1000000L;
                int opType = Integer.parseInt(event.getValueAsString(1));
                long duration = Long.parseLong(event.getValueAsString(2));
                if (opType == 0) {
                    this.mDatasets[4].add((TimePeriod)new SimpleTimePeriod(endTime - duration, endTime), SERIES_YCOORD[4]);
                    this.mTooltips[4].add(tip);
                } else if (opType == 1) {
                    this.mDatasets[5].add((TimePeriod)new SimpleTimePeriod(endTime - duration, endTime), SERIES_YCOORD[5]);
                    this.mTooltips[5].add(tip);
                }
            } else if (event.mTag == 52001) {
                String tip = event.getValueAsString(0) + ", tx:" + event.getValueAsString(3) + ", rx: " + event.getValueAsString(4);
                long endTime = (long)event.sec * 1000L + (long)event.nsec / 1000000L;
                long netEndTime = endTime - Long.parseLong(event.getValueAsString(2));
                long netStartTime = netEndTime - Long.parseLong(event.getValueAsString(1));
                this.mDatasets[6].add((TimePeriod)new SimpleTimePeriod(netStartTime, netEndTime), SERIES_YCOORD[6]);
                this.mDatasets[7].add((TimePeriod)new SimpleTimePeriod(netEndTime, endTime), SERIES_YCOORD[7]);
                this.mTooltips[6].add(tip);
                this.mTooltips[7].add(tip);
            }
        }
        catch (NumberFormatException e) {
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Override
    void processSyncEvent(EventContainer event, int auth, long startTime, long stopTime, String details, boolean newEvent, int syncSource) {
        if (newEvent) {
            this.mDatasets[auth].add((TimePeriod)new SimpleTimePeriod(startTime, stopTime), SERIES_YCOORD[auth]);
        }
    }

    @Override
    int getDisplayType() {
        return 5;
    }

    class YIntervalTimePeriodValuesCollection
    extends TimePeriodValuesCollection {
        private static final long serialVersionUID = 1L;
        private double yheight;

        YIntervalTimePeriodValuesCollection(double yheight) {
            this.yheight = yheight;
        }

        public Number getEndY(int series, int item) {
            return this.getY(series, item).doubleValue() + this.yheight;
        }
    }
}

