/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.auth.shiro;

import cn.hellohao.auth.filter.SubjectFilter;
import cn.hellohao.auth.shiro.UserRealm;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(@Qualifier(value="defaultWebSecurityManager") DefaultWebSecurityManager defaultWebSecurityManager) {
        ShiroFilterFactoryBean bean = new ShiroFilterFactoryBean();
        bean.setSecurityManager((SecurityManager)defaultWebSecurityManager);
        Map filters = bean.getFilters();
        filters.put("JWT", new SubjectFilter());
        bean.setFilters(filters);
        LinkedHashMap<String, String> filterMap = new LinkedHashMap<String, String>();
        filterMap.put("/verifyCode", "anon");
        filterMap.put("/verifyCodeForRegister", "anon");
        filterMap.put("/verifyCodeForRetrieve", "anon");
        filterMap.put("/api/**", "anon");
        filterMap.put("/user/**", "anon");
        filterMap.put("/ota/**", "anon");
        filterMap.put("/admin/root/**", "roles[admin]");
        filterMap.put("/**", "JWT");
        bean.setLoginUrl("/jurisError");
        bean.setUnauthorizedUrl("/authError");
        bean.setFilterChainDefinitionMap(filterMap);
        return bean;
    }

    @Bean
    public DefaultWebSecurityManager defaultWebSecurityManager(@Qualifier(value="userRealm") UserRealm userRealm) {
        DefaultWebSecurityManager defaultWebSecurityManager = new DefaultWebSecurityManager();
        defaultWebSecurityManager.setRealm((Realm)userRealm);
        defaultWebSecurityManager.setRememberMeManager(null);
        return defaultWebSecurityManager;
    }

    @Bean(name={"userRealm"})
    public UserRealm userRealm() {
        return new UserRealm();
    }
}

