/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.auth.shiro;

import cn.hellohao.pojo.User;
import cn.hellohao.service.UserService;
import java.util.ArrayList;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;

public class UserRealm
extends AuthorizingRealm {
    @Autowired
    private UserService userService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Subject subject = SecurityUtils.getSubject();
        User user = (User)subject.getPrincipal();
        ArrayList<String> roleList = new ArrayList<String>();
        if (user.getLevel() == 2) {
            roleList.add("admin");
            roleList.add("user");
        } else {
            roleList.add("user");
        }
        info.addRoles(roleList);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken tokenOBJ) throws AuthenticationException {
        UsernamePasswordToken userToken = null;
        userToken = (UsernamePasswordToken)tokenOBJ;
        User user = new User();
        user.setEmail(userToken.getUsername());
        User u = this.userService.getUsers(user);
        if (u == null) {
            return null;
        }
        return new SimpleAuthenticationInfo((Object)u, (Object)u.getPassword(), "");
    }
}

