/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.controller;

import cn.hellohao.pojo.Config;
import cn.hellohao.pojo.EmailConfig;
import cn.hellohao.pojo.Imgreview;
import cn.hellohao.pojo.Keys;
import cn.hellohao.pojo.Msg;
import cn.hellohao.pojo.SysConfig;
import cn.hellohao.pojo.UploadConfig;
import cn.hellohao.pojo.User;
import cn.hellohao.service.ConfigService;
import cn.hellohao.service.EmailConfigService;
import cn.hellohao.service.ImgService;
import cn.hellohao.service.ImgreviewService;
import cn.hellohao.service.KeysService;
import cn.hellohao.service.SysConfigService;
import cn.hellohao.service.UploadConfigService;
import cn.hellohao.service.UserService;
import cn.hellohao.service.impl.COSImageupload;
import cn.hellohao.service.impl.FTPImageupload;
import cn.hellohao.service.impl.KODOImageupload;
import cn.hellohao.service.impl.NOSImageupload;
import cn.hellohao.service.impl.OSSImageupload;
import cn.hellohao.service.impl.UFileImageupload;
import cn.hellohao.service.impl.USSImageupload;
import cn.hellohao.utils.NewSendEmail;
import cn.hellohao.utils.SetFiles;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/root"})
public class AdminRootController {
    @Autowired
    private ConfigService configService;
    @Autowired
    private KeysService keysService;
    @Autowired
    private UserService userService;
    @Autowired
    private EmailConfigService emailConfigService;
    @Autowired
    private UploadConfigService uploadConfigService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ImgService imgService;
    @Autowired
    private ImgreviewService imgreviewService;

    @PostMapping(value={"/getUserList"})
    @ResponseBody
    public Map<String, Object> getUserList(@RequestParam(value="data", defaultValue="") String data) {
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        Integer pageNum = jsonObj.getInteger("pageNum");
        Integer pageSize = jsonObj.getInteger("pageSize");
        String queryText = jsonObj.getString("queryText");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List users = this.userService.getuserlist(queryText);
        PageInfo rolePageInfo = new PageInfo(users);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", rolePageInfo.getTotal());
        map.put("users", rolePageInfo.getList());
        return map;
    }

    @PostMapping(value={"/updateUserInfo"})
    @ResponseBody
    public Msg updateUserInfo(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        try {
            Subject subject = SecurityUtils.getSubject();
            User u = (User)subject.getPrincipal();
            JSONObject jsonObj = JSONObject.parseObject((String)data);
            Integer id = jsonObj.getInteger("id");
            String email = jsonObj.getString("email");
            Long memory = jsonObj.getLong("memory");
            Integer groupid = jsonObj.getInteger("groupid");
            Integer isok = jsonObj.getInteger("isok");
            if (memory < 0L || memory > 0x100000L) {
                msg.setCode("500");
                msg.setInfo("\u5bb9\u91cf\u4e0d\u5f97\u8d85\u8fc71048576");
                return msg;
            }
            User user = new User();
            User user2 = new User();
            user2.setId(id);
            User userInfo = this.userService.getUsers(user2);
            user.setId(id);
            user.setEmail(email);
            user.setMemory(Long.toString(memory * 1024L * 1024L));
            user.setGroupid(groupid);
            if (userInfo.getLevel() == 1) {
                user.setIsok(Integer.valueOf(isok == 1 ? 1 : -1));
            }
            this.userService.changeUser(user);
            msg.setInfo("\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            msg.setCode("500");
            msg.setInfo("\u4fee\u6539\u5931\u8d25");
            e.printStackTrace();
        }
        return msg;
    }

    @PostMapping(value={"/disableUser"})
    @ResponseBody
    public Msg disableUser(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        try {
            JSONObject jsonObj = JSONObject.parseObject((String)data);
            JSONArray userIdList = jsonObj.getJSONArray("arr");
            for (int i = 0; i < userIdList.size(); ++i) {
                User u = new User();
                u.setId(userIdList.getInteger(i));
                User u2 = this.userService.getUsers(u);
                if (u2.getLevel() != 1) continue;
                User user = new User();
                user.setId(userIdList.getInteger(i));
                user.setIsok(Integer.valueOf(-1));
                this.userService.changeUser(user);
            }
            msg.setInfo("\u6240\u9009\u7528\u6237\u5df2\u88ab\u7981\u7528");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setInfo("\u7cfb\u7edf\u9519\u8bef");
            msg.setCode("500");
        }
        return msg;
    }

    @PostMapping(value={"/deleUser"})
    @ResponseBody
    public Msg deleuser(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        try {
            JSONObject jsonObj = JSONObject.parseObject((String)data);
            JSONArray userIdList = jsonObj.getJSONArray("arr");
            boolean b = false;
            for (int i = 0; i < userIdList.size(); ++i) {
                User u = new User();
                u.setId(userIdList.getInteger(i));
                User user = this.userService.getUsers(u);
                if (user.getLevel() == 1) {
                    this.userService.deleuser(userIdList.getInteger(i));
                    continue;
                }
                b = true;
            }
            if (b && userIdList.size() == 1) {
                msg.setInfo("\u7ba1\u7406\u5458\u8d26\u6237\u4e0d\u53ef\u5220\u9664");
            } else {
                msg.setInfo("\u7528\u6237\u5df2\u5220\u9664\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setInfo("\u7cfb\u7edf\u9519\u8bef");
            msg.setCode("500");
        }
        return msg;
    }

    @PostMapping(value={"/getKeysList"})
    @ResponseBody
    public Msg getKeysList() {
        Msg msg = new Msg();
        List list = this.keysService.getKeys();
        msg.setData((Object)list);
        return msg;
    }

    @PostMapping(value={"/LoadInfo"})
    @ResponseBody
    public Msg LoadInfo(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        try {
            JSONObject jsonData = JSONObject.parseObject((String)data);
            Integer keyId = jsonData.getInteger("keyId");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)keyId);
            Keys key = this.keysService.selectKeys(keyId);
            Integer ret = 0;
            if (key.getStorageType() == 1) {
                ret = NOSImageupload.Initialize((Keys)key);
            } else if (key.getStorageType() == 2) {
                ret = OSSImageupload.Initialize((Keys)key);
            } else if (key.getStorageType() == 3) {
                ret = USSImageupload.Initialize((Keys)key);
            } else if (key.getStorageType() == 4) {
                ret = KODOImageupload.Initialize((Keys)key);
            } else if (key.getStorageType() == 6) {
                ret = COSImageupload.Initialize((Keys)key);
            } else if (key.getStorageType() == 7) {
                ret = FTPImageupload.Initialize((Keys)key);
            } else if (key.getStorageType() == 8) {
                ret = UFileImageupload.Initialize((Keys)key);
            }
            Long l = this.imgService.getsourcememory(keyId);
            jsonObject.put("isok", (Object)ret);
            jsonObject.put("storagetype", (Object)key.getStorageType());
            if (l == null) {
                jsonObject.put("usedCapacity", (Object)0);
            } else {
                jsonObject.put("usedCapacity", (Object)SetFiles.readableFileSize((long)l));
            }
            msg.setData((Object)jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setCode("500");
        }
        return msg;
    }

    @PostMapping(value={"/updateStorage"})
    @ResponseBody
    public Msg updateStorage(@RequestParam(value="data", defaultValue="") String data) {
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        Integer id = jsonObj.getInteger("id");
        String AccessKey = jsonObj.getString("AccessKey");
        String AccessSecret = jsonObj.getString("AccessSecret");
        String Endpoint = jsonObj.getString("Endpoint");
        String Bucketname = jsonObj.getString("Bucketname");
        String RequestAddress = jsonObj.getString("RequestAddress");
        Integer storageType = jsonObj.getInteger("storageType");
        String keyname = jsonObj.getString("keyname");
        Keys keys = new Keys();
        keys.setId(id);
        keys.setAccessKey(AccessKey);
        keys.setAccessSecret(AccessSecret);
        keys.setEndpoint(Endpoint);
        keys.setBucketname(Bucketname);
        keys.setRequestAddress(RequestAddress);
        keys.setStorageType(storageType);
        keys.setKeyname(keyname);
        Msg msg = this.keysService.updateKey(keys);
        return msg;
    }

    @PostMapping(value={"/getStorageById"})
    @ResponseBody
    public Msg getselectkey(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        Integer keyid = jsonObj.getInteger("id");
        Keys keys = this.keysService.selectKeys(keyid);
        msg.setData((Object)keys);
        return msg;
    }

    @PostMapping(value={"/getSettingConfig"})
    @ResponseBody
    public Msg getSettingConfig(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject jsonObject = new JSONObject();
        Subject subject = SecurityUtils.getSubject();
        User u = (User)subject.getPrincipal();
        try {
            UploadConfig uploadConfig = this.uploadConfigService.getUpdateConfig();
            Config config = this.configService.getSourceype();
            SysConfig sysConfig = this.sysConfigService.getstate();
            uploadConfig.setUsermemory(Long.toString(Long.valueOf(uploadConfig.getUsermemory()) / 1024L / 1024L));
            uploadConfig.setVisitormemory(Long.toString(Long.valueOf(uploadConfig.getVisitormemory()) / 1024L / 1024L));
            uploadConfig.setFilesizetourists(Long.toString(Long.valueOf(uploadConfig.getFilesizetourists()) / 1024L / 1024L));
            uploadConfig.setFilesizeuser(Long.toString(Long.valueOf(uploadConfig.getFilesizeuser()) / 1024L / 1024L));
            jsonObject.put("uploadConfig", (Object)uploadConfig);
            jsonObject.put("config", (Object)config);
            jsonObject.put("sysConfig", (Object)sysConfig);
            msg.setData((Object)jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setCode("110500");
            msg.setInfo("\u64cd\u4f5c\u5931\u8d25");
        }
        return msg;
    }

    @PostMapping(value={"/updateConfig"})
    @ResponseBody
    public Msg updateConfig(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            UploadConfig uploadConfig = (UploadConfig)JSON.toJavaObject((JSON)((JSON)jsonObject.get((Object)"uploadConfig")), UploadConfig.class);
            String vm = uploadConfig.getVisitormemory();
            if (Long.valueOf(vm) < -1L || Long.valueOf(vm) > 0x6400000L || Long.valueOf(uploadConfig.getFilesizetourists()) < 0L || Long.valueOf(uploadConfig.getFilesizetourists()) > 5120L || Long.valueOf(uploadConfig.getUsermemory()) < 0L || Long.valueOf(uploadConfig.getUsermemory()) > 0x100000L || Long.valueOf(uploadConfig.getFilesizeuser()) < 0L || Long.valueOf(uploadConfig.getFilesizeuser()) > 5120L) {
                msg.setInfo("\u4f60\u8f93\u5165\u7684\u503c\u4e0d\u6b63\u786e");
                msg.setCode("500");
                return msg;
            }
            Config config = (Config)JSON.toJavaObject((JSON)((JSON)jsonObject.get((Object)"config")), Config.class);
            SysConfig sysConfig = (SysConfig)JSON.toJavaObject((JSON)((JSON)jsonObject.get((Object)"sysConfig")), SysConfig.class);
            if (Integer.valueOf(vm) == -1) {
                uploadConfig.setVisitormemory("-1");
            } else {
                uploadConfig.setVisitormemory(Long.toString(Long.valueOf(uploadConfig.getVisitormemory()) * 1024L * 1024L));
            }
            uploadConfig.setFilesizetourists(Long.toString(Long.valueOf(uploadConfig.getFilesizetourists()) * 1024L * 1024L));
            uploadConfig.setUsermemory(Long.toString(Long.valueOf(uploadConfig.getUsermemory()) * 1024L * 1024L));
            uploadConfig.setFilesizeuser(Long.toString(Long.valueOf(uploadConfig.getFilesizeuser()) * 1024L * 1024L));
            this.uploadConfigService.setUpdateConfig(uploadConfig);
            this.configService.setSourceype(config);
            this.sysConfigService.setstate(sysConfig);
            msg.setInfo("\u914d\u7f6e\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setInfo("\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38");
            msg.setCode("500");
        }
        return msg;
    }

    @PostMapping(value={"/getOrderConfig"})
    @ResponseBody
    public Msg emailconfig() {
        Msg msg = new Msg();
        EmailConfig emailConfig = null;
        Imgreview imgreview = null;
        try {
            JSONObject jsonObject = new JSONObject();
            emailConfig = this.emailConfigService.getemail();
            imgreview = this.imgreviewService.selectByPrimaryKey(Integer.valueOf(1));
            jsonObject.put("emailConfig", (Object)emailConfig);
            jsonObject.put("imgreview", (Object)imgreview);
            msg.setData((Object)jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setCode("110500");
            msg.setInfo("\u83b7\u53d6\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return msg;
    }

    @PostMapping(value={"/updateEmailConfig"})
    @ResponseBody
    public Msg updateemail(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        try {
            JSONObject jsonObj = JSONObject.parseObject((String)data);
            EmailConfig emailConfig = (EmailConfig)JSON.toJavaObject((JSON)jsonObj, EmailConfig.class);
            if (null == emailConfig.getId() || null == emailConfig.getEmailname() || null == emailConfig.getEmailurl() || null == emailConfig.getEmails() || null == emailConfig.getEmailkey() || null == emailConfig.getPort() || null == emailConfig.getUsing() || emailConfig.getEmailname().equals("") || emailConfig.getEmailurl().equals("") || emailConfig.getEmails().equals("") || emailConfig.getEmailkey().equals("") || emailConfig.getPort().equals("")) {
                msg.setCode("110400");
                msg.setInfo("\u5404\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                return msg;
            }
            this.emailConfigService.updateemail(emailConfig);
            msg.setInfo("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setCode("110500");
            msg.setInfo("\u4fdd\u5b58\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef");
        }
        return msg;
    }

    @PostMapping(value={"/mailTest"})
    @ResponseBody
    public Msg mailTest(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        String tomail = jsonObj.getString("tomail");
        EmailConfig emailConfig = (EmailConfig)JSON.toJavaObject((JSON)jsonObj, EmailConfig.class);
        if (null == emailConfig.getEmails() || null == emailConfig.getEmailkey() || null == emailConfig.getEmailurl() || null == emailConfig.getPort() || null == emailConfig.getEmailname() || null == tomail) {
            msg.setCode("110400");
            msg.setInfo("\u90ae\u7bb1\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            msg = NewSendEmail.sendTestEmail((EmailConfig)emailConfig, (String)tomail);
        }
        return msg;
    }
}

