/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.controller;

import cn.hellohao.pojo.Album;
import cn.hellohao.pojo.ImgAndAlbum;
import cn.hellohao.pojo.Msg;
import cn.hellohao.pojo.User;
import cn.hellohao.pojo.vo.PageResultBean;
import cn.hellohao.service.ImgAndAlbumService;
import cn.hellohao.service.UserService;
import cn.hellohao.service.impl.AlbumServiceImpl;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AlbumController {
    @Autowired
    AlbumServiceImpl albumServiceImpl;
    @Autowired
    ImgAndAlbumService imgAndAlbumService;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/admin/getGalleryList"})
    @ResponseBody
    public Map<String, Object> getGalleryList(@RequestParam(value="data", defaultValue="") String data) {
        Subject subject = SecurityUtils.getSubject();
        User user = (User)subject.getPrincipal();
        user = this.userService.getUsers(user);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Album album = new Album();
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        Integer pageNum = jsonObj.getInteger("pageNum");
        Integer pageSize = jsonObj.getInteger("pageSize");
        Integer albumtitle = jsonObj.getInteger("albumtitle");
        if (!subject.hasRole("admin")) {
            album.setUserid(user.getId());
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List albums = null;
        try {
            albums = this.albumServiceImpl.selectAlbumURLList(album);
            PageInfo rolePageInfo = new PageInfo(albums);
            map.put("code", 200);
            map.put("info", "");
            map.put("count", rolePageInfo.getTotal());
            map.put("data", rolePageInfo.getList());
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("code", 500);
            map.put("info", "\u83b7\u53d6\u6570\u636e\u5f02\u5e38");
        }
        return map;
    }

    @PostMapping(value={"/admin/deleGallery"})
    @ResponseBody
    public Msg deleGallery(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        Subject subject = SecurityUtils.getSubject();
        User user = (User)subject.getPrincipal();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            JSONArray albumkeyList = jsonObject.getJSONArray("albumkeyList");
            for (int i = 0; i < albumkeyList.size(); ++i) {
                if (subject.hasRole("admin")) {
                    this.albumServiceImpl.deleteAlbum(albumkeyList.getString(i));
                    continue;
                }
                Album album = new Album();
                album.setAlbumkey(albumkeyList.getString(i));
                Album alb = this.albumServiceImpl.selectAlbum(album);
                if (alb.getUserid() != user.getId()) continue;
                this.albumServiceImpl.deleteAlbum(albumkeyList.getString(i));
            }
            msg.setInfo("\u753b\u5eca\u5df2\u6210\u529f\u5220\u9664");
        }
        catch (Exception e) {
            msg.setCode("500");
            msg.setInfo("\u753b\u5eca\u5220\u9664\u5931\u8d25");
            e.printStackTrace();
        }
        return msg;
    }

    @PostMapping(value={"/getAlbumImgList"})
    @ResponseBody
    public Msg getAlbumImgList(@RequestParam(value="data") String data) {
        Msg msg = new Msg();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        JSONArray jsonArray = jsonObject.getJSONArray("imguidlist");
        JSONArray json = this.albumServiceImpl.getAlbumList(jsonArray);
        msg.setData((Object)json);
        return msg;
    }

    @PostMapping(value={"/SaveForAlbum"})
    @ResponseBody
    public Msg SaveForAlbum(@RequestParam(value="data", defaultValue="") String data) {
        data = StringEscapeUtils.unescapeHtml4((String)data);
        Msg msg = new Msg();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            String albumtitle = jsonObject.getString("albumtitle");
            String password = jsonObject.getString("password");
            JSONArray jsonArray = JSONArray.parseArray((String)jsonObject.getString("albumlist"));
            if (null != password && ((password = password.replace(" ", "")).replace(" ", "").equals("") || password.length() < 3)) {
                msg.setCode("110403");
                msg.setInfo("\u5bc6\u7801\u957f\u5ea6\u4e0d\u5f97\u5c0f\u4e8e\u4e09\u4f4d\u6709\u6548\u5b57\u7b26");
                return msg;
            }
            if (albumtitle == null || jsonArray.size() == 0) {
                msg.setCode("110404");
                msg.setInfo("\u6807\u9898\u548c\u56fe\u7247\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                return msg;
            }
            Subject subject = SecurityUtils.getSubject();
            User u = (User)subject.getPrincipal();
            String uuid = "TOALBUM" + UUID.randomUUID().toString().replace("-", "").toLowerCase().substring(0, 5) + "N";
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Album album = new Album();
            album.setAlbumtitle(albumtitle);
            album.setCreatedate(df.format(new Date()));
            album.setPassword(password);
            album.setAlbumkey(uuid);
            if (u == null) {
                album.setUserid(Integer.valueOf(0));
            } else {
                album.setUserid(u.getId());
            }
            this.albumServiceImpl.addAlbum(album);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject img = jsonArray.getJSONObject(i);
                ImgAndAlbum imgAndAlbum = new ImgAndAlbum();
                imgAndAlbum.setImgname(img.getString("imgurl"));
                imgAndAlbum.setAlbumkey(uuid);
                imgAndAlbum.setNotes(img.getString("notes"));
                this.albumServiceImpl.addAlbumForImgAndAlbumMapper(imgAndAlbum);
            }
            JSONObject json = new JSONObject();
            json.put("url", (Object)uuid);
            json.put("title", (Object)albumtitle);
            json.put("password", (Object)password);
            msg.setCode("200");
            msg.setInfo("\u6210\u529f\u521b\u5efa\u753b\u5eca\u94fe\u63a5");
            msg.setData((Object)json);
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setCode("500");
            msg.setInfo("\u521b\u5efa\u753b\u5eca\u94fe\u63a5\u5931\u8d25");
        }
        return msg;
    }

    @PostMapping(value={"/checkPass"})
    @ResponseBody
    public Msg checkPass(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject json = new JSONObject();
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)data);
            String key = jsonObject.getString("key");
            Album album = new Album();
            album.setAlbumkey(key);
            Album a = this.albumServiceImpl.selectAlbum(album);
            if (a != null) {
                json.put("album", (Object)a);
                json.put("exist", (Object)true);
                if (a.getPassword() != null && !a.getPassword().equals("")) {
                    json.put("passType", (Object)true);
                } else {
                    json.put("passType", (Object)false);
                }
                msg.setData((Object)json);
            } else {
                json.put("exist", (Object)false);
                msg.setData((Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setCode("110500");
            msg.setInfo("\u64cd\u4f5c\u5931\u8d25");
            msg.setData((Object)json);
        }
        return msg;
    }

    @PostMapping(value={"/getAlbumList"})
    @ResponseBody
    public Msg getAlbumList(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject json = new JSONObject();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        Integer pageNum = jsonObject.getInteger("pageNum");
        Integer pageSize = jsonObject.getInteger("pageSize");
        String albumkey = jsonObject.getString("albumkey");
        String password = jsonObject.getString("password");
        if (null != password) {
            password = password.replace(" ", "");
        }
        Album album = new Album();
        album.setAlbumkey(albumkey);
        Album a = this.albumServiceImpl.selectAlbum(album);
        if (a == null) {
            msg.setCode("110404");
            msg.setInfo("\u753b\u5eca\u5730\u5740\u4e0d\u5b58\u5728");
        } else {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            if (a.getPassword() == null || a.getPassword().replace(" ", "").equals("")) {
                List imagesList = this.imgAndAlbumService.selectImgForAlbumkey(albumkey);
                PageInfo rolePageInfo = new PageInfo(imagesList);
                PageResultBean pageResultBean = new PageResultBean(rolePageInfo.getTotal(), rolePageInfo.getList());
                json.put("imagesList", (Object)pageResultBean);
            } else if (a.getPassword().equals(password)) {
                List imagesList = this.imgAndAlbumService.selectImgForAlbumkey(albumkey);
                PageInfo rolePageInfo = new PageInfo(imagesList);
                PageResultBean pageResultBean = new PageResultBean(rolePageInfo.getTotal(), rolePageInfo.getList());
                json.put("imagesList", (Object)pageResultBean);
            } else {
                msg.setCode("110403");
                msg.setInfo("\u753b\u5eca\u5bc6\u7801\u9519\u8bef");
            }
            json.put("titlename", (Object)a.getAlbumtitle());
            msg.setData((Object)json);
        }
        return msg;
    }
}

