/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.controller;

import cn.hellohao.auth.token.JWTUtil;
import cn.hellohao.pojo.Config;
import cn.hellohao.pojo.Images;
import cn.hellohao.pojo.Keys;
import cn.hellohao.pojo.Msg;
import cn.hellohao.pojo.SysConfig;
import cn.hellohao.pojo.UploadConfig;
import cn.hellohao.pojo.User;
import cn.hellohao.service.ConfigService;
import cn.hellohao.service.IRedisService;
import cn.hellohao.service.ImgAndAlbumService;
import cn.hellohao.service.ImgService;
import cn.hellohao.service.ImgTempService;
import cn.hellohao.service.KeysService;
import cn.hellohao.service.SysConfigService;
import cn.hellohao.service.UploadConfigService;
import cn.hellohao.service.impl.AlbumServiceImpl;
import cn.hellohao.service.impl.COSImageupload;
import cn.hellohao.service.impl.FTPImageupload;
import cn.hellohao.service.impl.KODOImageupload;
import cn.hellohao.service.impl.NOSImageupload;
import cn.hellohao.service.impl.OSSImageupload;
import cn.hellohao.service.impl.UFileImageupload;
import cn.hellohao.service.impl.USSImageupload;
import cn.hellohao.service.impl.UploadServicel;
import cn.hellohao.utils.GetIPS;
import cn.hellohao.utils.LocUpdateImg;
import cn.hellohao.utils.verifyCode.SimpleCharVerifyCodeGenImpl;
import cn.hellohao.utils.verifyCode.VerifyCode;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class IndexController {
    @Autowired
    private ImgService imgService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    IRedisService iRedisService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private UploadConfigService uploadConfigService;
    @Autowired
    private UploadServicel uploadServicel;
    @Autowired
    private NOSImageupload nosImageupload;
    @Autowired
    private OSSImageupload ossImageupload;
    @Autowired
    private COSImageupload cosImageupload;
    @Autowired
    private KODOImageupload kodoImageupload;
    @Autowired
    private USSImageupload ussImageupload;
    @Autowired
    private UFileImageupload uFileImageupload;
    @Autowired
    private FTPImageupload ftpImageupload;
    @Autowired
    AlbumServiceImpl albumService;
    @Autowired
    private KeysService keysService;
    @Autowired
    private ImgTempService imgTempService;
    @Autowired
    private ImgAndAlbumService imgAndAlbumService;

    @RequestMapping(value={"/webInfo"})
    @ResponseBody
    public Msg webInfo() {
        Msg msg = new Msg();
        Config config = this.configService.getSourceype();
        UploadConfig updateConfig = this.uploadConfigService.getUpdateConfig();
        SysConfig sysConfig = this.sysConfigService.getstate();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("webname", (Object)config.getWebname());
        jsonObject.put("websubtitle", (Object)config.getWebsubtitle());
        jsonObject.put("keywords", (Object)config.getWebkeywords());
        jsonObject.put("description", (Object)config.getWebms());
        jsonObject.put("explain", (Object)config.getExplain());
        jsonObject.put("favicon", (Object)config.getWebfavicons());
        jsonObject.put("baidu", (Object)config.getBaidu());
        jsonObject.put("links", (Object)config.getLinks());
        jsonObject.put("aboutinfo", (Object)config.getAboutinfo());
        jsonObject.put("logo", (Object)config.getLogo());
        jsonObject.put("api", (Object)updateConfig.getApi());
        jsonObject.put("register", (Object)sysConfig.getRegister());
        msg.setData((Object)jsonObject);
        return msg;
    }

    @PostMapping(value={"/upload"})
    @ResponseBody
    public Msg upimg(HttpServletRequest request, HttpSession httpSession, @RequestParam(value="file", required=false) MultipartFile multipartFile, Integer day, @RequestParam(value="classifications", defaultValue="") String classifications) {
        JSONArray jsonArray = new JSONArray();
        if (!classifications.equals("")) {
            String[] calssif = classifications.split(",");
            for (int i = 0; i < calssif.length; ++i) {
                jsonArray.add((Object)calssif[i]);
            }
        }
        return this.uploadServicel.uploadForLoc(request, multipartFile, day, null, jsonArray);
    }

    @PostMapping(value={"/uploadForUrl"})
    @ResponseBody
    public Msg upurlimg(HttpServletRequest request, @RequestParam(value="data", defaultValue="") String data) {
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        JSONArray jsonArray = new JSONArray();
        Integer setday = jsonObj.getInteger("day");
        String imgUrl = jsonObj.getString("imgUrl");
        String selectTreeListStr = jsonObj.getString("classifications");
        if (null != selectTreeListStr) {
            String[] calssif = selectTreeListStr.split(",");
            for (int i = 0; i < calssif.length; ++i) {
                jsonArray.add((Object)calssif[i]);
            }
        }
        return this.uploadServicel.uploadForLoc(request, null, setday, imgUrl, jsonArray);
    }

    @RequestMapping(value={"/getUploadInfo"})
    @ResponseBody
    public Msg getUploadInfo() {
        Msg msg = new Msg();
        JSONObject jsonObject = new JSONObject();
        Subject subject = SecurityUtils.getSubject();
        User user = (User)subject.getPrincipal();
        try {
            UploadConfig updateConfig = this.uploadConfigService.getUpdateConfig();
            jsonObject.put("suffix", (Object)updateConfig.getSuffix().split(","));
            if (null == user) {
                jsonObject.put("filesize", (Object)(Integer.valueOf(updateConfig.getFilesizetourists()) / 1024));
                jsonObject.put("imgcount", (Object)updateConfig.getImgcounttourists());
                jsonObject.put("uploadSwitch", (Object)updateConfig.getIsupdate());
                jsonObject.put("uploadInfo", (Object)"\u60a8\u767b\u9646\u540e\u624d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd\u54e6");
            } else {
                jsonObject.put("filesize", (Object)(Integer.valueOf(updateConfig.getFilesizeuser()) / 1024));
                jsonObject.put("imgcount", (Object)updateConfig.getImgcountuser());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        msg.setData((Object)jsonObject);
        return msg;
    }

    @RequestMapping(value={"/checkStatus"})
    @ResponseBody
    public Msg checkStatus(HttpServletRequest request) {
        Msg msg = new Msg();
        String token = request.getHeader("Authorization");
        if (token != null) {
            JSONObject tokenJson = JWTUtil.checkToken((String)token);
            if (tokenJson.getBoolean("check").booleanValue()) {
                Subject subject = SecurityUtils.getSubject();
                UsernamePasswordToken tokenOBJ = new UsernamePasswordToken(tokenJson.getString("email"), tokenJson.getString("password"));
                tokenOBJ.setRememberMe(true);
                try {
                    subject.login((AuthenticationToken)tokenOBJ);
                    SecurityUtils.getSubject().getSession().setTimeout(3600000L);
                    User u = (User)subject.getPrincipal();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("RoleLevel", (Object)(u.getLevel() == 2 ? "admin" : "user"));
                    jsonObject.put("userName", (Object)u.getUsername());
                    msg.setCode("200");
                    msg.setData((Object)jsonObject);
                }
                catch (Exception e) {
                    msg.setCode("40041");
                    msg.setInfo("\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    System.err.println("\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    e.printStackTrace();
                }
            } else {
                msg.setCode("40041");
                msg.setInfo("\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
        } else {
            msg.setCode("40040");
            msg.setInfo("\u5f53\u524d\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55");
        }
        return msg;
    }

    @GetMapping(value={"/verifyCode"})
    public void verifyCode(HttpServletRequest request, HttpServletResponse response, HttpSession httpSession) {
        SimpleCharVerifyCodeGenImpl iVerifyCodeGen = new SimpleCharVerifyCodeGenImpl();
        try {
            VerifyCode verifyCode = iVerifyCodeGen.generate(80, 38);
            String code = verifyCode.getCode();
            String userIP = GetIPS.getIpAddr((HttpServletRequest)request);
            this.iRedisService.setValue(userIP + "_hellohao_verifyCode", code);
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("image/jpeg");
            response.getOutputStream().write(verifyCode.getImgBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/verifyCodeForRegister"})
    public void verifyCodeForRegister(HttpServletRequest request, HttpServletResponse response, HttpSession httpSession) {
        SimpleCharVerifyCodeGenImpl iVerifyCodeGen = new SimpleCharVerifyCodeGenImpl();
        try {
            VerifyCode verifyCode = iVerifyCodeGen.generate(80, 38);
            String code = verifyCode.getCode();
            String userIP = GetIPS.getIpAddr((HttpServletRequest)request);
            this.iRedisService.setValue(userIP + "_hellohao_verifyCodeForRegister", code);
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("image/jpeg");
            response.getOutputStream().write(verifyCode.getImgBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/verifyCodeForRetrieve"})
    public void verifyCodeForRetrieve(HttpServletRequest request, HttpServletResponse response, HttpSession httpSession) {
        SimpleCharVerifyCodeGenImpl iVerifyCodeGen = new SimpleCharVerifyCodeGenImpl();
        try {
            VerifyCode verifyCode = iVerifyCodeGen.generate(80, 38);
            String code = verifyCode.getCode();
            System.out.println("verifyCodeForRetrieve-zhaoHui httpSession ID===" + httpSession.getId());
            String userIP = GetIPS.getIpAddr((HttpServletRequest)request);
            this.iRedisService.setValue(userIP + "_hellohao_verifyCodeForEmailRetrieve", code);
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("image/jpeg");
            response.getOutputStream().write(verifyCode.getImgBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/deleImagesByUid"})
    @ResponseBody
    public Msg deleImagesByUid(@RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        String imguid = jsonObj.getString("imguid");
        Images image = this.imgService.selectImgUrlByImgUID(imguid);
        Subject subject = SecurityUtils.getSubject();
        User user = (User)subject.getPrincipal();
        if (null != user && user.getId() != image.getUserid()) {
            msg.setInfo("\u5220\u9664\u5931\u8d25\uff0c\u8be5\u56fe\u7247\u4e0d\u5141\u8bb8\u4f60\u6267\u884c\u64cd\u4f5c");
            msg.setCode("100403");
            return msg;
        }
        Integer keyid = image.getSource();
        String imgname = image.getImgname();
        Keys key = this.keysService.selectKeys(keyid);
        boolean isDele = false;
        if (key.getStorageType() == 1) {
            isDele = this.nosImageupload.delNOS(key.getId(), imgname);
        } else if (key.getStorageType() == 2) {
            isDele = this.ossImageupload.delOSS(key.getId(), imgname);
        } else if (key.getStorageType() == 3) {
            isDele = this.ussImageupload.delUSS(key.getId(), imgname);
        } else if (key.getStorageType() == 4) {
            isDele = this.kodoImageupload.delKODO(key.getId(), imgname);
        } else if (key.getStorageType() == 5) {
            isDele = LocUpdateImg.deleteLOCImg((String)imgname);
        } else if (key.getStorageType() == 6) {
            isDele = this.cosImageupload.delCOS(key.getId(), imgname);
        } else if (key.getStorageType() == 7) {
            isDele = this.ftpImageupload.delFTP(key.getId(), imgname);
        } else if (key.getStorageType() == 8) {
            isDele = this.uFileImageupload.delUFile(key.getId(), imgname);
        } else {
            System.err.println("\u672a\u83b7\u53d6\u5230\u5bf9\u8c61\u5b58\u50a8\u53c2\u6570\uff0c\u5220\u9664\u5931\u8d25\u3002");
        }
        if (isDele) {
            try {
                this.imgAndAlbumService.deleteImgAndAlbum(imgname);
                this.imgTempService.delImgAndExp(image.getImguid());
                this.imgService.deleimg(image.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.setInfo("\u56fe\u7247\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef");
                msg.setCode("500");
                return msg;
            }
            msg.setInfo("\u5220\u9664\u6210\u529f");
        } else {
            this.imgAndAlbumService.deleteImgAndAlbum(imgname);
            this.imgTempService.delImgAndExp(image.getImguid());
            this.imgService.deleimg(image.getId());
            msg.setInfo("\u56fe\u7247\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u4f46\u662f\u56fe\u7247\u6e90\u5220\u9664\u5931\u8d25");
            msg.setCode("500");
        }
        System.out.println("\u8fd4\u56de\u7684\u503c\uff1a" + msg.toString());
        return msg;
    }

    @RequestMapping(value={"/authError"})
    @ResponseBody
    public Msg authError(HttpServletRequest request) {
        Msg msg = new Msg();
        msg.setCode("4031");
        msg.setInfo("You don't have authority");
        return msg;
    }

    @RequestMapping(value={"/jurisError"})
    @ResponseBody
    public Msg jurisError(HttpServletRequest request) {
        Msg msg = new Msg();
        msg.setCode("4031");
        msg.setInfo("Authentication request failed");
        return msg;
    }
}

