/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.controller;

import cn.hellohao.auth.filter.SubjectFilter;
import cn.hellohao.auth.token.JWTUtil;
import cn.hellohao.config.SysName;
import cn.hellohao.controller.UserController;
import cn.hellohao.pojo.Config;
import cn.hellohao.pojo.EmailConfig;
import cn.hellohao.pojo.Msg;
import cn.hellohao.pojo.SysConfig;
import cn.hellohao.pojo.UploadConfig;
import cn.hellohao.pojo.User;
import cn.hellohao.service.ConfigService;
import cn.hellohao.service.EmailConfigService;
import cn.hellohao.service.IRedisService;
import cn.hellohao.service.SysConfigService;
import cn.hellohao.service.UploadConfigService;
import cn.hellohao.service.UserGroupService;
import cn.hellohao.service.UserService;
import cn.hellohao.utils.Base64Encryption;
import cn.hellohao.utils.GetIPS;
import cn.hellohao.utils.Print;
import cn.hellohao.utils.SetText;
import cn.hutool.core.util.HexUtil;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    private EmailConfigService emailConfigService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private UploadConfigService uploadConfigService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    IRedisService iRedisService;

    @PostMapping(value={"/register"})
    @ResponseBody
    public Msg Register(HttpServletRequest request, @RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        String username = jsonObj.getString("username");
        String email = jsonObj.getString("email");
        String password = Base64Encryption.encryptBASE64((byte[])jsonObj.getString("password").getBytes());
        String userIP = GetIPS.getIpAddr((HttpServletRequest)request);
        String verifyCodeForRegister = jsonObj.getString("verifyCode");
        Object redis_verifyCodeForRegister = this.iRedisService.getValue(userIP + "_hellohao_verifyCodeForRegister");
        if (!SetText.checkEmail((String)email)) {
            msg.setCode("110403");
            msg.setInfo("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
            return msg;
        }
        String regex = "^\\w+$";
        if (username.length() > 20 || !username.matches(regex)) {
            msg.setCode("110403");
            msg.setInfo("\u7528\u6237\u540d\u4e0d\u5f97\u8d85\u8fc720\u4f4d\u5b57\u7b26");
            return msg;
        }
        if (null == redis_verifyCodeForRegister) {
            msg.setCode("4035");
            msg.setInfo("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5f04\u83b7\u53d6\u3002");
            return msg;
        }
        if (null == verifyCodeForRegister) {
            msg.setCode("4036");
            msg.setInfo("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return msg;
        }
        if (redis_verifyCodeForRegister.toString().toLowerCase().compareTo(verifyCodeForRegister.toLowerCase()) == 0) {
            User user = new User();
            UploadConfig updateConfig = this.uploadConfigService.getUpdateConfig();
            EmailConfig emailConfig = this.emailConfigService.getemail();
            Integer countusername = this.userService.countusername(username);
            Integer countmail = this.userService.countmail(email);
            SysConfig sysConfig = this.sysConfigService.getstate();
            if (sysConfig.getRegister() != 1) {
                msg.setCode("110403");
                msg.setInfo("\u672c\u7ad9\u5df2\u6682\u65f6\u5173\u95ed\u7528\u6237\u6ce8\u518c\u529f\u80fd");
                return msg;
            }
            if (countusername == 1 || !SysName.CheckSysName((String)username).booleanValue()) {
                msg.setCode("110406");
                msg.setInfo("\u6b64\u7528\u6237\u540d\u5df2\u5b58\u5728");
                return msg;
            }
            if (countmail == 1) {
                msg.setCode("110407");
                msg.setInfo("\u6b64\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
                return msg;
            }
            String uid = UUID.randomUUID().toString().replace("-", "").toLowerCase();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String birthder = df.format(new Date());
            user.setLevel(Integer.valueOf(1));
            user.setUid(uid);
            user.setBirthder(birthder);
            user.setMemory(updateConfig.getUsermemory());
            user.setGroupid(Integer.valueOf(1));
            user.setEmail(email);
            user.setUsername(username);
            user.setPassword(password);
            Config config = this.configService.getSourceype();
            Integer type = 0;
            if (emailConfig.getUsing() == 1) {
                user.setIsok(Integer.valueOf(0));
                1 thread = new /* Unavailable Anonymous Inner Class!! */;
                thread.start();
                msg.setInfo("\u6ce8\u518c\u6210\u529f,\u8bf7\u6ce8\u610f\u67e5\u6536\u90ae\u7bb1\u5c3d\u5feb\u6fc0\u6d3b\u8d26\u6237");
            } else {
                user.setIsok(Integer.valueOf(1));
                msg.setInfo("\u6ce8\u518c\u6210\u529f,\u5feb\u53bb\u767b\u9646\u5427");
            }
            this.userService.register(user);
        } else {
            msg.setCode("110408");
            msg.setInfo("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        return msg;
    }

    @PostMapping(value={"/login"})
    @ResponseBody
    public Msg login(HttpServletRequest request, @RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        String email = jsonObj.getString("email");
        String password = Base64Encryption.encryptBASE64((byte[])jsonObj.getString("password").getBytes());
        String verifyCode = jsonObj.getString("verifyCode");
        String userIP = GetIPS.getIpAddr((HttpServletRequest)request);
        Object redis_VerifyCode = this.iRedisService.getValue(userIP + "_hellohao_verifyCode");
        if (null == redis_VerifyCode) {
            msg.setCode("4035");
            msg.setInfo("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5f04\u83b7\u53d6\u3002");
            return msg;
        }
        if (null == verifyCode) {
            msg.setCode("4036");
            msg.setInfo("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return msg;
        }
        if (redis_VerifyCode.toString().toLowerCase().compareTo(verifyCode.toLowerCase()) == 0) {
            Subject subject = SecurityUtils.getSubject();
            UsernamePasswordToken tokenOBJ = new UsernamePasswordToken(email, password);
            tokenOBJ.setRememberMe(true);
            try {
                subject.login((AuthenticationToken)tokenOBJ);
                SecurityUtils.getSubject().getSession().setTimeout(3600000L);
                JSONObject jsonObject = new JSONObject();
                User user = (User)SecurityUtils.getSubject().getPrincipal();
                if (user.getIsok() == 0) {
                    msg.setInfo("\u4f60\u7684\u8d26\u53f7\u6682\u672a\u6fc0\u6d3b");
                    msg.setCode("110403");
                    return msg;
                }
                if (user.getIsok() < 0) {
                    msg.setInfo("\u4f60\u7684\u8d26\u6237\u5df2\u88ab\u51bb\u7ed3");
                    msg.setCode("110403");
                    return msg;
                }
                String token = JWTUtil.createToken((User)user);
                Subject su = SecurityUtils.getSubject();
                System.out.println("\u5f53\u524d\u7528\u6237\u89d2\u8272\uff1aadmin:" + su.hasRole("admin"));
                msg.setInfo("\u767b\u5f55\u6210\u529f");
                jsonObject.put("token", (Object)token);
                jsonObject.put("RoleLevel", (Object)(user.getLevel() == 2 ? "admin" : "user"));
                jsonObject.put("userName", (Object)user.getUsername());
                msg.setData((Object)jsonObject);
                return msg;
            }
            catch (UnknownAccountException e) {
                msg.setCode("4000");
                msg.setInfo("\u767b\u5f55\u90ae\u7bb1\u4e0d\u5b58\u5728");
                System.err.println("\u90ae\u7bb1\u4e0d\u5b58\u5728");
                e.printStackTrace();
                return msg;
            }
            catch (IncorrectCredentialsException e) {
                msg.setCode("4000");
                msg.setInfo("\u767b\u5f55\u5bc6\u7801\u9519\u8bef");
                System.err.println("\u5bc6\u7801\u4e0d\u5b58\u5728");
                e.printStackTrace();
                return msg;
            }
            catch (Exception e) {
                msg.setCode("5000");
                msg.setInfo("\u767b\u5f55\u5931\u8d25");
                System.err.println("\u767b\u5f55\u5931\u8d25");
                e.printStackTrace();
                return msg;
            }
        }
        msg.setCode("40034");
        msg.setInfo("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        return msg;
    }

    @RequestMapping(value={"/activation"}, method={RequestMethod.GET})
    public String activation(Model model, HttpServletRequest request, HttpSession session, String activation, String username) {
        Config config = this.configService.getSourceype();
        Integer ret = 0;
        User u2 = new User();
        u2.setUid(activation);
        User user = this.userService.getUsers(u2);
        model.addAttribute("webhost", (Object)SubjectFilter.WEBHOST);
        if (user != null && user.getIsok() == 0) {
            this.userService.uiduser(activation);
            model.addAttribute("title", (Object)"\u6fc0\u6d3b\u6210\u529f");
            model.addAttribute("name", (Object)("Hi~" + username));
            model.addAttribute("note", (Object)"\u60a8\u7684\u8d26\u53f7\u5df2\u6210\u529f\u6fc0\u6d3b\u770b");
            return "msg";
        }
        model.addAttribute("title", (Object)"\u64cd\u4f5c\u65e0\u6548");
        model.addAttribute("name", (Object)"\u8be5\u9875\u9762\u4e3a\u65e0\u6548\u9875\u9762");
        model.addAttribute("note", (Object)"\u8bf7\u8fd4\u56de\u9996\u9875");
        return "msg";
    }

    @PostMapping(value={"/logout"})
    @ResponseBody
    public Msg exit(Model model, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Msg msg = new Msg();
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        msg.setInfo("\u9000\u51fa\u6210\u529f");
        Print.Normal((Object)"\u7528\u6237\u8d26\u53f7\u9000\u51fa\u6210\u529f");
        return msg;
    }

    @PostMapping(value={"/retrievePass"})
    @ResponseBody
    public Msg retrievePass(HttpServletRequest request, @RequestParam(value="data", defaultValue="") String data) {
        Msg msg = new Msg();
        try {
            JSONObject jsonObj = JSONObject.parseObject((String)data);
            String email = jsonObj.getString("email");
            String retrieveCode = jsonObj.getString("retrieveCode");
            String userIP = GetIPS.getIpAddr((HttpServletRequest)request);
            Object redis_verifyCodeForEmailRetrieve = this.iRedisService.getValue(userIP + "_hellohao_verifyCodeForEmailRetrieve");
            EmailConfig emailConfig = this.emailConfigService.getemail();
            if (null == redis_verifyCodeForEmailRetrieve) {
                msg.setCode("4035");
                msg.setInfo("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5f04\u83b7\u53d6\u3002");
                return msg;
            }
            if (null == retrieveCode) {
                msg.setCode("4036");
                msg.setInfo("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return msg;
            }
            if (redis_verifyCodeForEmailRetrieve.toString().toLowerCase().compareTo(retrieveCode.toLowerCase()) != 0) {
                msg.setCode("40034");
                msg.setInfo("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
                return msg;
            }
            Integer ret = this.userService.countmail(email);
            if (ret > 0) {
                if (emailConfig.getUsing() == 1) {
                    User u2 = new User();
                    u2.setEmail(email);
                    User user = this.userService.getUsers(u2);
                    if (user.getIsok() == -1) {
                        msg.setCode("110110");
                        msg.setInfo("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u51bb\u7ed3\uff0c\u7981\u6b62\u64cd\u4f5c");
                        return msg;
                    }
                    Config config = this.configService.getSourceype();
                    2 thread = new /* Unavailable Anonymous Inner Class!! */;
                    thread.start();
                    msg.setInfo("\u91cd\u7f6e\u5bc6\u7801\u7684\u9a8c\u8bc1\u94fe\u63a5\u5df2\u53d1\u9001\u81f3\u8be5\u90ae\u7bb1\uff0c\u8bf7\u524d\u5f80\u90ae\u7bb1\u9a8c\u8bc1\u5e76\u91cd\u7f6e\u5bc6\u7801\u3002\u3010\u82e5\u957f\u65f6\u95f4\u672a\u6536\u5230\u90ae\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5783\u573e\u7bb1\u3011");
                } else {
                    msg.setCode("400");
                    msg.setInfo("\u672c\u7ad9\u6682\u672a\u5f00\u542f\u90ae\u7bb1\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
            } else {
                msg.setCode("110404");
                msg.setInfo("\u672a\u627e\u5230\u90ae\u7bb1\u6240\u5728\u7684\u7528\u6237");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setCode("110500");
            msg.setInfo("\u7cfb\u7edf\u53d1\u751f\u9519\u8bef");
        }
        return msg;
    }

    @RequestMapping(value={"/retrieve"}, method={RequestMethod.GET})
    public String retrieve(Model model, String activation, String cip) {
        Integer ret = 0;
        try {
            User u2 = new User();
            u2.setUid(activation);
            User user = this.userService.getUsers(u2);
            user.setIsok(Integer.valueOf(1));
            String new_pass = HexUtil.decodeHexStr((String)cip);
            user.setPassword(Base64Encryption.encryptBASE64((byte[])new_pass.getBytes()));
            String uid = UUID.randomUUID().toString().replace("-", "").toLowerCase();
            user.setUid(uid);
            if (user != null) {
                Integer r = this.userService.changeUser(user);
                model.addAttribute("title", (Object)"\u6210\u529f");
                model.addAttribute("name", (Object)("\u65b0\u5bc6\u7801:" + new_pass));
                model.addAttribute("note", (Object)"\u5bc6\u7801\u5df2\u88ab\u7cfb\u7edf\u91cd\u7f6e\uff0c\u8bf7\u5373\u4f7f\u767b\u5f55\u4fee\u6539\u4f60\u7684\u65b0\u5bc6\u7801");
            } else {
                model.addAttribute("title", (Object)"\u62b1\u6b49");
                model.addAttribute("name", (Object)"\u4e3a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
                model.addAttribute("note", (Object)"\u64cd\u4f5c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            model.addAttribute("title", (Object)"\u62b1\u6b49");
            model.addAttribute("name", (Object)"\u7cfb\u7edf\u64cd\u4f5c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef");
            model.addAttribute("note", (Object)"\u64cd\u4f5c\u5931\u8d25");
        }
        model.addAttribute("webhost", (Object)SubjectFilter.WEBHOST);
        return "msg";
    }
}

