/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.quartz;

import cn.hellohao.quartz.job.FirstJob;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;

@Configuration
public class QuartzConfiguration {
    @Bean(name={"firstJobDetail"})
    public MethodInvokingJobDetailFactoryBean firstJobDetail(FirstJob firstJob) {
        MethodInvokingJobDetailFactoryBean jobDetail = new MethodInvokingJobDetailFactoryBean();
        jobDetail.setConcurrent(true);
        jobDetail.setTargetObject((Object)firstJob);
        jobDetail.setTargetMethod("task");
        return jobDetail;
    }

    @Bean(name={"firstTrigger"})
    public SimpleTriggerFactoryBean firstTrigger(JobDetail firstJobDetail) {
        SimpleTriggerFactoryBean trigger = new SimpleTriggerFactoryBean();
        trigger.setJobDetail(firstJobDetail);
        trigger.setStartDelay(0L);
        trigger.setRepeatInterval(60000L);
        return trigger;
    }

    @Bean(name={"scheduler"})
    public SchedulerFactoryBean schedulerFactory(Trigger firstTrigger, Trigger secondTrigger) {
        SchedulerFactoryBean bean = new SchedulerFactoryBean();
        bean.setStartupDelay(5);
        bean.setTriggers(new Trigger[]{firstTrigger, secondTrigger});
        return bean;
    }
}

