/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.quartz.job;

import cn.hellohao.pojo.Images;
import cn.hellohao.pojo.Keys;
import cn.hellohao.service.ImgTempService;
import cn.hellohao.service.KeysService;
import cn.hellohao.service.impl.COSImageupload;
import cn.hellohao.service.impl.FTPImageupload;
import cn.hellohao.service.impl.ImgServiceImpl;
import cn.hellohao.service.impl.KODOImageupload;
import cn.hellohao.service.impl.NOSImageupload;
import cn.hellohao.service.impl.OSSImageupload;
import cn.hellohao.service.impl.UFileImageupload;
import cn.hellohao.service.impl.USSImageupload;
import cn.hellohao.utils.LocUpdateImg;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class FirstJob {
    @Autowired
    private ImgServiceImpl imgService;
    @Autowired
    private NOSImageupload nosImageupload;
    @Autowired
    private OSSImageupload ossImageupload;
    @Autowired
    private COSImageupload cosImageupload;
    @Autowired
    private KODOImageupload kodoImageupload;
    @Autowired
    private USSImageupload ussImageupload;
    @Autowired
    private UFileImageupload uFileImageupload;
    @Autowired
    private FTPImageupload ftpImageupload;
    @Autowired
    ImgTempService imgTempService;
    @Autowired
    KeysService keysService;
    private static FirstJob firstJob;

    @PostConstruct
    public void init() {
        firstJob = this;
    }

    public void task() {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currdate = format.format(new Date());
            List imagesList = this.imgTempService.selectDelImgUidList(currdate);
            if (imagesList.size() == 0) {
                return;
            }
            for (Images images : imagesList) {
                this.imgTempService.delImgAndExp(images.getImguid());
                this.imgService.deleimgForImgUid(images.getImguid());
                Keys keys = this.keysService.selectKeys(images.getSource());
                if (keys.getStorageType() == 1) {
                    FirstJob.firstJob.nosImageupload.delNOS(keys.getId(), images.getImgname());
                    continue;
                }
                if (keys.getStorageType() == 2) {
                    FirstJob.firstJob.ossImageupload.delOSS(keys.getId(), images.getImgname());
                    continue;
                }
                if (keys.getStorageType() == 3) {
                    FirstJob.firstJob.ussImageupload.delUSS(keys.getId(), images.getImgname());
                    continue;
                }
                if (keys.getStorageType() == 4) {
                    FirstJob.firstJob.kodoImageupload.delKODO(keys.getId(), images.getImgname());
                    continue;
                }
                if (keys.getStorageType() == 5) {
                    LocUpdateImg.deleteLOCImg((String)images.getImgname());
                    continue;
                }
                if (keys.getStorageType() == 6) {
                    FirstJob.firstJob.cosImageupload.delCOS(keys.getId(), images.getImgname());
                    continue;
                }
                if (keys.getStorageType() == 7) {
                    FirstJob.firstJob.ftpImageupload.delFTP(keys.getId(), images.getImgname());
                    continue;
                }
                if (keys.getStorageType() == 8) {
                    FirstJob.firstJob.uFileImageupload.delUFile(keys.getId(), images.getImgname());
                    continue;
                }
                System.err.println("\u672a\u83b7\u53d6\u5230\u5bf9\u8c61\u5b58\u50a8\u53c2\u6570\uff0c\u4e0a\u4f20\u5931\u8d25\u3002");
            }
        }
        catch (Exception e) {
            System.err.println("\u4efb\u52a1\u67e5\u8be2\u671f\u9650\u56fe\u50cf\u53d1\u751f\u9519\u8bef");
            e.printStackTrace();
        }
    }
}

