/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.service.impl;

import cn.hellohao.dao.GroupMapper;
import cn.hellohao.dao.UserMapper;
import cn.hellohao.exception.CodeException;
import cn.hellohao.pojo.Group;
import cn.hellohao.pojo.Msg;
import cn.hellohao.pojo.User;
import cn.hellohao.service.GroupService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupServiceImpl
implements GroupService {
    @Autowired
    private GroupMapper groupMapper;
    @Autowired
    private UserMapper userMapper;

    public List<Group> grouplist(Integer usertype) {
        return this.groupMapper.grouplist(usertype);
    }

    public Group idgrouplist(Integer id) {
        return this.groupMapper.idgrouplist(id);
    }

    public Msg addgroup(Group group) {
        Msg msg = new Msg();
        if (group.getUsertype() != 0) {
            Integer count = this.groupMapper.GetCountFroUserType(group.getUsertype());
            if (count == 0) {
                this.groupMapper.addgroup(group);
                msg.setInfo("\u6dfb\u52a0\u6210\u529f");
            } else {
                msg.setCode("110401");
                msg.setInfo("\u5206\u914d\u7684\u8be5\u7528\u6237\u7ec4\u5df2\u5b58\u5728\u3002\u8bf7\u52ff\u91cd\u590d\u5206\u914d\u3002");
            }
        } else {
            this.groupMapper.addgroup(group);
            msg.setInfo("\u6dfb\u52a0\u6210\u529f");
        }
        return msg;
    }

    public Integer GetCountFroUserType(Integer usertype) {
        return this.groupMapper.GetCountFroUserType(usertype);
    }

    @Transactional
    public Msg delegroup(Integer id) {
        Msg msg = new Msg();
        Integer ret = 0;
        ret = this.groupMapper.delegroup(id);
        if (ret > 0) {
            List userList = this.userMapper.getuserlistforgroupid(id);
            for (User user : userList) {
                User u = new User();
                u.setGroupid(Integer.valueOf(1));
                u.setUid(user.getUid());
                this.userMapper.change(u);
            }
        } else {
            msg.setCode("500");
            msg.setInfo("\u5220\u9664\u6210\u529f");
            throw new CodeException("\u7528\u6237\u4e4b\u6ca1\u6709\u8bbe\u7f6e\u6210\u529f\u3002");
        }
        msg.setInfo("\u5220\u9664\u6210\u529f");
        return msg;
    }

    public Msg setgroup(Group group) {
        Msg msg = new Msg();
        if (group.getUsertype() != 0) {
            Group groupFroUserType = this.groupMapper.getGroupFroUserType(group.getUsertype());
            if (groupFroUserType != null) {
                if (groupFroUserType.getUsertype() == group.getUsertype()) {
                    if (groupFroUserType.getId() == group.getId()) {
                        this.groupMapper.setgroup(group);
                        msg.setInfo("\u4fee\u6539\u6210\u529f");
                    } else {
                        msg.setCode("110401");
                        msg.setInfo("\u5206\u914d\u7684\u8be5\u7528\u6237\u7ec4\u5df2\u5b58\u5728\u3002\u8bf7\u52ff\u91cd\u590d\u5206\u914d\u3002");
                    }
                } else if (this.groupMapper.GetCountFroUserType(group.getUsertype()) > 0) {
                    msg.setCode("110401");
                    msg.setInfo("\u5206\u914d\u7684\u8be5\u7528\u6237\u7ec4\u5df2\u5b58\u5728\u3002\u8bf7\u52ff\u91cd\u590d\u5206\u914d\u3002");
                } else {
                    this.groupMapper.setgroup(group);
                    msg.setInfo("\u4fee\u6539\u6210\u529f");
                }
            } else {
                this.groupMapper.setgroup(group);
                msg.setInfo("\u4fee\u6539\u6210\u529f");
            }
        } else {
            this.groupMapper.setgroup(group);
            msg.setInfo("\u4fee\u6539\u6210\u529f");
        }
        return msg;
    }

    public Group getGroupFroUserType(Integer usertype) {
        return this.groupMapper.getGroupFroUserType(usertype);
    }
}

