/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.service.impl;

import cn.hellohao.dao.ImgMapper;
import cn.hellohao.pojo.Images;
import cn.hellohao.pojo.Keys;
import cn.hellohao.pojo.User;
import cn.hellohao.service.ImgService;
import cn.hellohao.utils.Print;
import com.UpYun;
import com.aliyun.oss.OSSClient;
import com.netease.cloud.auth.BasicCredentials;
import com.netease.cloud.auth.Credentials;
import com.netease.cloud.services.nos.Nos;
import com.netease.cloud.services.nos.NosClient;
import com.netease.cloud.services.nos.model.Bucket;
import com.netease.cloud.services.nos.model.CannedAccessControlList;
import com.netease.cloud.services.nos.transfer.TransferManager;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.region.Region;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.util.Auth;
import com.upyun.UpException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImgServiceImpl
implements ImgService {
    @Autowired
    private ImgMapper imgMapper;

    public List<Images> selectimg(Images images) {
        return this.imgMapper.selectimg(images);
    }

    public Integer deleimg(Integer id) {
        return this.imgMapper.deleimg(id);
    }

    public Integer deleimgForImgUid(String imguid) {
        return this.imgMapper.deleimgForImgUid(imguid);
    }

    public Images selectByPrimaryKey(Integer id) {
        return this.imgMapper.selectByPrimaryKey(id);
    }

    public void delect(Keys key, String fileName) {
        BasicCredentials credentials = new BasicCredentials(key.getAccessKey(), key.getAccessSecret());
        NosClient nosClient = new NosClient((Credentials)credentials);
        nosClient.setEndpoint(key.getEndpoint());
        TransferManager transferManager = new TransferManager((Nos)nosClient);
        ArrayList<String> bucketList = new ArrayList<String>();
        String tname = "";
        for (Bucket bucket : nosClient.listBuckets()) {
            bucketList.add(bucket.getName());
        }
        for (Object e : bucketList) {
            tname = e.toString();
            CannedAccessControlList cannedAccessControlList = nosClient.getBucketAcl(e.toString());
        }
        boolean isExist = nosClient.doesObjectExist(tname, fileName, null);
        System.out.println("\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff1a" + isExist);
        if (isExist) {
            nosClient.deleteObject(tname, fileName);
        }
    }

    public void delectOSS(Keys key, String fileName) {
        String endpoint = key.getEndpoint();
        String accessKeyId = key.getAccessKey();
        String accessKeySecret = key.getAccessSecret();
        String bucketName = key.getBucketname();
        String objectName = fileName;
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        ossClient.deleteObject(bucketName, objectName);
        ossClient.shutdown();
    }

    public void delectUSS(Keys key, String fileName) {
        UpYun upyun = new UpYun(key.getBucketname(), key.getAccessKey(), key.getAccessSecret());
        try {
            boolean bl = upyun.deleteFile(fileName, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
    }

    public void delectUFile(Keys key, String fileName) {
        UpYun upyun = new UpYun(key.getBucketname(), key.getAccessKey(), key.getAccessSecret());
        try {
            boolean bl = upyun.deleteFile(fileName, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
    }

    public void delectKODO(Keys key, String fileName) {
        Configuration cfg = key.getEndpoint().equals("1") ? new Configuration(Zone.zone0()) : (key.getEndpoint().equals("2") ? new Configuration(Zone.zone1()) : (key.getEndpoint().equals("3") ? new Configuration(Zone.zone2()) : (key.getEndpoint().equals("4") ? new Configuration(Zone.zoneNa0()) : new Configuration(Zone.zoneAs0()))));
        Auth auth = Auth.create((String)key.getAccessKey(), (String)key.getAccessSecret());
        BucketManager bucketManager = new BucketManager(auth, cfg);
        try {
            bucketManager.delete(key.getBucketname(), fileName);
        }
        catch (QiniuException ex) {
            System.err.println(ex.code());
            System.err.println(ex.response.toString());
        }
    }

    public void delectCOS(Keys key, String fileName) {
        BasicCOSCredentials cred = new BasicCOSCredentials(key.getAccessKey(), key.getAccessSecret());
        Region region = new Region(key.getEndpoint());
        ClientConfig clientConfig = new ClientConfig(region);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        try {
            String bucketName = key.getBucketname();
            String userkey = fileName;
            cosClient.deleteObject(key.getBucketname(), userkey);
        }
        catch (CosServiceException serverException) {
            serverException.printStackTrace();
        }
        catch (CosClientException clientException) {
            clientException.printStackTrace();
        }
    }

    public void delectFTP(Keys key, String fileName) {
        FTPClient ftp = new FTPClient();
        String[] host = key.getEndpoint().split("\\:");
        String h = host[0];
        Integer p = Integer.parseInt(host[1]);
        try {
            if (!ftp.isConnected()) {
                ftp.connect(h, p.intValue());
            }
            ftp.login(key.getAccessKey(), key.getAccessSecret());
            ftp.deleteFile(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            Print.warning((Object)"\u5220\u9664FTP\u5b58\u50a8\u7684\u56fe\u7247\u5931\u8d25");
        }
    }

    public Integer counts(Integer userid) {
        return this.imgMapper.counts(userid);
    }

    public Integer countimg(Integer userid) {
        return this.imgMapper.countimg(userid);
    }

    public Integer setImg(Images images) {
        return this.imgMapper.setImg(images);
    }

    public Integer deleimgname(String imgname) {
        return this.imgMapper.deleimgname(imgname);
    }

    public Integer deleall(Integer id) {
        return this.imgMapper.deleall(id);
    }

    public List<Images> gettimeimg(String time) {
        return this.imgMapper.gettimeimg(time);
    }

    public Long getusermemory(Integer userid) {
        return this.imgMapper.getusermemory(userid);
    }

    public Long getsourcememory(Integer source) {
        return this.imgMapper.getsourcememory(source);
    }

    public Integer md5Count(Images images) {
        return this.imgMapper.md5Count(images);
    }

    public Images selectImgUrlByMD5(String md5key) {
        return this.imgMapper.selectImgUrlByMD5(md5key);
    }

    public List<Images> RecentlyUploaded(Integer userid) {
        return this.imgMapper.RecentlyUploaded(userid);
    }

    public List<User> RecentlyUser() {
        return this.imgMapper.RecentlyUser();
    }

    public List<String> getyyyy(Integer userid) {
        return this.imgMapper.getyyyy(userid);
    }

    public List<Images> countByM(Images images) {
        return this.imgMapper.countByM(images);
    }

    public Images selectImgUrlByImgUID(String imguid) {
        return this.imgMapper.selectImgUrlByImgUID(imguid);
    }
}

