/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.service.impl;

import cn.hellohao.auth.filter.SubjectFilter;
import cn.hellohao.dao.KeysMapper;
import cn.hellohao.pojo.Keys;
import cn.hellohao.service.impl.COSImageupload;
import cn.hellohao.service.impl.FTPImageupload;
import cn.hellohao.service.impl.KODOImageupload;
import cn.hellohao.service.impl.NOSImageupload;
import cn.hellohao.service.impl.OSSImageupload;
import cn.hellohao.service.impl.UFileImageupload;
import cn.hellohao.service.impl.USSImageupload;
import cn.hellohao.utils.Print;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class InitializationStorage
implements CommandLineRunner {
    @Value(value="${CROS_ALLOWED_ORIGINS}")
    private String allowedOrigins;
    @Autowired
    private KeysMapper keysMapper;

    public void run(String ... args) throws Exception {
        SubjectFilter.WEBHOST = this.allowedOrigins;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        this.intiStorage();
        this.sout();
    }

    public void intiStorage() {
        List keylist = this.keysMapper.getKeys();
        for (Keys key : keylist) {
            if (key.getStorageType() == 0 || key.getStorageType() == null) continue;
            int ret = 0;
            if (key.getStorageType() == 1) {
                ret = NOSImageupload.Initialize((Keys)key);
                continue;
            }
            if (key.getStorageType() == 2) {
                ret = OSSImageupload.Initialize((Keys)key);
                continue;
            }
            if (key.getStorageType() == 3) {
                ret = USSImageupload.Initialize((Keys)key);
                continue;
            }
            if (key.getStorageType() == 4) {
                ret = KODOImageupload.Initialize((Keys)key);
                continue;
            }
            if (key.getStorageType() == 6) {
                ret = COSImageupload.Initialize((Keys)key);
                continue;
            }
            if (key.getStorageType() == 7) {
                ret = FTPImageupload.Initialize((Keys)key);
                continue;
            }
            if (key.getStorageType() != 8) continue;
            ret = UFileImageupload.Initialize((Keys)key);
        }
    }

    public void sout() {
        Print.Normal((Object)"______________________________________________");
        Print.Normal((Object)"              Hellohao Tbed                ");
        Print.Normal((Object)"     Successful startup of the program      ");
        Print.Normal((Object)"     is OK!  Open http:// yourIP:port       ");
        Print.Normal((Object)"______________________________________________");
    }
}

