/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.utils;

import cn.hellohao.utils.Print;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FTPUtils {
    private final Logger LOGGER = LogManager.getLogger(this.getClass());
    private FTPClient ftpClient = null;
    private String server;
    private int port;
    private String userName;
    private String userPassword;

    public FTPUtils(String server, int port, String userName, String userPassword) {
        this.server = server;
        this.port = port;
        this.userName = userName;
        this.userPassword = userPassword;
    }

    public boolean open() {
        if (this.ftpClient != null && this.ftpClient.isConnected()) {
            return true;
        }
        try {
            this.ftpClient = new FTPClient();
            this.ftpClient.connect(this.server, this.port);
            this.ftpClient.login(this.userName, this.userPassword);
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Print.warning((Object)"FTP\u670d\u52a1\u5668\u62d2\u7edd\u8fde\u63a5.");
                this.close();
                System.exit(1);
            }
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            return true;
        }
        catch (Exception e) {
            this.close();
            e.printStackTrace();
            return false;
        }
    }

    private boolean changeToParentDir() {
        try {
            return this.ftpClient.changeToParentDirectory();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean cd(String dir) {
        try {
            return this.ftpClient.changeWorkingDirectory(dir);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private FTPFile[] getFileList(String filePath) {
        try {
            return this.ftpClient.listFiles(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean changeDir(String ftpPath) {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        try {
            char[] chars = ftpPath.toCharArray();
            StringBuffer sbStr = new StringBuffer(256);
            for (int i = 0; i < chars.length; ++i) {
                if ('\\' == chars[i]) {
                    sbStr.append('/');
                    continue;
                }
                sbStr.append(chars[i]);
            }
            ftpPath = sbStr.toString();
            if (ftpPath.indexOf(47) == -1) {
                this.ftpClient.changeWorkingDirectory(new String(ftpPath.getBytes(), "UTF-8"));
            } else {
                String[] paths = ftpPath.split("/");
                for (int i = 0; i < paths.length; ++i) {
                    this.ftpClient.changeWorkingDirectory(new String(paths[i].getBytes(), "UTF-8"));
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean mkDir(String ftpPath) {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        try {
            char[] chars = ftpPath.toCharArray();
            StringBuffer sbStr = new StringBuffer(256);
            for (int i = 0; i < chars.length; ++i) {
                if ('\\' == chars[i]) {
                    sbStr.append('/');
                    continue;
                }
                sbStr.append(chars[i]);
            }
            ftpPath = sbStr.toString();
            if (ftpPath.indexOf(47) == -1) {
                this.ftpClient.makeDirectory(new String(ftpPath.getBytes(), "UTF-8"));
                this.ftpClient.changeWorkingDirectory(new String(ftpPath.getBytes(), "UTF-8"));
            } else {
                String[] paths = ftpPath.split("/");
                for (int i = 0; i < paths.length; ++i) {
                    this.ftpClient.makeDirectory(new String(paths[i].getBytes(), "UTF-8"));
                    this.ftpClient.changeWorkingDirectory(new String(paths[i].getBytes(), "UTF-8"));
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(File srcFile, String ftpFileName, String ftpDirectory) {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        boolean flag = false;
        if (this.ftpClient != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(srcFile);
                this.mkDir(ftpDirectory);
                this.ftpClient.setBufferSize(100000);
                this.ftpClient.setControlEncoding("UTF-8");
                this.ftpClient.setFileType(2);
                if (ftpFileName == null || ftpFileName == "") {
                    ftpFileName = srcFile.getName();
                }
                flag = this.ftpClient.storeFile(new String(ftpFileName.getBytes(), "UTF-8"), (InputStream)fis);
            }
            catch (Exception e) {
                this.close();
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public boolean get(String ftpDirectoryAndFileName, String localDirectoryAndFileName) {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        this.ftpClient.enterLocalPassiveMode();
        try {
            char[] chars = ftpDirectoryAndFileName.toCharArray();
            StringBuffer sbStr = new StringBuffer(256);
            for (int i = 0; i < chars.length; ++i) {
                if ('\\' == chars[i]) {
                    sbStr.append('/');
                    continue;
                }
                sbStr.append(chars[i]);
            }
            ftpDirectoryAndFileName = sbStr.toString();
            String filePath = ftpDirectoryAndFileName.substring(0, ftpDirectoryAndFileName.lastIndexOf("/"));
            String fileName = ftpDirectoryAndFileName.substring(ftpDirectoryAndFileName.lastIndexOf("/") + 1);
            this.changeDir(filePath);
            this.ftpClient.retrieveFile(new String(fileName.getBytes(), "UTF-8"), (OutputStream)new FileOutputStream(localDirectoryAndFileName));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String[] getFileNameList(String pathName) {
        try {
            return this.ftpClient.listNames(pathName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean deleteFile(String ftpDirAndFileName) {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        try {
            return this.ftpClient.deleteFile(ftpDirAndFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteDirectory(String ftpDirectory) {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        try {
            return this.ftpClient.removeDirectory(ftpDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        try {
            if (this.ftpClient != null && this.ftpClient.isConnected()) {
                this.ftpClient.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

