/*
 * Decompiled with CFR 0.152.
 */
package cn.hellohao.utils.verifyCode;

import cn.hellohao.utils.verifyCode.IVerifyCodeGen;
import cn.hellohao.utils.verifyCode.RandomUtils;
import cn.hellohao.utils.verifyCode.VerifyCode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleCharVerifyCodeGenImpl
implements IVerifyCodeGen {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCharVerifyCodeGenImpl.class);
    private static final String[] FONT_TYPES = new String[]{"\u5b8b\u4f53", "\u65b0\u5b8b\u4f53", "\u9ed1\u4f53", "\u6977\u4f53", "\u96b6\u4e66"};
    private static final int VALICATE_CODE_LENGTH = 4;

    private static void fillBackground(Graphics graphics, int width, int height) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        for (int i = 0; i < 8; ++i) {
            graphics.setColor(RandomUtils.randomColor((int)40, (int)150));
            Random random = new Random();
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int x1 = random.nextInt(width);
            int y1 = random.nextInt(height);
            graphics.drawLine(x, y, x1, y1);
        }
    }

    public String generate(int width, int height, OutputStream os) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics graphics = image.getGraphics();
        SimpleCharVerifyCodeGenImpl.fillBackground((Graphics)graphics, (int)width, (int)height);
        String randomStr = RandomUtils.randomString((int)4);
        this.createCharacter(graphics, randomStr);
        graphics.dispose();
        ImageIO.write((RenderedImage)image, "JPEG", os);
        return randomStr;
    }

    public VerifyCode generate(int width, int height) {
        VerifyCode verifyCode = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String code = this.generate(width, height, (OutputStream)baos);
            verifyCode = new VerifyCode();
            verifyCode.setCode(code);
            verifyCode.setImgBytes(baos.toByteArray());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            verifyCode = null;
        }
        return verifyCode;
    }

    private void createCharacter(Graphics g, String randomStr) {
        char[] charArray = randomStr.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            g.setColor(new Color(50 + RandomUtils.nextInt((int)100), 50 + RandomUtils.nextInt((int)100), 50 + RandomUtils.nextInt((int)100)));
            g.setFont(new Font(FONT_TYPES[RandomUtils.nextInt((int)FONT_TYPES.length)], 1, 26));
            g.drawString(String.valueOf(charArray[i]), 15 * i + 5, 19 + RandomUtils.nextInt((int)8));
        }
    }
}

