#!/bin/bash

#Shell By Hellohao

ISJDK=n

echo -e "\033[1;33m Hellohao图像托管程序 \033[0m"
echo -e "\033[1;33m 开源版一键启动脚本 \033[0m"
echo -e "\033[1;33m 执行前需要用到的端口：服务端10088 前端10089 请自行准备这两个端口 \033[0m"
echo -e "\033[1;33m 所需环境:JDK1.8(java8),Resis,Mysql-5.6或Mysql-5.7 \033[0m"
echo " "
echo -e "\033[1;33m 是否需要运行环境？： \033[0m"
echo " "
echo "独立的Java运行环境：只会对本项目有效，不影响你本地的java环境 "
echo "换句话说就是，如果你本地的其他项目需要的java环境版本和我们的程序不一致，那么你可以选择安装此项"
echo "本程序内置了Redis同理不影响你服务器外部的环境，仅对本程序使用"
echo " "


echo -e "\033[1;33m 配置并部署程序[1] \033[0m"
echo -e "\033[1;33m 重启程序服务[2] \033[0m"
read -r -p "请根据自身情况输入[1]或[2] " input
case $input in
    [1])
		echo "配置并部署程序准备开始..."

                rm -rf ./logs/*
                rm -rf ./server/application.properties
                rm -rf ./server/redis/redis.conf
                rm -rf ./webapps/hellohao/config.json
                rm -rf ./bin/hellohao/config.json
                rm -rf ./bin/catalina.sh
                rm -rf ./bin/setclasspath.sh

                echo -e "\033[1;33m 如果你本地有JDK1.8环境则直接回车跳过安装 \033[0m"
                read -r -p "需要安装独立的Java运行环境? [Y] " input

                case $input in
                    [yY][eE][sS]|[yY])
                        echo "开始下载java环境..."
                        rm -rf ./server/jdk1.8.0_202/*
                        rm -rf ./server/jdk-8u202-linux-x64.tar.gz
                        ISJDK=y
                        wget -P ./server/  https://repo.huaweicloud.com/java/jdk/8u202-b08/jdk-8u202-linux-x64.tar.gz
                        tar -zxvf ./server/jdk-8u202-linux-x64.tar.gz -C ./server/
                        ;;

                    [nN][oO]|[nN])
                        echo "脚本退出"
                        ;;

                    *)

                    ;;
                esac

                MUSERNAME=tbed

                MDATABASENAME=tbed

                MPASS=

                MHOST=localhost
                
                MPORT=3306
                
                REDISPASS=
                
                SHOSR=http://127.0.0.1
                
                SPORT=10088
                
                
                WHOST=

                echo  -e "请随便设置Redis密码(任意输入6-8位):" 
                read REDISPASS0
                if [[ -z "$REDISPASS0" ]];then
                    echo "Redis密码没有设置,脚本退出"
                    echo "退出后请重新执行脚本并认真填写"
                    exit 1
                else
                    REDISPASS=$REDISPASS0
                fi

                echo  -e "请输入mysql用户名(默认:tbed):" 
                read MUSERNAME0
                if [[ -z "$MUSERNAME0" ]];then
                    MUSERNAME0=$MUSERNAME
                else
                    MUSERNAME=$MUSERNAME0
                fi

                echo  -e "请输入mysql数据库名(默认:tbed):" 
                read MDATABASENAME0
                if [[ -z "$MDATABASENAME0" ]];then
                    MDATABASENAME0=$MDATABASENAME
                else
                    MDATABASENAME=$MDATABASENAME0
                fi

                echo  -e "请输入mysql数据库密码(必填):" 
                read MPASS0
                if [[ -z "$MPASS0" ]];then
                    echo "数据库密码没有填写,脚本退出"
                    echo "退出后请重新执行脚本并认真填写"
                    exit 1
                else
                    MPASS=$MPASS0
                fi

                echo  -e "请输入mysql数据库地址(默认:localhost):" 
                read MHOST0
                if [[ -z "$MHOST0" ]];then
                    MHOST0=$MHOST
                else
                    MHOST=$MHOST0

                fi

                echo  -e "请输入mysql数据库端口(默认:3306):" 
                read MPORT0
                if [[ -z "$MPORT0" ]];then
                    MPORT0=$MPORT
                else
                    MPORT=$MPORT0
                fi

                echo  -e "请输入服务端域名(如果是IP则需要加上8088端口:http://192.168.0.1:10088):" 
                read SHOSR0
                if [[ -z "$SHOSR0" ]];then
                    SHOSR0=$SHOSR
                else
                    SHOSR=$SHOSR0
                fi

                echo  -e "请输入你的前端页面地址(需要带协议头http(s)://):" 
                read WHOST0
                if [[ -z "$WHOST0" ]];then
                    echo "前端页面地址没有输入,脚本退出"
                    echo "退出后请重新执行脚本并认真填写"
                    exit 1
                else
                    WHOST=$WHOST0
                fi


                echo " "
                echo "信息输入完毕"
                echo " "

                echo -e "\033[1;0;32m mysql数据库用户名:$MUSERNAME \033[0m"
                echo -e "\033[1;0;32m mysql数据库名:$MDATABASENAME \033[0m"
                echo -e "\033[1;0;32m mysql数据库密码:$MPASS \033[0m"
                echo -e "\033[1;0;32m mysql地址:$MHOST \033[0m"
                echo -e "\033[1;0;32m mysql端口:$MPORT \033[0m"
                echo -e "\033[1;0;32m 你设置的redis密码:$REDISPASS \033[0m"
                echo -e "\033[1;0;32m 服务端的端口:$SPORT \033[0m"
                echo -e "\033[1;0;32m 服务端地址:$SHOSR \033[0m"
                echo -e "\033[1;0;32m 前端页面地址:$WHOST \033[0m"

                echo " "

                read -r -p "请确认你以上信息是否正确? [Y/n] " input

                case $input in
                    [yY][eE][sS]|[yY])
                        echo "开始启动程序..."

                        cp ./server/template/application.properties  ./server/
                        cp ./server/template/redis.conf  ./server/redis/
                        cp ./server/template/config.json  ./webapps/hellohao/config.json

                        if [ "$ISJDK" = "y" ];then
                            cp ./server/template/bin/nojdk/catalina.sh  ./bin/
                            cp ./server/template/bin/nojdk/setclasspath.sh  ./bin/
                        fi
                        
                        if [ "$ISJDK" = "n" ];then
                            cp ./server/template/bin/yesjdk/catalina.sh  ./bin/
                            cp ./server/template/bin/yesjdk/setclasspath.sh  ./bin/
                        fi 

                        chmod -R 777 ./stop.sh
                        chmod -R 777 ./server/redis
                        chmod -R 777 ./bin

                        echo "spring.datasource.username=${MUSERNAME}" >> ./server/application.properties
                        echo "spring.datasource.password=${MPASS}" >> ./server/application.properties
                        echo "spring.datasource.url=jdbc:mysql://${MHOST}:${MPORT}/${MDATABASENAME}?useUnicode=true&characterEncoding=utf8&serverTimezone=GMT%2B8" >> ./server/application.properties
                        echo "server.port=${SPORT}" >> ./server/application.properties
                        echo "spring.redis.password=${REDISPASS}" >> ./server/application.properties
                        echo "CROS_ALLOWED_ORIGINS=${WHOST}" >> ./server/application.properties
                        echo "{\"serverHost\": \"${SHOSR}\"}" >> ./webapps/hellohao/config.json
                        echo "requirepass ${REDISPASS}" >> ./server/redis/redis.conf

                        ./bin/startup.sh

                        cd server

                        ./redis/redis-server ./redis/redis.conf &
                        echo -e "\033[1;44;32m Reids runs successfully \033[0m"

                        if [ "$ISJDK" = "y" ];then
                            nohup ./jdk1.8.0_202/bin/java -server -Xms256m -Xmx256m -jar Tbed.jar > Tbed-log.out 2>&1 &
                        fi
                        
                        if [ "$ISJDK" = "n" ];then
                            nohup java -server -Xms256m -Xmx256m -jar Tbed.jar > Tbed-log.out 2>&1 &
                        fi        

                        echo -e "\033[1;44;32m Start command has been executed \033[0m"
                        echo -e "\033[1;44;32m Please wait 1-2 minutes to access after startup \033[0m"


                        ;;

                    [nN][oO]|[nN])
                        echo "脚本退出"
                        ;;

                    *)
                        echo "completion of enforcement..."
                        exit 1
                        ;;
                esac

		;;

    [2])
        echo "重启程序服务"


                read -r -p "你当前的java环境是否是图床专用环境? [Y] " input

                case $input in
                    [yY][eE][sS]|[yY])
                        echo "独立环境-开始重启"
                        ISJDK=y
                        ;;

                    [nN][oO]|[nN])
                        echo "服务器JDK环境-开始重启"
                        ;;

                    *)

                    ;;
                esac

                echo -e "\033[1;33m 关闭历史端口... \033[0m"
                kill -9 `lsof -ti:10087`;
                echo -e "\033[1;33m Redis:10087已关闭 \033[0m"

                kill -9 `lsof -ti:10088`;
                echo -e "\033[1;33m TbedServer:10088已关闭 \033[0m"

                kill -9 `lsof -ti:10089`;
                echo -e "\033[1;33m TbedWeb:10089已关闭 \033[0m"

                echo -e "\033[1;44;32m 准备启动程序环境... \033[0m"

                chmod -R 777 ./stop.sh
                chmod -R 777 ./server/redis
                chmod -R 777 ./bin

                ./bin/startup.sh

                cd server

                ./redis/redis-server ./redis/redis.conf &

                echo -e "\033[1;44;32m Reids runs successfully \033[0m"


                if [ "$ISJDK" = "y" ];then
                    nohup ./jdk1.8.0_202/bin/java -server -Xms256m -Xmx256m -jar Tbed.jar > Tbed-log.out 2>&1 &
                fi
                
                if [ "$ISJDK" = "n" ];then
                    nohup java -server -Xms256m -Xmx256m -jar Tbed.jar > Tbed-log.out 2>&1 &
                fi        

                echo -e "\033[1;44;32m Start command has been executed \033[0m"
                echo -e "\033[1;44;32m Please wait 1-2 minutes to access after startup \033[0m"


        ;;

    *)

    ;;
esac



