﻿//----------------------------------------------------------
//	Liana 3.0 系统JS公用函数库
//
//----------------------------------------------------------

//----------------------------------------------------------
//	函数名：卡号域键盘输入控制函数
//	描述：限制键盘输入，卡号只许输入数字,及功能键（退格[<-]、del[del]、方向键[右]、方向键[左]）
//	示例：<input type="text" name="a" value=""   onKeyDown="inputCardNo();">
//  author : lixuefeng
//  create date: 2005-11-03
//  修改记录：
//  2005-11-04:增加小键盘数字输入功能
//  2005-11-04:屏蔽shift健、ctrl健、alt健
//----------------------------------------------------------
function inputCardNo(){
	if(event.keyCode==9)
	{
		event.returnValue=true;
	}	
	else
	{
		if(event.shiftKey || event.ctrlKey || event.altKey){
			event.returnValue=false;
		}
		if(event.keyCode!=8 && event.keyCode !=37 && event.keyCode !=39 && event.keyCode !=46){
			if(event.keyCode < 48||(event.keyCode > 57 && event.keyCode<96) || event.keyCode>105){
				event.returnValue=false;
			}	
		}
	}	
}

// 得到一个文本框控件的当前光标位置
function getPos(obj){
obj.focus();
var workRange=document.selection.createRange();
obj.select();
var allRange=document.selection.createRange();
workRange.setEndPoint("StartToStart",allRange);
var len=workRange.text.length;
workRange.collapse(false);
workRange.select();
return len;
}
// 设置一个文本框控件的当前光标位置
function setCursor(obj,num){
range=obj.createTextRange();
range.collapse(true);
range.moveStart('character',num);
range.select();
}

//----------------------------------------------------------
//	金额域输入控制函数
//	示例：
//	1.控制金额域只能输入合法的金额数值（不含角分）
//  <input type="text" name="a" value=""  onKeyUp="inputMoney3(this,0)"  onblur="inputMoney(this,0)">
//	2.控制金额域只能输入合法的金额数值（含角分）
//  <input type="text" name="a" value=""  onKeyUp="inputMoney3(this,1)"  onblur="inputMoney(this,1)">
//  注意：在引用本文件前，请确定已经引用了Liana 3.0 系统JS公用函数库 (public.js)
//  author : lixuefeng 
//  date:2005-10-26
//  修改历史：
//  2005-10-29：增加控制光标移动的功能函数，函数inputMoney3(obj,flg)中添加了该控制。
//  由<input type="text" name="a" value=""  onKeyUp="inputMoney(this,1)"  onblur="inputMoney(this,1)">
//  改为:
//  <input type="text" name="a" value=""  onKeyUp="inputMoney3(this,1)"  onblur="inputMoney(this,1)">
//  可消除光标不能通过键盘移动的bug和不能在金额中间连续输入数字的bug
//  2005-11-08：控制整数位不大于12位。
//----------------------------------------------------------

//----------------------------------------------------------
//	检查变量是否是合法的金额
//	返回值：
//	true：	合法
//	false：	不合法
//----------------------------------------------------------
function moneyCheck(str) { 
	var length1 , i , j;
	var string1="";  
	str = javaTrim(str);
	string1=str;
	length1 = string1.length;	
	if (str.charAt(0)=="0" ){
		if (length1 == 2){
			if (!(str.charAt(1)==".")){
		        //alert("金额首位不能为0，请重新填写！");
		        return(false);
		    }
		}
    }
    if(str.charAt(0)==".")
    return false;
	j=0;
	for (i = 0 ; i < length1 ; i++) {  //判断每位数字
		if(isNaN(parseInt(str.charAt(i),10)))  {
			if(str.charAt(i) != "."){
				return(false); 
			} 
			else{
				j++;
				if(length1 - i > 3 ){
					return(false);}
				}
 		}		
	}
	if(j > 1) {
		return(false);
	}
	if(str.length>12 ){//判断整数位是否大于12位
		var intlen = str.indexOf(".");
		if(intlen<0 || intlen>12){
			return (false);
		}
	}
	
	return (true);
}

//----------------------------------------------------------
//	控制输入域只能输入金额如1.00、1.0、1等
//	变量：obj -输入域对象；flg - 是否允许输入角分（0：不允许；1：允许）
//	返回值：
//----------------------------------------------------------
var strLast = "";//上次输入的字符串
var strNow	= "";//本次输入的字符串
function inputMoney(obj,flg){
	//var pos = getPos(obj);
	strNow = obj.value;
	var isIntChar = "";
	if(flg==0){
		isIntChar = RegExp(/^[0-9]+$/);
	}
	else {
		isIntChar = RegExp(/^[.0-9]+$/);
	}
	if(strNow.length>0 && !isIntChar.test(strNow))
	{
		obj.value=strLast;
		//setCursor(obj,pos-1);
		return;
	}
	if(!moneyCheck(strNow)){
		obj.value=strLast;
		//setCursor(obj,pos-1);
		return;
	}
	obj.value=strNow;
	/*
	var num ;
	if(strNow.length-strLast.length>0){
		num=pos + strNow.length-strLast.length-1;
	}	
	else{
		num=pos;
	}
	setCursor(obj,num);
	*/
	strLast = strNow;
}


function inputMoney3(obj,flg){
	var pos = getPos(obj);
	strNow = obj.value;
	var isIntChar = "";
	if(flg==0){
		isIntChar = RegExp(/^[0-9]+$/);
	}
	else {
		isIntChar = RegExp(/^[.0-9]+$/);
	}
	if(strNow.length>0 && !isIntChar.test(strNow))
	{
		obj.value=strLast;
		setCursor(obj,pos-1);
		return;
	}
	if(!moneyCheck(strNow)){
		obj.value=strLast;
		setCursor(obj,pos-1);
		return;
	}
	obj.value=strNow;
	
	var num ;
	if(strNow.length-strLast.length>0){
		num=pos + strNow.length-strLast.length-1;
	}	
	else{
		num=pos;
	}
	setCursor(obj,num);
	
	strLast = strNow;
}




//----------------------------------------------------------
//	检查变量是否是浮点数
//	返回值：
//	true：	是浮点数
//	false：	不是浮点数
//----------------------------------------------------------
function isDecimal( s )
{
	var isDecimal = RegExp(/^([0-9]+(\.?))?[0-9]+$/);
	return ( isDecimal.test(s) );
}


//----------------------------------------------------------
//	判断输入的是不是数字或者字母
//	输入：theStr 为字符串
//	返回值：true：是false：不是
//----------------------------------------------------------
function isIntChar( s )
{
 	var isIntChar = RegExp(/^[a-zA-Z0-9]+$/);
	return ( isIntChar.test(s) );
 }
 //----------------------------------------------------------
//	判断输入的是否包含字母
//	输入：theStr 为字符串
//	返回值：true：是false：不是
//----------------------------------------------------------
function isChar( s )
{
 	var isIntChar = RegExp(/^[a-zA-Z]+$/);
	return ( isIntChar.test(s) );
 }
 //----------------------------------------------------------
//	判断输入的是不是数字或者字母或者特殊字符
//	输入：theStr 为字符串
//	返回值：true：是false：不是
//----------------------------------------------------------
function isIntChar2( s )
{
	var isIntChar2 = RegExp(/^[a-zA-Z0-9(\_)(\-)(\*)(\&)(\%)(\$)(\#)(\@)(\!)(\~)(\^)(\()(\))]+$/);
	return ( isIntChar2.test(s) );
}
/**
*判断是否合法昵称（登录名）
**/
function isLegalNickName(s)
{
	var isNickName = RegExp(/^[a-zA-Z0-9(\_)]+$/);
	return ( isNickName.test(s) );
}
 
//----------------------------------------------------------
//	对数据域重新进行编码
//	输入：数据域
//	返回值：
//	编码后的数据域
//----------------------------------------------------------
function encode(s)
{
	if(s == null ) 
		return s;
	if(s.length == 0) 
		return s;
	
	var ret = "";
	for(i=0;i<s.length;i++)
	{
		var c = s.substr(i,1);
		var ts = escape(c);
		if(ts.substring(0,2) == "%u") 
		{
			ret = ret + ts.replace("%u","@@");
		} else {
			ret = ret + c;
		}
	}
	return ret;
}

//----------------------------------------------------------
//	检验账号合法性
//	输入：账号的字符串
//	返回值：
//	true：账号合法
//	false：账号不合法
//----------------------------------------------------------
function validateAccount(account,length) 
{
	if( isEmpty(account) )
	{
		alert("账号不能为空！");
		return false;
	}
	
	if( !isInteger(account) )
	{
		alert("账号必须为数字！");
		return false;
	}
	
	if( isShorter(account,length) )
	{
		alert("账号长度为"+length+"位！");
		return false;
	}	
	
	return true;
}

//----------------------------------------------------------
//	百分率格式化
//	输入：0～100间的字符串
//	返回值：
//	格式化后的字符串
//----------------------------------------------------------
function getFmtRate(str) 
{
	var rate = parseInt(str);
	
	if ( rate > 100 || rate < 0 )
		return("-1");
	
	return (rate/100);
}

//----------------------------------------------------------
//	检查变量是否为空
//	返回值：
//	true：为空
//	false：不为空
//----------------------------------------------------------
function isEmpty(e)
{
	if( trim(e) == "" )
		return true;
	else
		return false;
}

//----------------------------------------------------------
// 	去掉字符串前后的空格
//	返回值：
//	去除空格后的字符串
//----------------------------------------------------------
function trim(param) {
	if ((vRet = param) == '') { return vRet; }
	while (true) {
		if (vRet.indexOf (' ') == 0) {
			vRet = vRet.substring(1, parseInt(vRet.length));
		} else if ((parseInt(vRet.length) != 0) && (vRet.lastIndexOf (' ') == parseInt(vRet.length) - 1)) {
			vRet = vRet.substring(0, parseInt(vRet.length) - 1);
		} else {
			return vRet;
		}
	}
}

//----------------------------------------------------------
// 	检查输入文本框中是否包含“|”或“#”非法字符
//	返回值：
//	true：	合法
//	false：	非法
//----------------------------------------------------------
function isValidText(param) {
	if ((param.indexOf('|') >= 0) || (param.indexOf('#') >= 0) ) {
		//alert("“|”和“#”为系统保留字符，请不要输入！");
		return false;
	}
	return true;
}

//----------------------------------------------------------
//	检查变量的长度比给出的长度短
//	返回值：
//	true：	变量长度<给出的长度
//	false：	变量长度>=给出的长度
//----------------------------------------------------------

function isShorter(str,reqlength)
{
	if( str.length<reqlength )
		return true;
	else
		return false;
}

//----------------------------------------------------------
//	检查变量是否是整数
//	返回值：
//	true：	是整数
//	false：	不是整数
//----------------------------------------------------------
function isInteger( s )
{ 
	var isInteger = RegExp(/^[0-9]+$/);
	return ( isInteger.test(s) );
}

//----------------------------------------------------------
//	检验金额
//	返回值：
//	true：	合法
//	false：	非法
//----------------------------------------------------------
function isMoney(param) {
	if ((isNaN(param)) || (parseFloat(param) < 0) || (param.indexOf('.') == 0) || (param.lastIndexOf('.') == param.length - 1)) {
		return false;
	}
	//不支持科学计数
	if(param.indexOf('e') > 0) {
		return false;
	}
	//小数点后最多只允许保留两位有效数字	
	var docIndex = trim(param).lastIndexOf('.');
	if ((docIndex < parseInt(trim(param).length) - 3) && (docIndex >= 0)) {
		return false;
	}
	if (param.charAt(0)=="0" )
	{		  	  	
	  	if (!(param.charAt(1)=="."))
	  	{	  	
				return false;
		}						
	}
	return true;
}

//----------------------------------------------------------
//	检验价格
//	返回值：
//	true：	合法
//	false：	非法
//----------------------------------------------------------
function isPrice(param) {
	if ((isNaN(param)) || (parseFloat(param) < 0) || (param.indexOf('.') == 0) || (param.lastIndexOf('.') == param.length - 1)) {
		return false;
	}
	//不支持科学计数
	if(param.indexOf('e') > 0) {
		return false;
	}
	//小数点后最多只允许保留四位有效数字	
	var docIndex = trim(param).lastIndexOf('.');
	if ((docIndex < parseInt(trim(param).length) - 5) && (docIndex >= 0)) {
		return false;
	}
	return true;
}

//----------------------------------------------------------
// 	检验日期是否符合YYYYMMDD的格式
//	返回值：
//	true：	日期合法
//	false：	日期不合法
//----------------------------------------------------------
function isDate(param) {
	var pattern = /^\d+$/;
	if ( param.length != 8 ) {
		return false;
	}
	if(!pattern.test(param)) {
		return false;
	}
	sYear = param.substring( 0, 4 );
	sMonth = param.substring( 4, 6 );
	sDay = param.substring( 6, 8 );
	if ( ( eval( sMonth ) < 1 ) || ( eval( sMonth )  > 12 ) ) {
		return false;
	}
	var leapYear = ((( sYear % 4 == 0 ) && ( sYear % 100 != 0 )) || ( sYear % 400 == 0 )) ? true : false;
	var monthDay = new Array(12);
	monthDay[0] = 31;
	monthDay[1] = leapYear ? 29 : 28;
	monthDay[2] = 31;
	monthDay[3] = 30;
	monthDay[4] = 31;
	monthDay[5] = 30;
	monthDay[6] = 31;
	monthDay[7] = 31;
	monthDay[8] = 30;
	monthDay[9] = 31;
	monthDay[10] = 30;
	monthDay[11] = 31;
	if ( ( eval( sDay ) < 1 ) || ( eval( sDay )  > monthDay[eval(sMonth)-1] ) ) {
		return false;
	}
	return true;
}

//----------------------------------------------------------
// 	检查email合法性
//	返回值：
//	true：	合法
//	false：	不合法
//----------------------------------------------------------
function isEmail(aEmail) {
	var bValidate = RegExp(/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/).test(aEmail);
	
	if ( bValidate )
	{
		return true;
	}
	else
		return false;
}

//----------------------------------------------------------
//	选中某个数据域
//----------------------------------------------------------
function makeFocus(txtObject) {
	txtObject.focus();
	txtObject.select();
}

//----------------------------------------------------------
//	金额格式化
//	返回值：
//	格式化后的字符串
//----------------------------------------------------------
function toFmtMoney(str) {
	var subAmt = trim(str);
	if((subAmt.indexOf(".") == -1)||(subAmt.length == 1)) {
		subAmt = subAmt + ".00";
	}
	if(subAmt.indexOf(".") == (subAmt.length - 2)) {
		subAmt = subAmt + "0";
	}
	if(subAmt.indexOf(".") < (subAmt.length - 3)){
		subAmt = subAmt.substr(0, subAmt.indexOf(".") + 3);
	}
	return (subAmt);
}

//----------------------------------------------------------
//	限制键盘输入，只许输入数字
//----------------------------------------------------------
function inputNumber(){
	if(event.keyCode < 48||event.keyCode > 57){
		event.returnValue=false;
	}		
}

function disable_Button(name){
	name.disabled=1
}

function reload(name1){	
	name1.reset();
}


//----------------------------------------------------------
//控制text域的最大输入长度
//用法：onblur="checkLength(this,要控制的长度);",
//----------------------------------------------------------
function checkLength(v,l){
 var s = v.value;
 var len = 0;
   for(i=0;i<s.length;i++){
     var c = s.substr(i,1);
     var ts = escape(c);
     if(ts.substring(0,2) == "%u") {
      len+=2;
     } else {
      len+=1;
     }
   }
   if(l>=len){
     return;
   }
   else{
	var aaa=Math.floor(l/2);
	alert("该输入项插入值过长！最多"+l+"个字符或"+aaa+"个汉字。");
    v.value = "";
    v.focus();
   }
}

//----------------------------------------------------------
//控制textarea域的最大输入长度
//用法：onblur="checkAreaLength(this,要控制的长度);"
//----------------------------------------------------------
function checkAreaLength(v,l){
 var s= v.value;
 var temlen=0;
 var len = 0;
 for(i=0;i<s.length;i++){
     var c = s.substr(i,1);
     var ts = escape(c);

     if(ts.substring(0,2) == "%u"){
      len+=2;
      len+=temlen;
      temlen=0;
     }
     else if(ts.substring(0,3) == "%0D"){
      temlen+=1;
     }
     else if(ts.substring(0,3) == "%0A"){
         temlen+=1;
     }
     else if(ts.substring(0,3) == "%20"){
      temlen+=1;
     }
      else{
      len+=1;
      len+=temlen;
      temlen=0;
     }
   }
  if(len>l){
	var aaa=Math.floor(l/2);
	alert("该输入项插入值过长！最多"+l+"个字符或"+aaa+"个汉字。");  	
    v.value = "";
    v.focus();
    return false;
  }
  return true;
}

//----------------------------------------------------------
//	通用打印
//----------------------------------------------------------
function commonprint(title,divId,cardNo,branchName,width,height){
	//alert("HELLO");
	var sarg=new Array();
	var sdata=document.all.item(divId);
	sarg[0]=title;
	text = sdata.outerHTML;
	text = text.replace(/border=[^[1|\s]]*([\s|>])/ig,"border=1 style='border-collapse:collapse' bordercolor='#000000'$1");
	text = text.replace(/cellSpacing=[^[0|\s]]*([\s|>])/ig,"$1");
	text = text.replace(/cellPadding=[^[0|\s]]*([\s|>])/ig,"$1");
	text = text.replace(/<TABLE/ig,"<TABLE cellSpacing=0 cellPadding=0");
	
	sarg[1]=text;
	sarg[2]=cardNo;
	sarg[3]=branchName;
	//alert(test);
	//alert(sarg[1]);
	window.showModalDialog("print.jsp",sarg,"dialogWidth:"+width+"px;dialogHeight:"+height+"px;center:yes;help:no;status:no;resizable:yes");
	return;
}

//----------------------------------------------------------
//	对金额进行转换，将金额转换为以元为单位，小数点后有两位
//	例：输入域1234，转换后隐含域为1234.00
//	Creation date: (2003-09-12)	
//	@author: ecc-wangdong
//	@version: 1.0
//	@param：form, txtmoney, hidmoney
//	@param说明：
//              FORM名，表现域名称，隐藏域名称
//	@condition：该表现域已赋初值	
//----------------------------------------------------------
function convertToMoney(form,txtmoney,hidmoney){
    var tonumber;
    var re = /,/g;
    var txt_money = eval("document."+form+"."+txtmoney);
    var hid_money = eval("document."+form+"."+hidmoney);
    if (txt_money.value != ""){
    	var temp = trim(txt_money.value);
    	if (temp == ""){
    		alert("请输入正确的金额!");
    		txt_money.value="";
				hid_money.value="";
				txt_money.focus();
    		return;
    	}
    }
    tonumber = txt_money.value.replace(re,"");

    txt_money.value = "";
    hid_money.value = "";
   if (tonumber !="" && tonumber!=null){
   	rep = / /g;
		var amt = tonumber.replace(rep,"");
		
		for(var j = 0; j < amt.length; j++){
			if(isNaN(parseInt(amt.charAt(j),10)) && amt.charAt(j)!="," && amt.charAt(j)!=".") {
				alert("请输入正确的金额!");
				txt_money.value="";
				hid_money.value="";
				txt_money.focus();
				return;
			}
		}
		if(amt.indexOf(".")!=amt.lastIndexOf(".")){
			alert("请输入正确的金额!");
			txt_money.focus();
			return;
		}
	
		re = /,/g;
		var amt1 = amt.replace(re,"");

		var amt2=parseFloat(amt1);		
		if(amt2<=0){
			alert("输入的金额小于或等于零,请重新输入!");
			txt_money.focus();
			return;
		}else{		//大于0的正数;
			if(amt1.indexOf(".")!=-1){				
				var str = amt1.substr(amt1.indexOf(".")+1);				
				if(str.length>2){
					alert("输入的金额小数点后只能保留两位,请重新输入!");
					txt_money.focus();
					return;
				}else if(str.length==1){
					amt1=amt1 + "0";
				}else if(str.length<1){
					amt1=amt1 + "00";
				}
			}else{
				amt1=amt1 + ".00";
			}
			if(amt1.charAt(0)=='0' && amt1.indexOf(".")!=1){
			alert("请输入正确的金额!");
			txt_money.focus();
			return;
			}
			hid_money.value=amt1;
			var temp=amt1.substring(0,amt1.indexOf("."));
			if (temp.length > 10){
			    alert("输入的金额太大，请重新输入!");
			    txt_money.focus();
			    return;
			}
			txt_money.value=comma(temp) + amt1.substring(amt1.indexOf("."));
			return;							
		}
    }
}

//----------------------------------------------------------
//	对金额进行转换，将金额转换为以分为单位
//	Creation date: (2003-09-12)	
//	@author: ecc-wangdong
//	@version: 1.0
//	@param：form, txtmoney, hidmoney
//	@param说明：
//              FORM名，表现域名称，隐藏域名称
//	@condition：该表现域已赋初值	
//----------------------------------------------------------
function convertToMoney2(form,txtmoney,hidmoney){
    var tonumber;
    var re = /,/g;
    var txt_money = eval("document."+form+"."+txtmoney);
    var hid_money = eval("document."+form+"."+hidmoney);
    tonumber = txt_money.value.replace(re,"");

    txt_money.value = "";
    if (tonumber !="" && tonumber!=null){
   	rep = / /g;
		var amt = tonumber.replace(rep,"");
		
		for(var j = 0; j < amt.length; j++){
			if(isNaN(parseInt(amt.charAt(j),10)) && amt.charAt(j)!="," && amt.charAt(j)!=".") {
				alert("请输入正确的金额!");
				txt_money.value="";
				txt_money.focus();
				return;
			}
		}
		if(amt.indexOf(".")!=amt.lastIndexOf(".")){
			alert("请输入正确的金额!");
			txt_money.focus();
			return;
		}
	
		re = /,/g;
		var amt1 = amt.replace(re,"");

		var amt2=parseFloat(amt1);		
		if(amt2<0){
			alert("输入的金额小于零,请重新输入!");
			txt_money.focus();
			return;
		}else{		//大于0的正数;
			if(amt1.indexOf(".")!=-1){				
				var str = amt1.substr(amt1.indexOf(".")+1);				
				if(str.length>2){
					alert("输入的金额小数点后只能保留两位,请重新输入!");
					txt_money.focus();
					return;
				}else if(str.length==1){
					amt1=amt1 + "0";
				}else if(str.length<1){
					amt1=amt1 + "00";
				}
			}else{
				amt1=amt1 + ".00";
			}
			if(amt1.charAt(0)=='0' && amt1.indexOf(".")!=1){
			alert("请输入正确的金额!");
			txt_money.focus();
			return;
			}
			hid_money.value=amt1.substring(0,amt1.indexOf(".")) + amt1.substr(amt1.indexOf(".")+1);
			var temp=amt1.substring(0,amt1.indexOf("."));
			if (hid_money.value.length > 18){
			    alert("金额太大");
			    txt_money.focus();
			    return;
			}
			txt_money.value=comma(temp) + amt1.substring(amt1.indexOf("."));
			return;							
		}
    }
}

//---------------------------------------------------------------------------
//	表现形式增加逗号，只对整数部分做处理，由上一个函数调用。
//	Creation date: (2003-09-12)	
//	@author: ecc-handong
//	@version: 1.0
//	@param：number
//	@param说明：需转换数值	
//---------------------------------------------------------------------------

function comma(number) {
	number = '' + number;
	if (number.length > 3) {
		var mod = number.length % 3;
		var output = (mod > 0 ? (number.substring(0,mod)) : '');
		for (i=0 ; i < Math.floor(number.length / 3); i++) {
			if ((mod == 0) && (i == 0))
				output += number.substring(mod+ 3 * i, mod + 3 * i + 3);
			else
				output += ',' + number.substring(mod + 3 * i, mod + 3 * i + 3);
		}
		return (output);
	}
	else return number;
}

//---------------------------------------------------------------------------
//	表现形式增加逗号，这个可作为单独使用。
//	Creation date: (2003-09-12)	
//	@author: ecc-wangdong,handong
//	@version: 1.0
//	@param：number
//	@param说明：
//              需转换数值	
//---------------------------------------------------------------------------
function displayComma(str) {
	str = '' + str;
	if ((str.indexOf("."))!= -1){
		str1 = str.substring(0,str.indexOf("."));
		str2 = str.substring(str.indexOf("."));
	}else{
		str1 = str;
	}
	if (str1.length > 3) {
		var mod = str1.length % 3;
		var output = (mod > 0 ? (str1.substring(0,mod)) : '');
		for (i=0 ; i < Math.floor(str1.length / 3); i++) {
			if ((mod == 0) && (i == 0))
				output += str1.substring(mod+ 3 * i, mod + 3 * i + 3);
			else
				output += ',' + str1.substring(mod + 3 * i, mod + 3 * i + 3);
		}
		if ((str.indexOf("."))!= -1){
			output = output + str2;
		}
		return (output);
	}
	else return str;
}


//----------------------------------------------------------
//	生成Excel文件并保存
//	输入参数：
//	formName：要生成的数据所在的form名称
//	tableName：要生成的数据所在的table名称
//----------------------------------------------------------
function exportexcel(formName,tableName){
      	var oXL = new ActiveXObject("Excel.Application");
      	oXL.Visible = true;
      	var oWB = oXL.Workbooks.Add();
      	var oSheet = oWB.ActiveSheet;
      
      	var div1=document.all.item(formName);
      	var table1=div1.all.item(tableName);
      	var table=new Array();

	var retArr = getTableRowsCols(table1);
      	var rlen=retArr[0];
      	var clen=retArr[1];
	
      	var flagTable=new Array(rlen);
      	for(var i=0;i<rlen;i++){
      		flagTable[i]=new Array(clen);
      		for(var j=0;j<clen;j++){
      			flagTable[i][j]=0;
      		}
      	}

	var rowBegin=1, colBegin=1;		//导出的表格的起始位置
	
      	var c1=oSheet.Cells(rowBegin,colBegin);
      	var c2=oSheet.Cells(rlen+rowBegin-1,clen+colBegin-1);
      	oSheet.Range(c1,c2).VerticalAlignment = -4108;
      	oSheet.Range(c1,c2).HorizontalAlignment =  -4108;
      	
  	exportTable(oSheet, flagTable, table1, rowBegin, colBegin);    	
    	      	
       	oSheet.Range(oSheet.Cells(rowBegin,colBegin),oSheet.Cells(rlen+rowBegin-1,clen+colBegin-1)).EntireColumn.AutoFit();
      	oXL.UserControl = true;
      	oXL.Quit();
}

//返回当前表格的行数和列数
//参数：objTable, 表格对象
//返回：retArr, retArr[0], 行数；retArr[1], 列数
function getTableRowsCols(objTable)
{
	var rowCnt=0, colCnt=0;
	for (var i=0; i<objTable.rows.length; i++) {
		var row = objTable.rows[i];	//当前行
		var rowRows=1, rowCols=0;	//当前行的初始行数和列数
		for (var j=0; j<row.cells.length; j++) {
			var cell = row.cells[j];	//当前单元格
			if (cell.firstChild !=null && cell.firstChild.tagName == "TABLE") {
				var inRetArr = getTableRowsCols(cell.firstChild);
				rowCols +=inRetArr [1];
				rowRows = rowRows<inRetArr[0] ? inRetArr[0] : rowRows;
			} else {	//不是表格
				rowCols += parseInt(cell.colSpan);
				rowRows = rowRows<parseInt(cell.rowSpan) ? parseInt(cell.rowSpan) : rowRows;
			}
		}
		colCnt = colCnt<rowCols ? rowCols : colCnt;
		rowCnt += rowRows;
	}
	var retArr = new Array();
	retArr[0] = rowCnt;
	retArr[1] = colCnt;
	
	return retArr;
}

//导出表格
function exportTable(oSheet, flagTable, objTable, rowBegin, colBegin){
	var flagRow=0, flagCol=0;		//跟踪当前的表示表中的相对位置
	for(var i=0; i<objTable.rows.length; i++) {
		var row = objTable.rows[i];	//当前行
		flagCol = 0;
		var subTableRows = 1;		//当前行若有表格，则记录其中最大的行数
		for (var j=0; j<row.cells.length; j++) {
			while (flagTable[rowBegin-1+flagRow][colBegin-1+flagCol]==1) {
				flagCol++;
			}
			var cell=row.cells[j];	//当前单元格
			if (cell.firstChild !=null && cell.firstChild.tagName == "TABLE") {
				var retArrRows = getTableRowsCols(cell.firstChild)[0];
				subTableRows = subTableRows<retArrRows ? retArrRows : subTableRows;
				exportTable(oSheet, flagTable, cell.firstChild, rowBegin+flagRow, colBegin+flagCol);
			} else {
				
				oSheet.Cells(rowBegin+flagRow, colBegin+flagCol).Font.Bold=1;
	               	 				
				var rs=parseInt(cell.rowSpan);
	               	 	var cs=parseInt(cell.colSpan);
	               	 	oSheet.Cells(rowBegin+flagRow, colBegin+flagCol).NumberFormatLocal="@";
	               	 	oSheet.Cells(rowBegin+flagRow, colBegin+flagCol).Value = cell.innerText;
	               	 	oSheet.Range(oSheet.Cells(rowBegin+flagRow, colBegin+flagCol),oSheet.Cells(rowBegin+flagRow+rs-1,colBegin+flagCol+cs-1)).MergeCells = 1;  
				
				//填写当前单元格在标志表格中的标志
				for(var k=0; k<rs; k++) {
					for(var l=0; l<cs; l++) {
						flagTable[rowBegin-1+flagRow+k][colBegin-1+flagCol+l]=1;
					}
				}
			}
				
			flagCol =flagCol + cs - 1;	//加速标志表格的列的移动，因为当前表格已经标识了cs个标志单元  			              		
		}
		flagRow += subTableRows;
	}	
}

//----------------------------------------------------------
//	图片控制函数
//----------------------------------------------------------
function MM_swapImgRestore() { //v3.0
  var i,x,a=document.MM_sr; for(i=0;a&&i<a.length&&(x=a[i])&&x.oSrc;i++) x.src=x.oSrc;
}

function MM_preloadImages() { //v3.0
  var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
    var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i<a.length; i++)
    if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
}

function MM_findObj(n, d) { //v4.0
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && document.getElementById) x=document.getElementById(n); return x;
}

function MM_swapImage() { //v3.0
  var i,j=0,x,a=MM_swapImage.arguments; document.MM_sr=new Array; for(i=0;i<(a.length-2);i+=3)
   if ((x=MM_findObj(a[i]))!=null){document.MM_sr[j++]=x; if(!x.oSrc) x.oSrc=x.src; x.src=a[i+2];}
}

//-----------------------------
//	检查时间间隔是否在规定间隔之内
//	输入：
//	startDate/endDate为YYYYMMDD型日期字符串
//	interval：间隔，单位为天
//	返回：true 符合要求
//	false 不符合要求
//-----------------------------
function dateInterval(startDate,endDate,interval) {
	var date1 = new Date(eval(startDate.substring(0,4)),eval(startDate.substring(4,6))-1,eval(startDate.substring(6,8)));
	var date2 = new Date(eval(endDate.substring(0,4)),eval(endDate.substring(4,6))-1,eval(endDate.substring(6,8)));
	if ( ( date2 - date1 ) / 86400000 > eval(interval) - 1 )
		return false;
	return true;
}

//-----------------------------
//	返回对话框中的文件路径
//-----------------------------
function getFilePath(filespec)
{
	oldSpec=filespec;
	index=filespec.indexOf("\\");
	while(index>=0)
    {
    	if(filespec.length>index)
		filespec=filespec.substring(index+1);
		index=filespec.indexOf("\\");
	}
	index=filespec.indexOf("/");
	while(index>=0)
    {
		if(filespec.length>index)
		filespec=filespec.substring(index+1);
		index=filespec.indexOf("/");
	}
	index=oldSpec.indexOf(filespec);
	return oldSpec.substring(0,index);
}

var debug = 0;
/**
*   发送xml请求
*   url: url
*   method: Post or Get
*   retType: xml or html
**/
function sendXMLHttpRquest(url, method, retType)
{
	var objHTTP = null;
	if(window.ActiveXObject){
		objHTTP=new ActiveXObject("Microsoft.XMLHTTP");
	} else {
	  	objHTTP=new XMLHttpRequest();
	}
	objHTTP.open(method, url, false);
	objHTTP.send();
	var resText = objHTTP.responseText;
	objHTTP = null;
	if (debug > 0)
	{
		if (debug > 4)
			document.write(resText);
		else
			alert(resText);
	}
	if (retType == "html")
		return resText;

	if(resText.toLowerCase().indexOf("<html>")!=-1)
	{
		document.write(resText);
		document.write("<script>window.reload;</script>");
		return null;
	}
	return resText;
}
/**
*   发送xml请求
*   url: url
*   method: Post or Get
*   retType: xml or html
**/
function sendXMLHttpRquestNoWait(url, method, retType)
{
	var objHTTP = new ActiveXObject("Microsoft.XMLHTTP");
	objHTTP.Open(method, url, true);
	objHTTP.Send();
	var resText = objHTTP.responseText;
	objHTTP = null;
	if (debug > 0)
	{
		if (debug > 4)
			document.write(resText);
		else
			alert(resText);
	}
	if (retType == "html")
		return resText;

	if(resText.toLowerCase().indexOf("<html>")!=-1)
	{
		document.write(resText);
		document.write("<script>window.reload;</script>");
		return null;
	}
	return resText;
}
/**
*   获取xml中指定数据域的数据
*   xml:xml
*   name:String
*/
function getValueFromXML(xml, name)
{
	var value = null;
	var tmp_xml = xml;
	var tmp_name = name;
	var k = null;
	try {
		while((k = tmp_name.indexOf(".")) != -1)
		{
			var name_tmp = tmp_name.substring(0,k);
			tmp_name = tmp_name.substring(k+1);
			var i_tmp = tmp_xml.indexOf("<"+name_tmp+">");
			var j_tmp = tmp_xml.indexOf("</"+name_tmp+">");
			tmp_xml = tmp_xml.substring(i_tmp+name_tmp.length+2,j_tmp);
		}
		var i = tmp_xml.indexOf("<"+tmp_name+">");
		var j = tmp_xml.indexOf("</"+tmp_name+">");
		value = trim(tmp_xml.substring(i+tmp_name.length+2,j));
		if(value!=null && value.indexOf("![CDATA") != -1)
		{
			value = trim(value.substring(value.lastIndexOf("[")+1,value.indexOf("]")));
		}
	} catch(Exception)
	{
		value = null;
	}
	return value;
}

function isExRate(rate)
{

	if (rate == "")
		return false;
	for (var j = 0; j < rate.length; j++) {
		if (isNaN(parseInt(rate.charAt(j), 10)) && rate.charAt(j) != ".") {
			return false;
		}
	}
	if(rate.indexOf(".")!=rate.lastIndexOf(".") || rate.lastIndexOf(".")==rate.length-1){
		return false;
	}
	if(rate.indexOf(".")!=-1 && rate.substring(rate.indexOf(".")+1).length>4)//小数点后面只能有四位
	{
		return false;
	}
	if((rate * 1 <=0)||(rate * 1 >= 100000))    //汇率必须大于0 汇率必须小于100000.
		return false;
	if (rate.charAt(0)=="0" )
	{		  	  	
	  	if (!(rate.charAt(1)=="."))
	  	{	  	
				return false;
		}						
	}
	return true;
}
/**
*   判断美元-日元挂盘汇率输入是否合法
**/
function isLegalUSDJPYExRate(rate)
{
	if(!isExRate(rate))
		return false;
	if(rate.indexOf(".")!=-1 && rate.substring(rate.indexOf(".")+1).length>2)//小数点后面只能有2位
	{
		return false;
	}
	return true;

}


//判断数值,是否为浮点数
function MycheckFloat(str) { 
	var length1 , i , j;
	var string1="";
   
  
    str = javaTrim(str);
    string1=str;
	length1 = string1.length;
	if (length1 == 0) 
	{
		alert( "错误！空串！");
		return(false); 
	}
   if (str.charAt(0)=="0" )
   {
      	if (length1 == 1)
      	{
	        alert("金额不能为0，请重新填写！");
	        return(false);
        }
      	else
      	{
      		if (!(str.charAt(1)=="."))
      		{
		        alert("金额首位不能为0，请重新填写！");
		        return(false);
		    }
		}
    }
    if(str.charAt(0)==".")
    return false;
	j=0;
	for (i = 0 ; i < length1 ; i++) {  //判断每位数字
		if(isNaN(parseInt(str.charAt(i),10)))  {
			if(str.charAt(i) != ".")  {
				//alert( "错误！请输入数值型数据！");					
				return(false); 
			} else  {j++;
			if(length1 - i > 3 ){
			//alert("小数点后只能有两位！");
			 return(false);}
			  }
 		}		
	}
	if(j > 1) {
		//alert( "错误！小数点只能有一个!");			
		return(false);
	}

	return (true);
}
//判断数值,是否为浮点数
function checkFloat(string) { 
	var length1 , i , j;
	var string1="";
   
  
    string1 = javaTrim(string)
	length1 = string1.length;
	if (length1 == 0) 
	{
		alert( "错误！空串！");
		return(false); 
	}
       if (string.charAt(0)=="0" )
	      {if (length1 == 1){
	        alert("金额不能为0，请重新填写！");
	        return(false);
	      }
	      else{
	      if (!(string.charAt(1)==".")){
	        alert("金额首位不能为0，请重新填写！");
	        return(false);}
		}
	      }
	j=0;
	for (i = 0 ; i < length1 ; i++) {  //判断每位数字
		if(isNaN(parseInt(string.charAt(i),10)))  {
			if(string.charAt(i) != ".")  {
				alert( "错误！请输入数值型数据！");					
				return(false); 
			} else  {j++;
			if(length1 - i > 3 ){
			alert("小数点后只能有两位！");
			 return(false);}
			  }
 		}		
	}
	if(j > 1) {
		alert( "错误！小数点只能有一个!");			
		return(false);
	}

	return (true);
}
//**************去掉字符串前后的空格************
function javaTrim(string){
	var length1, i, j;
	var string1 = "";
	
	length1 = string.length;
	for (i = 0 ; i < length1 ; i++)	{
		if(string.charAt(i) != " ")	{
			for (j = i ; j < length1 ; j++) 
				string1 = string1 + string.charAt(j);
				break;
		}
	}	
	length1 = string1.length;
	string = string1;
	string1 = "";
	for (i = length1 - 1 ; i >= 0 ; i--) {
		if(string.charAt(i) != " ") {
			for (j = 0 ; j <= i ; j++) 
				string1 = string1 + string.charAt(j);
				break;	
		}
	}
	string = string1;	
	return(string)	
}

//**************转换大写金额************
var aNum = new Array(10);
aNum[0] = "%u96F6";  //零
aNum[1] = "%u58F9";  //壹
aNum[2] = "%u8d30";  //贰
aNum[3] = "%u53c1";  //叁
aNum[4] = "%u8086";  //肆
aNum[5] = "%u4F0D";  //伍
aNum[6] = "%u9646";  //陆
aNum[7] = "%u67D2";  //柒
aNum[8] = "%u634C";  //捌
aNum[9] = "%u7396";  //玖

var HUNDREDMILLION = 0
var TENTHOUSAND = 1;
var THOUSAND = 2;
var HUNDRED = 3;
var TEN = 4;
var YUAN = 5;
var JIAO = 6;
var CENT = 7;
var ZHENG = 8;
var aUnit = new Array(9);
aUnit[HUNDREDMILLION] = "%u4EBF";	//亿
aUnit[TENTHOUSAND] = "%u4E07";		//万
aUnit[THOUSAND] = "%u4EDF";			//仟
aUnit[HUNDRED] = "%u4F70";			//佰
aUnit[TEN] = "%u62FE";				//拾
aUnit[YUAN] = "%u5143";				//元
aUnit[JIAO] = "%u89D2";				//角
aUnit[CENT] = "%u5206";				//分
aUnit[ZHENG] = "%u6574";			//整




function toChineseCash( cash )
{
	var integerCash="";
	var decimalCash="";	
	var integerCNCash = "";
	var decimalCNCash = ""
	var dotIndex = 0;
	var cnCash = "";
	var Cash = "";
	
	Cash = javaTrim( cash );
	if( Cash == null || Cash.length == 0 )
		return cnCash;
		
	if( !checkFloat( Cash ) )
		return cnCash;	
			
	dotIndex = Cash.indexOf('.');
	if( dotIndex != -1 ) {
		integerCash = Cash.substring( 0, dotIndex );
		decimalCash = Cash.substring( dotIndex + 1 );	
	}else {
		integerCash = Cash;
		decimalCash = null;
	}
	
	integerCNCash = filterCharacter( integerCash, '0' );
	if( integerCNCash == null )
		integerCNCash = "";
	else
		integerCNCash = convertIntegerToChineseCash( integerCNCash );
	
	decimalCNCash = convertDecimalToChineseCash( decimalCash, false );
	
	if( decimalCNCash == null || decimalCNCash.length == 0 ){
		if( integerCNCash == null || integerCNCash.length == 0 )
			cnCash = aNum[0] + aUnit[YUAN] + aUnit[ZHENG]; //"零元整"
		else
			cnCash = integerCNCash + aUnit[YUAN] + aUnit[ZHENG]; //"元整"
	}else {
		if( integerCNCash == null || integerCNCash.length == 0 )
			cnCash = decimalCNCash;
		else
			cnCash = integerCNCash + aUnit[YUAN] + decimalCNCash;  //"元"
	}
	return unescape(cnCash);	
}

function filterCharacter( filterString, filterChar )
{
	if( filterString == null || filterString.length == 0 )
	{
		return null;
	}
	
	var i = 0;	
	for( ; i < filterString.length; i++ )
	{
		if( filterString.charAt( i ) != filterChar )
			break;
	}
	
	var ret = filterString.substring( i, filterString.length );
	ret = (ret.length > 0) ? ret : null;
	
	return ret;	
}

function convertIntegerToChineseCash( cash )
{
	var tempCash = "";
	var returnCash = "";
	
	if( cash == null || cash.length == 0 )
		return null;
	
	var totalLen = cash.length;
	var times = ((cash.length % 4) > 0) ? ( Math.floor(cash.length/4) + 1 ) : Math.floor(cash.length/4);	
	var remainder = cash.length % 4;
	var i = 0;	
	for( ; i < times; i++ )
	{
		if( i == 0 && (remainder > 0) ) {
			tempCash = cash.substring( 0, remainder );
		}else {
			if( remainder > 0 )
				tempCash = cash.substring( remainder+(i-1)*4, remainder+i*4 );
			else
				tempCash = cash.substring( i*4, i*4+4 );
		}
		
		tempCash = convert4ToChinese( tempCash, false );
		returnCash += tempCash;
		if( tempCash != null && tempCash.length != 0 ) 
			returnCash += getUnit( times - i );
	}
		
	return returnCash;
}

function convert4ToChinese( cash, bOmitBeginZero )
{
	var i = 0;
	var length = cash.length;
	var bBeginZero = false;
	var bMetZero = false;
	var returnCash = "";	
	
	for( ; i < length; i++ )
	{
		if( i == 0 && bOmitBeginZero && cash.charAt(i) == '0' )
		{
			bBeginZero = true;
			continue;
		}
		if( bBeginZero && cash.charAt(i) == '0' )
			continue;
				
		if( cash.charAt(i) != '0' )	{
			if( bMetZero )
				returnCash += aNum[0]; //"零"
			bMetZero = false;
			returnCash += convert( cash.charAt(i) );
			switch( i + (4-length) )
			{
			case 0:
				returnCash += aUnit[THOUSAND]; //"千"
				break;
			case 1:
				returnCash += aUnit[HUNDRED]; //"佰"
				break;
			case 2:
				returnCash += aUnit[TEN]; //"拾"
				break;
			case 3:
				returnCash += "";
				break;
			default:
				break;				
			}
		}else {
			bMetZero = true;
		}
	}
	
	return returnCash;
}

function getUnit( part )
{
	var returnUnit = "";
	var i = 0;
	
	switch( part )
	{
	case 1:
		returnUnit = "";
		break;
	case 2:
		returnUnit = aUnit[TENTHOUSAND]; // "万"
		break;
	case 3:
		returnUnit = aUnit[HUNDREDMILLION]; //"亿"
		break;
	default:
		if( part > 3 )
		{
			for( ; i < part - 3; i++ )
			{
				returnUnit += aUnit[TENTHOUSAND]; // "万"
			}
			returnUnit += aUnit[HUNDREDMILLION]; //"亿"
		}
			
		break;
	}
	
	return returnUnit;
}

function convert( num )
{
	return aNum[parseInt(num)];
}

function convertDecimalToChineseCash( cash, bOmitBeginZero )
{
	var i = 0;
	var bBeginZero = false;
	var bMetZero = false;
	var returnCash = "";
	
	if( cash == null || cash.length == 0 )
		return returnCash;
		
	
	for( ; i < cash.length; i++ )
	{
		if( i >= 2 )
			break;
		if( i == 0 && bOmitBeginZero && cash.charAt(i) == '0' )
		{
			bBeginZero = true;
			continue;
		}
		if( bBeginZero && cash.charAt(i) == '0' )
			continue;
				
		if( cash.charAt(i) != '0' )	{
			if( bMetZero )
				returnCash += aNum[0]; //"零"
			bMetZero = false;
			returnCash += convert( cash.charAt(i) );
			switch( i )
			{
			case 0:
				returnCash += aUnit[JIAO]; //"角"
				break;
			case 1:
				returnCash += aUnit[CENT]; //"分"
				break;
			default:
				break;				
			}
		}else {
			bMetZero = true;
		}
	}
	
	return returnCash;	
}

//////////add by xushengang //////////

//去掉 ","
function getoff_Qfw(cash){
    var len=cash.length;
    var ch="";
    var newCash="";
    for (var ii=0;ii<len;ii++){
        ch=cash.charAt(ii);
        if (ch!=","){newCash=newCash+ch;}
    }
    return newCash;
}


//加上","
function add_Qfw(cash)
{
    var len=cash.length;
    var cashNew="";//加上","的字符串
    var tt=0;//计数器，每加一个"," tt 加 1 
    var t=0;//添加","的个数
    if(intLen>3)
    	{
    		t=(intLen-intLen%3)/3;
    	}
    else
    	return cash;
    
    //个数部分长度不是3的倍数
    if(intLen%3 !=0)
    {
	    for (var ii=0;ii<len;ii++)
	    {
	       cashNew=cashNew+cash.charAt(ii);
		       if (ii== (intLen%3+3*tt-1) &&  tt<t)
		       {
		        tt=tt+1;
		       	cashNew=cashNew+",";
		       }
	    }
	}
	//个数部分长度是3的倍数
	else
	{
		tt=tt+1;
	    for (var ii=0;ii<len;ii++)
	    {
	       cashNew=cashNew+cash.charAt(ii);
		       if (ii== (3*tt-1) &&  tt<t)
		       {
		        tt=tt+1;
		       	cashNew=cashNew+",";
		       }
	    }	
	
	}
    return cashNew;
}

/******************************************************
// 	 *功能描述:把签名控件写入页面中
// 	 *参数说明：
// 	 *作者：wangtq
// 	 *创建日期：2004-11-13
***************************************************** */ 
	
function writeSignActivxObject(basepath)
{ 	document.write('<div id="infosign" style="display:none">');
	document.write('<OBJECT id=InfoSecNetSign1 style="WIDTH: 0px; HEIGHT: 0px" codeBase='+basepath+'cab/NetSign.cab#version=1,8,23,5 data=DATA:application/x-oleobject;BASE64,xDi5YpBBN0+M8KkrCpHMdwADAABMWQAA/wIAAA== classid=clsid:62B938C4-4190-4F37-8CF0-A92B0A91CC77  VIEWASTEXT width="864" height="29">');
	document.write('</OBJECT>');
	document.write('</div>');

}

//根据前端输入日期和间隔天数，得到另一个日期
//输入参数： intervalday(间隔天数) formname(网页表单名) inputname(表单中的输入对象名)
//输出参数： 新的8位日期
function dateOther(intervalday, formname, inputname,otherDate)
{
	var strdate = 20040101;
    if(otherDate==0){
         var Input = eval("document." + formname + "." + inputname);
         strdate = Input.value;
         
    }else{
         strdate = otherDate;
         
    }
    
    var year = parseInt(strdate.substr(0, 4),10);
    var month = parseInt(strdate.substr(4, 2),10)-1;
    var date = parseInt(strdate.substr(6, 2),10);
    	dateDate = new Date(year,month,date);
	for (var i = 0; i < Math.abs(intervalday); i++)
	{
		if (parseInt(intervalday)>=0)
			dateDate.setTime(dateDate.getTime()+1000*60*60*24);
		else
			dateDate.setTime(dateDate.getTime()-1000*60*60*24);
	}
	var strYear = dateDate.getFullYear(); 
	var strMonth = dateDate.getMonth()+1;
	var strDate = dateDate.getDate();
	if (strMonth<10)
		strMonth="0"+strMonth;
	if (strDate<10)
		strDate="0"+strDate;
	strdate = strYear+""+strMonth+""+strDate;

	//alert(strdate);
	return strdate;
}