
function StageFactory() {
	this.parseStageBunch = parseStageBunch;
	this.parseStage = parseStage;
}

function parseStageBunch(stageBunch) {
	var stageInfoArray = stageBunch.split("|");
	var stageArray = new Array();
	for(i=0; i<stageInfoArray.length; i++) {
		if(stageInfoArray[i] == null || stageInfoArray[i] == "") {continue;}
		stageArray[i]  = this.parseStage(stageInfoArray[i]);
	}
	return stageArray;
}

function parseStage(stageInfo) {
	var stage = new Stage();
	try{
		var stageInfoArray = stageInfo.split("-");
		stage.code = stageInfoArray[0];
		stage.feeRate = stageInfoArray[1];
		stage.percentFeeRate = stageInfoArray[2];
		stage.poundage = stageInfoArray[3];
		stage.principal = stageInfoArray[4];
		stage.flag = stageInfoArray[5];
	}catch(e){
		stage = null;
	}
	return stage;
}

function Stage(code, feeRate, percentFeeRate, poundage, principal, flag) {
	this.code = code;
	this.feeRate = feeRate;
	this.percentFeeRate = percentFeeRate;
	this.poundage = poundage;
	this.principal = principal;
	this.flag = flag;
}

function hideStageDetail() {
	$("#netpayStageDiv").data("checkedStage", null);
	$("#netpayStageDiv").find("input[name='agree']").attr("checked", false);
	$("#netpayStageDiv").find(".stageDetailInfo").hide();
}

function showStageDetail() {
	var stage = $(this).data("stage");
	$("#netpayStageDiv").find(".stageDetailInfo").show();
	$("#netpayStageDiv").find("#hint").show();
	$("#netpayStageDiv").find("#agree").show();
	$("#netpayStageDiv").find("#percentFeeRate").text(stage.percentFeeRate);
	$("#netpayStageDiv").find("#poundage").html(stage.poundage);
	$("#netpayStageDiv").find("#principal").html(stage.principal);
	$("#netpayStageDiv").data("checkedStage", stage);
}

function lookStageProtocol(url, text){
	var printtop=(screen.height-600)/2;
	var printleft=(screen.width-500)/2;	
	var theproperty= 'width=600,height=400,center=yes,help=no,status=no,resizable=no,scrollbars=yes,left='+printleft+',top='+printtop+',screenx='+printleft+',screeny='+printleft;	

	window.open(url,text,theproperty);
}

function initStage(stageBunch) {
	try{
		var stageFactory = new StageFactory();
		var netpayStageArray = stageFactory.parseStageBunch(stageBunch);
		$("#netpayStageDiv").find("#stage01").parent().show();
		$("#netpayStageDiv").find("#stage01").attr("checked", true);
		$("#netpayStageDiv").find("#stage01").bind("click", hideStageDetail);
		
		for(idx in netpayStageArray) {
			var stage = netpayStageArray[idx];
			var stageInput = $("#netpayStageDiv").find("#stage"+stage.code);
			
			if(stage.flag == "ON") {
				stageInput.attr("disabled", false);
				stageInput.parent().show();
			}else if(stage.flag == "OFF"){
				
			}
			
			stageInput.data("stage", stage);
			stageInput.bind("click", showStageDetail);
		}
	}catch(e){}
}

function submitStageCheck(submitForm) {
	var stage = $("#netpayStageDiv").data("checkedStage");
	if(stage != null && stage != "") {
		if($("#netpayStageDiv").find("input[name='agree']").attr("checked") != 'checked') {
		    alert(PAGES_ALERT_INSTALLAGREE);
			return false;
		}else {
			submitForm.installment.value=stage.code;
			submitForm.instalmentFlag.value="1";
			return true;
		}
	}else {
		return true;
	}
}