<?php
 namespace App\Http\Controllers\Admin; use App\Types\EventShowStatus; use App\Types\EventStatus; use Illuminate\Support\Facades\View; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\ArrayUtil; use TechSoft\Laravel\Admin\Cms\BasicCms; use TechSoft\Laravel\Admin\Cms\Field\FieldAttr; use TechSoft\Laravel\Admin\Cms\Field\FieldCategory; use TechSoft\Laravel\Admin\Cms\Field\FieldDatetime; use TechSoft\Laravel\Admin\Cms\Field\FieldImage; use TechSoft\Laravel\Admin\Cms\Field\FieldImages; use TechSoft\Laravel\Admin\Cms\Field\FieldRichtext; use TechSoft\Laravel\Admin\Cms\Field\FieldSelect; use TechSoft\Laravel\Admin\Cms\Field\FieldSwitch; use TechSoft\Laravel\Admin\Cms\Field\FieldText; use TechSoft\Laravel\Admin\Cms\Field\FieldTextarea; use TechSoft\Laravel\Admin\Support\AdminCheckController; use TechSoft\Laravel\Admin\Util\AdminPowerUtil; use TechSoft\Laravel\Admin\Util\AdminUtil; use TechSoft\Laravel\EXField\EXFieldUtil; class EventController extends AdminCheckController { private $cmsConfigData = [ 'model' => 'event', 'pageTitle' => '活动', 'group' => 'data', 'maxLevel' => 1, 'canAdd' => true, 'canEdit' => true, 'canDelete' => true, 'canView' => true, 'addInNewWindow' => true, 'editInNewWindow' => true, 'fields' => [ 'categoryId' => ['type' => FieldCategory::class, 'title' => '分类', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'model' => 'event_category'], 'title' => ['type' => FieldText::class, 'title' => '名称', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'search' => true,], 'time' => ['type' => FieldDatetime::class, 'title' => '活动时间', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'optionType' => EventShowStatus::class], 'showStatus' => ['type' => FieldSelect::class, 'title' => '显示', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'optionType' => EventShowStatus::class], 'status' => ['type' => FieldSelect::class, 'title' => '活动状态', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'optionType' => EventStatus::class], 'applyTimeLimit' => ['type' => FieldSwitch::class, 'title' => '限制报名时间', 'add' => true, 'edit' => true, 'view' => true,], 'applyStartTime' => ['type' => FieldDatetime::class, 'title' => '开始报名时间', 'add' => true, 'edit' => true, 'view' => true,], 'applyEndTime' => ['type' => FieldDatetime::class, 'title' => '结束报名时间', 'add' => true, 'edit' => true, 'view' => true,], 'applyNumberLimit' => ['type' => FieldSwitch::class, 'title' => '限制报名人数', 'add' => true, 'edit' => true, 'view' => true,], 'applyNumberMax' => ['type' => FieldText::class, 'title' => '最大报名人数', 'add' => true, 'edit' => true, 'view' => true,], 'price' => ['type' => FieldText::class, 'title' => '价格', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'desc' => '0表示免费'], 'summary' => ['type' => FieldTextarea::class, 'title' => '活动简要说明', 'add' => true, 'edit' => true, 'view' => true,], 'cover' => ['type' => FieldImage::class, 'title' => '活动封面', 'list' => true, 'add' => true, 'edit' => true, 'view' => true,], 'photos' => ['type' => FieldImages::class, 'title' => '活动轮播图片', 'add' => true, 'edit' => true, 'view' => true,], 'param' => ['type' => FieldAttr::class, 'title' => '活动属性', 'add' => true, 'edit' => true, 'view' => true, 'desc' => '如参加地点,注意事项等'], 'applyText' => ['type' => FieldRichtext::class, 'title' => '申请说明', 'add' => true, 'edit' => true, 'view' => true, 'desc' => '在用户申请之前显示给用户'], 'applySuccessText' => ['type' => FieldRichtext::class, 'title' => '申请成功说明', 'add' => true, 'edit' => true, 'view' => true, 'desc' => '在用户申请并付款成功之后显示给用户'], 'content' => ['type' => FieldRichtext::class, 'title' => '活动说明', 'add' => true, 'edit' => true, 'view' => true,], ] ]; public function dataList(BasicCms $basicCms) { return $basicCms->executeList($this, $this->cmsConfigData); } private function edit() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('_id'); View::share('_id', $id); if ($id) { $event = ModelUtil::get('event', ['id' => $id]); ModelUtil::decodeRecordJson($event, 'photos'); ModelUtil::decodeRecordJson($event, 'param'); } else { $event = null; } if (Request::isPost()) { if (AdminPowerUtil::isDemo()) { return AdminPowerUtil::demoResponse(); } $input = InputPackage::buildFromInputJson('data'); $update = []; $update['categoryId'] = $input->getInteger('categoryId'); $update['showStatus'] = $input->getType('showStatus', EventShowStatus::class); $update['status'] = $input->getType('status', EventStatus::class); $update['time'] = $input->getDatetime('time'); $update['applyTimeLimit'] = $input->getBoolean('applyTimeLimit'); $update['applyStartTime'] = $input->getDatetime('applyStartTime'); $update['applyEndTime'] = $input->getDatetime('applyEndTime'); $update['applyNumberLimit'] = $input->getBoolean('applyNumberLimit'); $update['applyNumberMax'] = $input->getInteger('applyNumberMax'); $update['price'] = $input->getDecimal('price'); $update['title'] = $input->getTrimString('title'); $update['summary'] = $input->getTrimString('summary'); $update['cover'] = $input->getImagePath('cover'); $update['photos'] = json_encode($input->getImagesPath('photos')); $update['param'] = json_encode($input->getNameValueArray('param')); $update['applyText'] = $input->getRichContent('applyText'); $update['applySuccessText'] = $input->getRichContent('applySuccessText'); $update['content'] = $input->getRichContent('content'); if (empty($update['title'])) { return Response::send(-1, '标题不能为空'); } $ret = EXFieldUtil::buildTableFieldRow($update, $input->getArray('fieldCustoms')); if ($ret['code']) { return Response::send(-1, $ret['msg']); } if (empty($event)) { $event = ModelUtil::insert('event', $update); AdminUtil::addInfoLog($this->adminUserId(), '增加活动', ['ID' => $event['id']]); } else { ModelUtil::update('event', ['id' => $event['id']], $update); $old = ArrayUtil::filterSpecifiedKey($event, array_keys($update)); $old['photos'] = json_encode($old['photos']); $old['param'] = json_encode($old['param']); AdminUtil::addInfoLogIfChanged($this->adminUserId(), '修改活动', $old, $update); } return Response::send(0, '操作成功', null, action('\App\Http\Controllers\Admin\EventController@dataList')); } $categoryList = ModelUtil::all('event_category', [], ['*'], ['sort', 'asc']); EXFieldUtil::unbuildTableFieldRow($event); return view('admin.event.edit', [ 'categoryList' => $categoryList, 'event' => $event, ]); } public function dataAdd() { return $this->edit(); } public function dataEdit() { return $this->edit(); } public function dataDelete(BasicCms $basicCms) { return $basicCms->executeDelete($this, $this->cmsConfigData); } public function dataView(BasicCms $basicCms) { return $basicCms->executeView($this, $this->cmsConfigData); } }