@extends('admin::frame')

@section('pageTitle','后台首页')

@section('adminScript')
    @parent
    @include('soft::admin.dashboardVersion')
@endsection

@section('bodyContent')

    @include('soft::admin.dashboardDemo')

    <div class="uk-grid">
        <div class="uk-width-1-3">
            <div class="admin-block-stat">
                <div class="icon red">
                    <i class="uk-icon-th"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\EventController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('event'))}}
                </a>
                <div class="name">
                    活动总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-3">
            <div class="admin-block-stat">
                <div class="icon green">
                    <i class="uk-icon-users"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\MemberController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('member_user'))}}
                </a>
                <div class="name">
                    会员总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-3">
            <div class="admin-block-stat">
                <div class="icon blue">
                    <i class="uk-icon-list"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\OrderController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('event_order'))}}
                </a>
                <div class="name">
                    订单总数
                </div>
            </div>
        </div>
    </div>

    @include('soft::admin.dashboardCopyright')

@endsection
