@extends($_frameLayoutView)

@if($currentCategory)
    @section('pageTitleMain',$currentCategory['title'])
@else
    @section('pageTitleMain','活动')
@endif

@section('bodyContent')

    <div class="pb-category-filter">
        <div class="filter">
            <div class="label">分类：</div>
            <div class="value">
                <a href="/category" @if($base_request_path=='/category') class="active" @endif>全部</a>
                @foreach($eventCategories as $eventCategory)
                    <a href="/category/{{$eventCategory['id']}}" @if($base_request_path=='/category/'.$eventCategory['id']) class="active" @endif>{{$eventCategory['title']}}</a>
                @endforeach
            </div>
        </div>
    </div>

    <div class="pb-event-list">
        <div class="list">
            @if(empty($events))
                <div class="empty">
                    暂无记录~
                </div>
            @else
                <div class="uk-grid">
                    @foreach($events as $event)
                        <div class="uk-width-1-1">
                            <a href="/event/{{$event['id']}}" class="item">
                                <div class="cover" data-src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($event['cover'])}}"></div>
                                <div class="title uk-text-truncate">
                                    @if($event['status']==\App\Types\EventStatus::APPLYING)
                                        [正在报名]
                                    @else
                                        [{{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\EventStatus::class,$event['status'])}}]
                                    @endif
                                    {{$event['title']}}
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>

    <div class="page-container">
        {!! $pageHtml !!}
    </div>



@endsection