@extends('theme.default.m.frame')

@section('pageTitleMain','我的活动')

@section('bodyContent')

    <div class="pb-member-order-list">
        <div class="list-box">
            @if(empty($orders))
                <div class="empty">
                    暂无记录
                </div>
            @endif
            @foreach($orders as $order)
                <div class="item">
                    <div class="head">
                        <div class="status">
                            @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                <span class="pb-text-danger">等待付款</span>
                            @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                                <span class="pb-text-muted">已过期</span>
                            @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                                <span class="pb-text-success">已完成</span>
                            @endif
                        </div>
                        订单号：{{$order['sn']}}
                    </div>
                    @foreach($order['_items'] as $orderItem)
                        <div class="event">
                            <a class="cover" href="/event/{{$orderItem['eventId']}}" target="_blank" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($orderItem['_event']['cover'])}})">
                            </a>
                            <a class="title" href="/event/{{$orderItem['eventId']}}" target="_blank">
                                {{$orderItem['_event']['title']}}
                            </a>
                            <div class="buyInfo">
                                @foreach(\TechSoft\Laravel\EXField\EXFieldUtil::pair($orderItem['_event'],$orderItem) as $item)
                                    <div class="line">
                                        {{$item['name']}}：{{$item['value']}}
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                    <div class="attr">
                        <div class="time">
                            时间：{{$order['created_at']}}
                        </div>
                        <div class="fee">
                            ￥{{$order['payFee']}}元
                        </div>
                    </div>
                    <div class="action">
                        @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                            <a class="main" href="/member/order_pay/{{$order['id']}}">立即付款</a>
                        @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                        @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                            <a class="main" href="/member/order_detail/{{$order['id']}}">查看详情</a>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <div class="page-container">
        {!! $pageHtml !!}
    </div>

@endsection