@extends('theme.default.pc.frame')

@if($currentCategory)
    @section('pageTitleMain',$currentCategory['title'])
@else
    @section('pageTitleMain','活动')
@endif

@section('bodyContent')

    <div class="main-container">
        <div class="pb-category-filter" style="margin-top:15px;">
            <div class="filter">
                <div class="label">分类：</div>
                <div class="value">
                    <a href="/category" @if($base_request_path=='/category') class="active" @endif>全部</a>
                    @foreach($eventCategories as $eventCategory)
                        <a href="/category/{{$eventCategory['id']}}" @if($base_request_path=='/category/'.$eventCategory['id']) class="active" @endif>{{$eventCategory['title']}}</a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <div class="main-container">
        <div class="pb-event-list">
            <div class="list">
                @if(empty($events))
                    <div class="empty">
                        暂无记录~
                    </div>
                @else
                    <div class="uk-grid">
                        @foreach($events as $event)
                        <div class="uk-width-1-4">
                            <a href="/event/{{$event['id']}}" class="item">
                                <div class="cover" data-src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($event['cover'])}}"></div>
                                <div class="title uk-text-truncate">
                                    {{$event['title']}}
                                </div>
                                <div class="attr">
                                    <div class="time">
                                        <span class="uk-icon-clock-o"></span> {{\Carbon\Carbon::parse($event['time'])->toDateString()}}
                                    </div>
                                    <div class="status">
                                        状态：
                                        @if($event['status']==\App\Types\EventStatus::APPLYING)
                                            <span class="uk-text-success">正在报名</span>
                                        @else
                                            {{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\EventStatus::class,$event['status'])}}
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        <div class="page-container">
            {!! $pageHtml !!}
        </div>

    </div>


@endsection