@extends('theme.default.pc.frame')

@section('pageTitleMain',$event['title'])
@section('pageKeywords',$event['title'])
@section('pageDescription',$event['summary'])

@section('bodyScript')
    <script src="@assets('assets/main/event.js')"></script>
@endsection

@section('bodyContent')

    <div class="main-container">
        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/category/{{$event['_category']['id']}}">{{$event['_category']['title']}}</a></li>
                <li class="uk-active"><span>{{$event['title']}}</span></li>
            </ul>
        </div>
    </div>

    <div class="main-container">
        <div class="uk-grid">
            <div class="uk-width-1-1">
                <div class="pb pb-event-basic">
                    <div class="uk-grid">
                        <div class="uk-width-1-2">
                            <div class="images">
                                <div class="swiper-container">
                                    <div class="swiper-wrapper">
                                        <a href="javascript:;" class="swiper-slide" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($event['cover'])}});"></a>
                                        @foreach($event['photos'] as $photo)
                                            <a  href="javascript:;" class="swiper-slide" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($photo)}});"></a>
                                        @endforeach
                                    </div>
                                    <div class="swiper-pagination swiper-pagination-white"></div>
                                    <div class="swiper-button-next swiper-button-white"></div>
                                    <div class="swiper-button-prev swiper-button-white"></div>
                                </div>
                            </div>
                        </div>
                        <div class="uk-width-1-2">
                            <div class="basic">
                                <h1>{{$event['title']}}</h1>
                                <div class="info">
                                    <div class="attr">
                                        <div class="name">
                                            时间：
                                        </div>
                                        <div class="value">
                                            {{\Carbon\Carbon::parse($event['time'])->format('Y-m-d H:i')}}
                                        </div>
                                    </div>
                                    @if($event['applyTimeLimit'])
                                        <div class="attr">
                                            <div class="name">
                                                报名开始：
                                            </div>
                                            <div class="value">
                                                {{\Carbon\Carbon::parse($event['applyStartTime'])->format('Y-m-d H:i')}}
                                            </div>
                                        </div>
                                        <div class="attr">
                                            <div class="name">
                                                报名截止：
                                            </div>
                                            <div class="value">
                                                {{\Carbon\Carbon::parse($event['applyEndTime'])->format('Y-m-d H:i')}}
                                            </div>
                                        </div>
                                    @endif
                                    @if($event['applyNumberLimit'])
                                        <div class="attr">
                                            <div class="name">
                                                报名限制：
                                            </div>
                                            <div class="value">
                                                {{$event['applyNumberMax']}}人
                                            </div>
                                        </div>
                                    @endif
                                    @foreach($event['param'] as $item)
                                        <div class="attr">
                                            <div class="name">
                                                {{$item['name']}}：
                                            </div>
                                            <div class="value">
                                                {{$item['value']}}
                                            </div>
                                        </div>
                                    @endforeach
                                    <div class="attr">
                                        <div class="name">
                                            费用：
                                        </div>
                                        <div class="value">
                                            @if($event['price']>0)
                                                <div class="price">￥{{$event['price']}}元</div>
                                            @else
                                                <div class="price">免费</div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="action">
                                    @if($event['applyTimeLimit'] && time()<strtotime($event['applyStartTime']))
                                            <div class="disabled">报名未开始</div>
                                    @elseif($event['applyTimeLimit'] && time()>strtotime($event['applyEndTime']))
                                            <div class="disabled">报名已截止</div>
                                    @elseif($event['status']==\App\Types\EventStatus::NOT_START)
                                        <div class="disabled">报名未开始</div>
                                    @elseif($event['status']==\App\Types\EventStatus::APPLYING)
                                        @if($_memberUserId)
                                            <a class="submit" href="javascript:;" onclick="UIkit.modal('#submitDialog').show();">立即报名</a>
                                        @else
                                            <a class="submit" href="/login?redirect={{urlencode('/event/'.$event['id'])}}">立即报名</a>
                                        @endif
                                    @elseif($event['status']==\App\Types\EventStatus::APPLY_EXPIRED)
                                        <div class="disabled">已过期</div>
                                    @elseif($event['status']==\App\Types\EventStatus::FINISHED)
                                        <div class="disabled">已结束</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-width-7-10">
                <div class="pb pb-event-detail">
                    <div class="title">
                        详细描述
                    </div>
                    <div class="content">
                        {!! \TechSoft\Laravel\Util\HtmlUtil::replaceImageSrcToLazyLoad($event['content'],'data-src',true) !!}
                    </div>
                </div>
            </div>
            <div class="uk-width-3-10">
                <div class="pb pb-event-info">
                    <div class="title">
                        <h2>{{$event['title']}}</h2>
                    </div>
                    <div class="summary">
                        {{$event['summary']}}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="submitDialog" class="uk-modal">
        <form action="/event/{{$event['id']}}/submit" class="uk-form" method="post" data-ajax-form>
            <div class="uk-modal-dialog pb-event-submit-dialog" style="width:800px;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    <h2>{{$event['title']}}报名确认</h2>
                </div>
                <div>
                    @if($event['applyText'])
                        <div class="apply-text">
                            {!! $event['applyText'] !!}
                        </div>
                    @endif

                    @if(!empty($event['_fieldCustom']))
                        <div class="apply-field-title">
                            请填写以下报名信息
                        </div>
                        <div class="apply-field">
                            <?php
                            echo (new \TechSoft\Laravel\EXField\EXField())->render([
                                'fieldCustom1'=>@json_decode($event['fieldCustom1'],true),
                                'fieldCustom2'=>@json_decode($event['fieldCustom2'],true),
                                'fieldCustom3'=>@json_decode($event['fieldCustom3'],true),
                                'fieldCustom4'=>@json_decode($event['fieldCustom4'],true),
                                'fieldCustom5'=>@json_decode($event['fieldCustom5'],true)
                            ]);
                            ?>
                        </div>
                    @endif
                </div>
                <div class="uk-modal-footer">
                    <button type="submit" class="uk-button uk-button-primary uk-button-large uk-width-1-1">确认报名</button>
                </div>
            </div>
        </form>
    </div>

@endsection