<!doctype html>
<html class="no-js">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault(\TechSoft\Laravel\Config\ConfigUtil::get('siteFavIco'),'default_favicon.ico')}}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="keywords" content="@yield('pageKeywords',\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords'))">
    <meta name="description" content="@yield('pageDescription',\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription'))">
    <meta name="viewport" content="width=device-width, minimum-scale=0.5, maximum-scale=5, user-scalable=no">
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="no-siteapp"/>
    <script src="@assets('assets/init.js')"></script>
    <title>@section('pageTitle')@yield('pageTitleMain') - {{\TechSoft\Laravel\Config\ConfigUtil::get('siteName')}}@show</title>
    @section('headScript')
        <link rel="stylesheet" href="@assets('assets/uikit/css/ui.css')"/>
        <link rel="stylesheet" href="@assets('theme/default/pc/css/style.css')"/>
    @show
    @section('headAppend')@show
    {!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounter') !!}
</head>
<body>
@section('body')

    <div class="pb-header-top">
        <div class="main-container">
            <div class="right">
                @if(!empty($_memberUser))
                    <a class="mute" href="/member"><i class="uk-icon-user"></i> 我的中心</a>
                    <a class="mute" href="/member/order"><i class="uk-icon-list"></i> 我的活动</a>
                @endif
                <a class="mute" href="javascript:;" data-page-qrcode><i class="uk-icon-tablet"></i> 移动端</a>
            </div>
            <div class="left">
                @if(empty($_memberUser))
                    Hi，
                    <a href="/login">请登录</a>
                    |
                    <a class="mute" href="/register">免费注册</a>
                @else
                    <a href="/member">{{\TechSoft\Laravel\Member\MemberUtil::viewName($_memberUser)}}</a>
                    <a class="mute" data-confirm="确定退出?" data-href="/logout">退出</a>
                @endif
            </div>
        </div>
    </div>

    <header>
        <div class="main-container">
            <nav class="uk-navbar">
                <div class="uk-navbar-nav-right">
                    <form method="get" action="/search">
                        <button type="submit"><i class="uk-icon-search"></i></button>
                        <input name="keyword" type="text" placeholder="搜索活动" value="{{Input::get('keyword','')}}" />
                    </form>
                </div>
                <a class="uk-navbar-brand" href="/"><img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault(\TechSoft\Laravel\Config\ConfigUtil::get('siteLogo'),'/placeholder/160x50')}}" /></a>
                <ul class="uk-navbar-nav">
                    <li @if($base_request_path=='/') class="uk-active" @endif><a href="/">首页</a></li>
                    <li @if(\Illuminate\Support\Str::startsWith($base_request_path,'/category') || \Illuminate\Support\Str::startsWith($base_request_path,'/event')) class="uk-active" @endif><a href="/category">活动</a></li>
                </ul>
            </nav>
        </div>
    </header>

    @section('bodyContent')@show

    <footer>
        <div class="main-container">
            <div class="articles">
                @foreach($footerArticles as $footerArticle)
                    <a href="/article/{{$footerArticle['id']}}">{{$footerArticle['title']}}</a>
                @endforeach
            </div>
            <div class="copyright">
                <a href="http://beian.miit.gov.cn/" target="_blank">{{\TechSoft\Laravel\Config\ConfigUtil::get('siteBeian','[网站备案信息]')}}</a>
                &copy;
                {{\TechSoft\Laravel\Config\ConfigUtil::get('siteDomain')}}
            </div>
        </div>
    </footer>

@show
@section('bodyScript')
    <script src="@assets('assets/main/basic.js')"></script>
@show
@section('bodyAppend')@show
{!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounterBody') !!}
</body>
</html>
