@extends('theme.default.pc.memberProfile.frame')

@section('pageTitleMain','活动'.'详情')

@section('memberBodyContent')

    <div class="pb pb-member-order-list">
        <div class="head">
            <h2>我的活动</h2>
        </div>
        <div class="content">
            <div class="list-box">
                @if(empty($orders))
                    <div class="empty">
                        暂无记录
                    </div>
                @endif
                @foreach($orders as $order)
                    <table class="uk-table table-bordered">
                        <thead>
                        <tr>
                            <th colspan="3">
                                时间：{{$order['created_at']}}
                                &nbsp;&nbsp;
                                订单号：{{$order['sn']}}
                            </th>
                            <th class="uk-text-right">
                                {{--<a class="remove" href="javascript:;" data-ajax-request="/member/order_delete/1" data-ajax-request-loading data-confirm="确认删除?">--}}
                                {{--<i class="uk-icon-trash-o"></i>--}}
                                {{--</a>--}}
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($order['_items'] as $orderItemIndex=>$orderItem)
                            <tr>
                                <td>
                                    <div class="event">
                                        <a class="cover cover-1-1" href="/event/{{$orderItem['eventId']}}" target="_blank" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($orderItem['_event']['cover'])}})">
                                        </a>
                                        <a class="title" href="/event/{{$orderItem['eventId']}}" target="_blank">
                                            {{$orderItem['_event']['title']}}
                                        </a>
                                        <div class="buyInfo">
                                            @foreach(\TechSoft\Laravel\EXField\EXFieldUtil::pair($orderItem['_event'],$orderItem) as $item)
                                                <div class="item">
                                                    {{$item['name']}}：{{$item['value']}}
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </td>
                                @if($orderItemIndex==0)
                                    <td rowspan="{{count($order['_items'])}}" style="width:100px;" class="uk-text-center">
                                        ￥{{$order['payFee']}}元
                                    </td>
                                    <td rowspan="{{count($order['_items'])}}" style="width:100px;" class="uk-text-center">
                                        <div class="status">
                                            @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                                <span class="uk-text-danger">等待付款</span>
                                            @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                                                <span class="uk-text-muted">已过期</span>
                                            @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                                                <span class="uk-text-success">已完成</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td rowspan="{{count($order['_items'])}}" style="width:100px;">
                                        <div class="action">
                                            @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                                <a class="main" href="/member/order_pay/{{$order['id']}}">立即付款</a>
                                            @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                                            @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                                                <a class="main" href="/member/order_detail/{{$order['id']}}">查看详情</a>
                                            @endif
                                        </div>
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                @endforeach
            </div>

            <div class="page-container">
                {!! $pageHtml !!}
            </div>

        </div>
    </div>

@endsection