<?php
 namespace TechSoft\Laravel\MemberFollow; use TechOnline\Laravel\Dao\ModelUtil; class MemberFollowUtil { public static function isFollowed($followerMemberUserId, $memberUserId) { if (ModelUtil::exists('member_follower', [ 'followerMemberUserId' => $followerMemberUserId, 'memberUserId' => $memberUserId, ]) ) { return true; } else { return false; } } private static function updateFollowStat($followerMemberUserId, $memberUserId) { $followCount = ModelUtil::count('member_follower', ['followerMemberUserId' => $followerMemberUserId]); ModelUtil::update('member_user', ['id' => $followerMemberUserId], ['followCount' => $followCount]); $followerCount = ModelUtil::count('member_follower', ['memberUserId' => $memberUserId]); ModelUtil::update('member_user', ['id' => $memberUserId], ['followerCount' => $followerCount]); } public static function follow($followerMemberUserId, $memberUserId) { $data = [ 'followerMemberUserId' => $followerMemberUserId, 'memberUserId' => $memberUserId, ]; if (!ModelUtil::exists('member_follower', $data)) { ModelUtil::insert('member_follower', $data); self::updateFollowStat($followerMemberUserId, $memberUserId); } } public static function unfollow($followerMemberUserId, $memberUserId) { $data = [ 'followerMemberUserId' => $followerMemberUserId, 'memberUserId' => $memberUserId, ]; ModelUtil::delete('member_follower', $data); self::updateFollowStat($followerMemberUserId, $memberUserId); } public static function paginateFollowerMemberUsers($memberUserId, $page, $pageSize, $option = []) { $option['where']['memberUserId'] = $memberUserId; $paginateData = ModelUtil::paginate('member_follower', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'followerMemberUserId', '_followerMemberUser', 'member_user', 'id'); $memberUsers = []; foreach ($paginateData['records'] as $item) { $memberUsers[] = $item['_followerMemberUser']; } $paginateData['records'] = $memberUsers; return $paginateData; } public static function paginateFollowingMemberUsers($memberUserId, $page, $pageSize, $option = []) { $option['where']['followerMemberUserId'] = $memberUserId; $paginateData = ModelUtil::paginate('member_follower', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'memberUserId', '_memberUser', 'member_user', 'id'); $memberUsers = []; foreach ($paginateData['records'] as $item) { $memberUsers[] = $item['_memberUser']; } $paginateData['records'] = $memberUsers; return $paginateData; } public static function mergeIsFollowed(&$memberUsers, $memberUserId) { if (empty($memberUsers)) { return; } $memberUserIds = []; foreach ($memberUsers as $memberUser) { $memberUserIds[] = $memberUser['id']; } $memberFollowers = ModelUtil::model('member_follower')->where([ 'followerMemberUserId' => $memberUserId ])->whereIn('memberUserId', $memberUserIds)->get()->toArray(); $map = []; foreach ($memberFollowers as $memberFollower) { $map[$memberFollower['memberUserId']] = true; } foreach ($memberUsers as &$memberUser) { if (empty($map[$memberUser['id']])) { $memberUser['_isFollowed'] = false; } else { $memberUser['_isFollowed'] = true; } } } public static function getFollowedMemberUserIds($memberUserId) { $memberUsers = ModelUtil::all('member_follower', ['followerMemberUserId' => $memberUserId]); return array_pluck($memberUsers, 'memberUserId'); } }