<?php
 namespace TechSoft\Laravel\Shipping; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Util\TreeUtil; class AreaUtil { public static function listChinaProvinceCityTree() { $provinces = ModelUtil::model('area_china') ->select(['areaId', 'parentAreaId', 'sort', 'name']) ->where(['parentAreaId' => 0])->get()->toArray(); $areaIds = array_pluck($provinces, 'areaId'); $cities = ModelUtil::model('area_china')->select(['areaId', 'parentAreaId', 'sort', 'name']) ->whereIn('parentAreaId', $areaIds)->get()->toArray(); $areas = array_merge($provinces, $cities); return TreeUtil::nodeMerge($areas, 0, 'areaId', 'parentAreaId', 'sort', 'asc'); } public static function listChinaByParentAreaIds($parentAreaIds) { if (!is_array($parentAreaIds)) { $parentAreaIds = [$parentAreaIds]; } return ModelUtil::model('area_china')->select(['areaId', 'parentAreaId', 'sort', 'name']) ->whereIn('parentAreaId', $parentAreaIds)->get()->toArray(); } public static function listRelatedChinaByName($names) { if (!is_array($names)) { $names = [$names]; } $list = self::listChinaByParentAreaIds(0); if (empty($names)) { return $list; } $relatedList = []; $pid = 0; $index = 0; do { $hasMore = false; $list = self::listChinaByParentAreaIds($pid); if (empty($list)) { break; } $relatedList = array_merge($relatedList, $list); if (isset($names[$index])) { foreach ($list as $item) { if ($item['name'] == $names[$index]) { $pid = $item['areaId']; $hasMore = true; break; } } } $index++; } while ($hasMore); return $relatedList; } public static function listChinaAllByAreaIds($areaIds) { if (!is_array($areaIds)) { $areaIds = [$areaIds]; } $areaIdMap = array_fill_keys($areaIds, true); $allArea = self::all(); $allArea = TreeUtil::nodeMerge($allArea, 0, 'areaId', 'parentAreaId', 'sort', 'asc'); $areas = []; foreach ($allArea as $province) { $includeProvince = false; if (array_key_exists($province['areaId'], $areaIdMap)) { $includeProvince = true; foreach ($province['_child'] as $city) { $areas[] = [ 'areaId' => $city['areaId'], 'parentAreaId' => $city['parentAreaId'], 'name' => $city['name'], 'sort' => $city['sort'], ]; foreach ($city['_child'] as $district) { $areas[] = [ 'areaId' => $district['areaId'], 'parentAreaId' => $district['parentAreaId'], 'name' => $district['name'], 'sort' => $district['sort'], ]; } } } else { foreach ($province['_child'] as $city) { $includeCity = false; if (array_key_exists($city['areaId'], $areaIdMap)) { $includeProvince = true; $includeCity = true; foreach ($city['_child'] as $district) { $areas[] = [ 'areaId' => $district['areaId'], 'parentAreaId' => $district['parentAreaId'], 'name' => $district['name'], 'sort' => $district['sort'], ]; } } else { foreach ($city['_child'] as $district) { if (array_key_exists($district['areaId'], $areaIdMap)) { $includeCity = true; $areas[] = [ 'areaId' => $district['areaId'], 'parentAreaId' => $district['parentAreaId'], 'name' => $district['name'], 'sort' => $district['sort'], ]; } } } if ($includeCity) { $areas[] = [ 'areaId' => $city['areaId'], 'parentAreaId' => $city['parentAreaId'], 'name' => $city['name'], 'sort' => $city['sort'], ]; } } } if ($includeProvince) { $areas[] = [ 'areaId' => $province['areaId'], 'parentAreaId' => $province['parentAreaId'], 'name' => $province['name'], 'sort' => $province['sort'], ]; } } return $areas; } public static function all() { return ModelUtil::model('area_china') ->select(['areaId', 'parentAreaId', 'sort', 'name']) ->get()->toArray(); } }