<?php
 namespace TechOnline\Utils; class TimeUtil { const FORMAT_DATE = 'Y-m-d'; const FORMAT_DATETIME = 'Y-m-d H:i:s'; const PERIOD_YEAR = 24 * 3600 * 365; const PERIOD_MONTH = 24 * 3600 * 30; const PERIOD_WEEK = 24 * 3600 * 7; const PERIOD_DAY = 24 * 3600; const PERIOD_HOUR = 3600; const PERIOD_MINITE = 60; public static function humanTimeLength($timeSeconds, $lang = 'zh') { $langMap = [ 'zh' => [ 'd' => '天', 'h' => '小时', 'm' => '分钟', 's' => '秒', ], 'en' => [ 'd' => 'd', 'h' => 'h', 'm' => 'm', 's' => 's', ], ]; $pcs = []; if ($timeSeconds >= self::PERIOD_DAY) { $v = intval($timeSeconds / self::PERIOD_DAY); $pcs[] = $v . $langMap[$lang]['d']; $timeSeconds %= self::PERIOD_DAY; } if ($timeSeconds >= self::PERIOD_HOUR) { $v = intval($timeSeconds / self::PERIOD_HOUR); $pcs[] = $v . $langMap[$lang]['h']; $timeSeconds %= self::PERIOD_HOUR; } if ($timeSeconds >= self::PERIOD_MINITE) { $v = intval($timeSeconds / self::PERIOD_MINITE); $pcs[] = $v . $langMap[$lang]['m']; $timeSeconds %= self::PERIOD_MINITE; } if ($timeSeconds > 0) { $pcs[] = $timeSeconds . $langMap[$lang]['s']; } return join('', $pcs); } public static function now() { return date(self::FORMAT_DATETIME, time()); } public static function isBefore($timestamp, $period) { return $timestamp < time() - $period; } public static function getBeforeTimestamp($period) { return time() - $period; } public static function getBeforeDatetime($period) { return date(self::FORMAT_DATETIME, self::getBeforeTimestamp($period)); } public static function isDatetimeEmpty($datetime) { $timestamp = strtotime($datetime); if (empty($timestamp) || $timestamp < 0) { return true; } return false; } public static function isDateEmpty($date) { $timestamp = strtotime($date); if (empty($timestamp) || $timestamp < 0) { return true; } return false; } public static function isTimeEmpty($time) { $timestamp = strtotime('2019-01-01 ' . $time); if (empty($timestamp) || $timestamp < 0) { return true; } return false; } public static function isDateExpired($expire) { if (self::isDateEmpty($expire)) { return false; } if (strtotime($expire) < time()) { return true; } return false; } public static function nextExpireTimestamp($current, $plusSeconds, $format = 'Y-m-d') { $ts = time(); $i = strtotime($current); if (!empty($current) && $i > 0) { $ts = $i + $plusSeconds; } else { $ts += $plusSeconds; } return date($format, $ts); } public static function isInRange($start, $end) { $ts = time(); if (!self::isDatetimeEmpty($start)) { $start = strtotime($start); if ($ts < $start) { return false; } } if (!self::isDatetimeEmpty($end)) { $end = strtotime($end); if ($ts > $end) { return false; } } return true; } }