PrefabFiles = {
	"mokou",
	"mokou_none",
	"mokoufire",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/mokou.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/mokou.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/mokou.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mokou.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/mokou_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mokou_silho.xml" ),

    Asset( "IMAGE", "bigportraits/mokou.tex" ),
    Asset( "ATLAS", "bigportraits/mokou.xml" ),
	
	Asset( "IMAGE", "images/map_icons/mokou.tex" ),
	Asset( "ATLAS", "images/map_icons/mokou.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_mokou.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_mokou.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_mokou.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_mokou.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_mokou.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_mokou.xml" ),
	
	Asset( "IMAGE", "images/names_mokou.tex" ),
    Asset( "ATLAS", "images/names_mokou.xml" ),
	
    Asset( "IMAGE", "bigportraits/mokou_none.tex" ),
    Asset( "ATLAS", "bigportraits/mokou_none.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

AddPrefabPostInit("mokou", function(inst)
	if GetModConfigData("Resurrection") == "Yes" then
		inst:ListenForEvent("ms_becameghost", function() -- when players dies
			inst:DoTaskInTime(300, function() -- you can change the time (now 300 seconds)
				inst:PushEvent("respawnfromghost", {source={name="The Undying Gift",components={}}}) -- push resurrection event after 300 seconds
			end)
		end)
	end
end)

-- The character select screen lines
STRINGS.CHARACTER_TITLES.mokou = "The Ageless Human"
STRINGS.CHARACTER_NAMES.mokou = "Mokou"
STRINGS.CHARACTER_DESCRIPTIONS.mokou = "*Resilience to pain\n*Firey Glow\n*Fire skill"
STRINGS.CHARACTER_QUOTES.mokou = "\"I'm an ordinary health maniac who runs a yakitori stand.\""

-- Custom speech strings
STRINGS.CHARACTERS.MOKOU = require "speech_mokou"

-- The character's name as appears in-game 
STRINGS.NAMES.MOKOU = "Mokou"

AddMinimapAtlas("images/map_icons/mokou.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("mokou", "FEMALE")

