
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"mokoufire",
	"amulet",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "mokou_speed_mod", 1)
end

local function HealthFlux(inst, data)
    local hp = data.newpercent
    if 0.8 < hp then
        inst.components.health.absorb = 0.20
		inst.components.talker:Say("(20% Def Boost)")
    elseif 0.6 < hp and hp <= 0.8 then
		inst.components.health.absorb = 0.25
		inst.components.talker:Say("(25%)")
    elseif 0.4 < hp and hp <= 0.6 then
		inst.components.health.absorb = 0.30
		inst.components.talker:Say("(30%)")
    elseif 0.2 < hp and hp <= 0.4 then
		inst.components.health.absorb = 0.35
		inst.components.talker:Say("(35%)")
    elseif hp <= 0.2 then
		inst.components.health.absorb = 0.40
		inst.components.talker:Say("(40%)")
	end
end

local function Sparkle(inst)
    SpawnPrefab("firesplash_fx").entity:AddFollower():FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
    inst:DoTaskInTime(math.random(20, 30), Sparkle)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "mokou_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "mokou.tex" )
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
    inst.components.health.fire_damage_scale = TUNING.WILLOW_FIRE_DAMAGE
    inst.components.health.fire_timestart = TUNING.WILLOW_FIRE_IMMUNITY
	
	inst.components.health:SetMaxHealth(140)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(160)
	
	inst.fire = SpawnPrefab("torchfire")
	local follower = inst.fire.entity:AddFollower()
	follower:FollowSymbol(inst.GUID, "swap_hat", 0, -200, 0)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	inst:DoTaskInTime(math.random(20, 30), Sparkle)
	inst:ListenForEvent("healthdelta", HealthFlux)
	
	inst:ListenForEvent("death", function(inst)
		inst.components.talker:Say("Like this would put me down.", 2.5,true) 
	end)
	
	inst:ListenForEvent("respawnfromghost", function(inst)
		inst.components.talker:Say("Now back to the usual business.", 2.5,true) 
	end)
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

return MakePlayerCharacter("mokou", prefabs, assets, common_postinit, master_postinit, start_inv)
