local assets=
{
    Asset("ANIM", "anim/mokoufire.zip"),
    Asset("ANIM", "anim/swap_mokoufire.zip"),
  
    Asset("ATLAS", "images/inventoryimages/mokoufire.xml"),
    Asset("IMAGE", "images/inventoryimages/mokoufire.tex"),
}

local prefabs = 
{

}

local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_mokoufire", "swap_mokoufire")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
  
local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
 
 local function onattack(weapon, attacker, target)
    -- if target ~= nil and target.components.burnable ~= nil and math.random() < TUNING.TORCH_ATTACK_IGNITE_PERCENT * target.components.burnable.flammability then
        -- target.components.burnable:Ignite(nil, attacker)
    -- end
	
    local atkfx = SpawnPrefab("firesplash_fx")
    if atkfx then
	    local follower = atkfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
    end
end

local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("mokoufire")
    inst.AnimState:SetBuild("mokoufire")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(35)
    inst.components.weapon:SetOnAttack(onattack)
	  
    inst:AddComponent("inspectable")
      
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "mokoufire"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/mokoufire.xml"
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true
	     
    return inst
end

STRINGS.NAMES.MOKOUFIRE = "Mokous Fire Ability"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MOKOUFIRE = "I get 'Enternal Flame' vibes from this."

return  Prefab("common/inventory/mokoufire", fn, assets, prefabs) 