/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.ndrei.teslacorelib.tileentities.ElectricTileEntity;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.gui.IDualTankMachine;

public class DualTankEntityRenderer
extends TileEntitySpecialRenderer<ElectricTileEntity> {
    public void renderTileEntityAt(ElectricTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        IDualTankMachine machine = (IDualTankMachine)te;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        switch (te.getFacing()) {
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)0.501);
        super.func_190053_a(true);
        float magicNumber = 0.03125f;
        GlStateManager.func_179152_a((float)magicNumber, (float)(-magicNumber), (float)magicNumber);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTank(5.0f, machine.getLeftTankFluid(), machine.getLeftTankPercent());
        this.drawTank(19.0f, machine.getRightTankFluid(), machine.getRightTankPercent());
        super.func_190053_a(false);
        GlStateManager.func_179121_F();
    }

    private void drawTank(float tankX, Fluid fluid, float fluidPercent) {
        ResourceLocation fluidTexture;
        if (fluidPercent == 0.0f) {
            return;
        }
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        if (fluid != null && fluidPercent > 0.0f && (fluidTexture = fluid.getFlowing()) != null) {
            TextureAtlasSprite fluidSprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluidTexture.toString());
            int color = fluid.getColor();
            GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
            super.func_147499_a(TextureMap.field_110575_b);
            float height = 14.02f * fluidPercent;
            this.drawRectangle(tankX + 0.99f, 20.01f - height, 6.02f, height, fluidSprite.func_94209_e(), fluidSprite.func_94206_g(), fluidSprite.func_94212_f(), fluidSprite.func_94210_h());
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.001f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_147499_a(TeslaThingiesMod.MACHINES_TEXTURES);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        this.drawRectangle(tankX, 5.0f, 8.0f, 16.0f, (23.0f + tankX) / 256.0f, 0.31640625f, (31.0f + tankX) / 256.0f, 0.37890625f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.001f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private void drawRectangle(float x, float y, float width, float height, float minU, float minV, float maxU, float maxV) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }
}

