/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.integrations.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.common.BlocksRegistry;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerCoolantRecipe;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerFuelRecipe;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerRecipes;

public class FluidBurnerCategory
extends BlankRecipeCategory<FluidBurnerRecipeWrapper> {
    public static final String UID = "FluidBurner";
    private IDrawable background = null;
    private IDrawable fuelOverlay = null;
    private IDrawable coolantOverlay = null;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidBurnerCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)BlocksRegistry.fluidBurner), new String[]{UID});
        ArrayList recipes = Lists.newArrayList();
        for (FluidBurnerFuelRecipe fuel : FluidBurnerRecipes.getFuels()) {
            recipes.add(new FluidBurnerRecipeWrapper(fuel, null));
            for (FluidBurnerCoolantRecipe coolant : FluidBurnerRecipes.getCoolants()) {
                recipes.add(new FluidBurnerRecipeWrapper(fuel, coolant));
            }
        }
        registry.addRecipes((Collection)recipes, UID);
    }

    public FluidBurnerCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TeslaThingiesMod.JEI_TEXTURES, 0, 66, 124, 66);
        this.fuelOverlay = guiHelper.createDrawable(TeslaThingiesMod.JEI_TEXTURES, 8, 74, 8, 27);
        this.coolantOverlay = guiHelper.createDrawable(TeslaThingiesMod.JEI_TEXTURES, 20, 74, 8, 27);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return BlocksRegistry.fluidBurner.func_149732_F();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidBurnerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        int capacity = recipeWrapper.coolant != null ? Math.max(((FluidBurnerRecipeWrapper)recipeWrapper).fuel.amount, ((FluidBurnerRecipeWrapper)recipeWrapper).coolant.amount) : ((FluidBurnerRecipeWrapper)recipeWrapper).fuel.amount;
        fluids.init(0, true, 8, 8, 8, 27, capacity, false, this.fuelOverlay);
        fluids.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        if (ingredients.getInputs(FluidStack.class).size() == 2) {
            fluids.init(1, true, 20, 8, 8, 27, capacity, false, this.coolantOverlay);
            fluids.set(1, (List)ingredients.getInputs(FluidStack.class).get(1));
        }
    }

    public static class FluidBurnerRecipeWrapper
    extends BlankRecipeWrapper {
        private FluidBurnerFuelRecipe fuel;
        private FluidBurnerCoolantRecipe coolant;

        FluidBurnerRecipeWrapper(FluidBurnerFuelRecipe fuel, FluidBurnerCoolantRecipe coolant) {
            this.fuel = fuel;
            this.coolant = coolant;
        }

        public void getIngredients(IIngredients ingredients) {
            if (this.coolant == null) {
                ingredients.setInput(FluidStack.class, (Object)new FluidStack(this.fuel.fluid, this.fuel.amount));
            } else {
                ingredients.setInputs(FluidStack.class, (List)Lists.newArrayList((Object[])new FluidStack[]{new FluidStack(this.fuel.fluid, this.fuel.amount), new FluidStack(this.coolant.fluid, this.coolant.amount)}));
            }
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            int ticks = this.fuel.baseTicks;
            if (this.coolant != null) {
                ticks = Math.round((float)ticks * this.coolant.timeMultiplier);
            }
            String duration = String.format("%,d ticks", ticks);
            String power = String.format("%,d T", ticks * 80);
            minecraft.field_71466_p.func_78276_b(duration, 36, 12, 32639);
            minecraft.field_71466_p.func_78276_b(power, 36, 12 + minecraft.field_71466_p.field_78288_b, 32639);
        }
    }
}

