/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.integrations.jei;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.common.BlocksRegistry;
import net.ndrei.teslapoweredthingies.machines.fluidsolidifier.FluidSolidifierResult;

public class FluidSolidifierCategory
extends BlankRecipeCategory<FluidSolidifierRecipeWrapper> {
    public static final String UID = "FluidSolidifier";
    private IDrawable background = null;
    private IDrawable lavaOverlay = null;
    private IDrawable waterOverlay = null;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidSolidifierCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)BlocksRegistry.fluidSolidifier), new String[]{UID});
        registry.handleRecipes(FluidSolidifierResult.class, FluidSolidifierRecipeWrapper::new, UID);
        registry.addRecipes((Collection)Lists.newArrayList((Object[])FluidSolidifierResult.VALUES), UID);
    }

    public FluidSolidifierCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TeslaThingiesMod.JEI_TEXTURES, 0, 132, 124, 66);
        this.lavaOverlay = guiHelper.createDrawable(TeslaThingiesMod.JEI_TEXTURES, 8, 147, 8, 27);
        this.waterOverlay = guiHelper.createDrawable(TeslaThingiesMod.JEI_TEXTURES, 20, 147, 8, 27);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return BlocksRegistry.fluidSolidifier.func_149732_F();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidSolidifierRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        fluids.init(0, true, 8, 15, 8, 27, ((FluidSolidifierRecipeWrapper)recipeWrapper).recipe.lavaMbMin, true, this.lavaOverlay);
        fluids.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        fluids.init(1, true, 20, 15, 8, 27, ((FluidSolidifierRecipeWrapper)recipeWrapper).recipe.waterMbMin, true, this.waterOverlay);
        fluids.set(1, (List)ingredients.getInputs(FluidStack.class).get(1));
        fluids.init(2, true, 43, 15, 8, 27, ((FluidSolidifierRecipeWrapper)recipeWrapper).recipe.lavaMbMin, true, this.lavaOverlay);
        fluids.set(2, new FluidStack(FluidRegistry.LAVA, ((FluidSolidifierRecipeWrapper)recipeWrapper).recipe.lavaMbConsumed));
        fluids.init(3, true, 55, 15, 8, 27, ((FluidSolidifierRecipeWrapper)recipeWrapper).recipe.waterMbMin, true, this.waterOverlay);
        fluids.set(3, new FluidStack(FluidRegistry.WATER, ((FluidSolidifierRecipeWrapper)recipeWrapper).recipe.waterMbConsumed));
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, false, 77, 20);
        stacks.set(0, ((FluidSolidifierRecipeWrapper)recipeWrapper).recipe.resultStack);
    }

    public static class FluidSolidifierRecipeWrapper
    extends BlankRecipeWrapper {
        private FluidSolidifierResult recipe;

        FluidSolidifierRecipeWrapper(FluidSolidifierResult recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(FluidStack.class, (List)Lists.newArrayList((Object[])new FluidStack[]{new FluidStack(FluidRegistry.LAVA, this.recipe.lavaMbMin), new FluidStack(FluidRegistry.WATER, this.recipe.waterMbMin)}));
            ingredients.setOutput(ItemStack.class, (Object)this.recipe.resultStack);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            String required = "required";
            String consumed = "consumed";
            minecraft.field_71466_p.func_78276_b(required, 18 - minecraft.field_71466_p.func_78256_a(required) / 2, 8 - minecraft.field_71466_p.field_78288_b, 0x424242);
            minecraft.field_71466_p.func_78276_b(consumed, 54 - minecraft.field_71466_p.func_78256_a(consumed) / 2, 47, 0x424242);
        }
    }
}

